/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.event.LayoutEvents;
import com.vaadin.server.Resource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Collections;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsGroupEditDialog;
import org.opencms.ui.apps.user.CmsOUEditDialog;
import org.opencms.ui.apps.user.CmsUserEditDialog;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;

public class CmsNewElementDialog
extends CmsBasicDialog {
    private static String ID_USER = "user";
    private static String ID_GROUP = "group";
    private static String ID_OU = "ou";
    private static final long serialVersionUID = 2351253053915340926L;
    private VerticalLayout m_container;
    private Button m_cancelButton;
    private Window m_window;
    private CmsObject m_cms;
    private Label m_ouLabel;
    private String m_ou;
    private CmsAccountsApp m_app;

    public CmsNewElementDialog(CmsObject cms, String ou, final Window window, CmsAccountsApp app) {
        this.m_app = app;
        this.m_window = window;
        this.m_cms = cms;
        this.m_ou = ou;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        try {
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getOUInfo(OpenCms.getOrgUnitManager().readOrganizationalUnit(A_CmsUI.getCmsObject(), ou))));
            this.m_ouLabel.setValue(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, ou).getDisplayName(this.m_cms.getRequestContext().getLocale()));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -7494631798452339165L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        CmsResourceInfo newUser = new CmsResourceInfo(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_USER_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_USER_HELP_0", new Object[0]), (Resource)new CmsCssIcon("oc-icon-24-user"));
        newUser.setData(ID_USER);
        CmsResourceInfo newGroup = new CmsResourceInfo(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_GROUP_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_GROUP_HELP_0", new Object[0]), (Resource)new CmsCssIcon("oc-icon-24-group"));
        newGroup.setData(ID_GROUP);
        if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ADMINISTRATOR.forOrgUnit(ou))) {
            CmsResourceInfo newOU = new CmsResourceInfo(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_OU_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_OU_HELP_0", new Object[0]), (Resource)new CmsCssIcon("oc-icon-24-orgunit"));
            newOU.setData(ID_OU);
            this.m_container.addComponent((Component)newOU);
        }
        this.m_container.addComponent((Component)newUser);
        this.m_container.addComponent((Component)newGroup);
        this.m_container.addLayoutClickListener(new LayoutEvents.LayoutClickListener(){
            private static final long serialVersionUID = 5189868437695349511L;

            public void layoutClick(LayoutEvents.LayoutClickEvent event) {
                AbstractComponent component = (AbstractComponent)event.getChildComponent();
                if (component != null && component.getData() instanceof String) {
                    CmsNewElementDialog.this.openNewDialog((String)component.getData());
                }
            }
        });
    }

    protected void openNewDialog(String id) {
        CmsBasicDialog dialog = null;
        String caption = "";
        if (id.equals(ID_GROUP)) {
            dialog = new CmsGroupEditDialog(this.m_cms, this.m_window, this.m_ou, this.m_app);
            caption = CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_GROUP_0", new Object[0]);
        }
        if (id.equals(ID_OU)) {
            dialog = new CmsOUEditDialog(this.m_cms, this.m_window, this.m_ou, this.m_app);
            caption = CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_OU_0", new Object[0]);
        }
        if (id.equals(ID_USER)) {
            dialog = new CmsUserEditDialog(this.m_cms, this.m_window, this.m_ou, this.m_app);
            caption = CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_USER_0", new Object[0]);
        }
        if (dialog != null) {
            this.m_window.setContent((Component)dialog);
            this.m_window.setCaption(caption);
            this.m_window.center();
        }
    }
}

