/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.security.CmsPasswordEncryptionException;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.user.CmsUserEditDialog;
import org.opencms.util.CmsUUID;

public class CmsImportUserThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsImportUserThread.class);
    private List<CmsUser> m_userList;
    private List<CmsRole> m_roleList;
    private List<String> m_groupList;
    private String m_ou;
    private boolean m_sendMail;

    protected CmsImportUserThread(CmsObject cms, String ou, List<CmsUser> userList, List<String> groups, List<CmsRole> roles, boolean sendmail) {
        super(cms, "importUser");
        this.m_userList = userList;
        this.m_roleList = roles;
        this.m_groupList = groups;
        this.m_ou = ou;
        this.m_sendMail = sendmail;
        this.initHtmlReport(A_CmsUI.get().getLocale());
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        this.getReport().println(Messages.get().container("RPT_USERIMPORT_BEGIN_0"), 2);
        this.getReport().println();
        this.getReport().println(Messages.get().container("RPT_USERIMPORT_FILE_CONTAINS_1", String.valueOf(this.m_userList.size())), 0);
        for (CmsUser user : this.m_userList) {
            CmsPrincipal createdUser = null;
            if (!this.isAlreadyAvailable(user.getName())) {
                String password = user.getPassword();
                if (password.indexOf("_") == -1) {
                    try {
                        password = OpenCms.getPasswordHandler().digest(password);
                        if (this.m_sendMail) {
                            CmsUserEditDialog.sendMail(this.getCms(), user.getPassword(), user, this.m_ou, true, false);
                        }
                    }
                    catch (CmsPasswordEncryptionException cmsPasswordEncryptionException) {}
                } else {
                    password = password.substring(password.indexOf("_") + 1);
                    if (this.m_sendMail) {
                        CmsUserEditDialog.sendMail(this.getCms(), "your old password", user, this.m_ou, true, false);
                    }
                }
                try {
                    createdUser = this.getCms().importUser(new CmsUUID().toString(), this.m_ou + user.getName(), password, user.getFirstname(), user.getLastname(), user.getEmail(), user.getFlags(), System.currentTimeMillis(), user.getAdditionalInfo());
                    if (!this.m_groupList.isEmpty()) {
                        Iterator<String> itGroups = this.m_groupList.iterator();
                        while (itGroups.hasNext()) {
                            try {
                                this.getCms().addUserToGroup(createdUser.getName(), itGroups.next());
                            }
                            catch (CmsException cmsException) {}
                        }
                    }
                    if (!this.m_roleList.isEmpty()) {
                        Iterator<CmsRole> itRoles = this.m_roleList.iterator();
                        while (itRoles.hasNext()) {
                            OpenCms.getRoleManager().addUserToRole(this.getCms(), itRoles.next().forOrgUnit(this.m_ou), createdUser.getName());
                        }
                    }
                    String startAppId = "pageeditor";
                    if (OpenCms.getRoleManager().hasRole(this.getCms(), createdUser.getName(), CmsRole.WORKPLACE_USER)) {
                        startAppId = "explorer";
                    }
                    CmsUserSettings settings = new CmsUserSettings((CmsUser)createdUser);
                    settings.setStartView(startAppId);
                    settings.setStartProject("Offline");
                    settings.save(this.getCms());
                }
                catch (CmsException e) {
                    LOG.error((Object)"Unable to create user", (Throwable)e);
                }
                if (createdUser == null) continue;
                this.getReport().println(Messages.get().container("RPT_USERIMPORT_IMPORT_SUCCESFULL_1", createdUser.getName()), 4);
                continue;
            }
            this.getReport().println(Messages.get().container("RPT_USERIMPORT_IMPORT_ALREADY_IN_OU_1", user.getName()), 5);
        }
        this.getReport().println(Messages.get().container("RPT_USERIMPORT_END_0"), 0);
    }

    protected boolean isAlreadyAvailable(String userName) {
        List<Object> availableUsers;
        try {
            availableUsers = OpenCms.getOrgUnitManager().getUsers(this.getCms(), this.m_ou, false);
        }
        catch (CmsException e) {
            availableUsers = new ArrayList();
        }
        Iterator itAvailableUsers = availableUsers.iterator();
        while (itAvailableUsers.hasNext()) {
            if (!userName.equals(((CmsUser)itAvailableUsers.next()).getSimpleName())) continue;
            return true;
        }
        return false;
    }
}

