/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.vaadin.data.HasValue;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.A_CmsImportExportUserDialog;
import org.opencms.ui.apps.user.CmsGeneratePasswordDialog;
import org.opencms.ui.apps.user.CmsImportUserThread;
import org.opencms.ui.apps.user.CmsShowReportDialog;
import org.opencms.ui.apps.user.CmsUserEditDialog;
import org.opencms.ui.apps.user.I_CmsPasswordFetcher;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsXsltUtil;

public final class CmsImportExportUserDialog
extends A_CmsImportExportUserDialog
implements Upload.Receiver,
I_CmsPasswordFetcher {
    private static final String BOM = "\ufeff";
    public static final String DIALOG_HEIGHT = "650px";
    static final Log LOG = CmsLog.getLog(CmsImportExportUserDialog.class);
    private static final long serialVersionUID = -2055302491540892101L;
    protected Label m_uploadname;
    Button m_startImport;
    private Panel m_includeTechnicalFieldsPanel;
    private CheckBox m_includeTechnicalFields;
    private Button m_cancel;
    private CmsObject m_cms;
    private Button m_download;
    private VerticalLayout m_exportGroups;
    private CmsEditableGroup m_exportGroupsGroup;
    private VerticalLayout m_exportRoles;
    private CmsEditableGroup m_exportRolesGroup;
    private Button m_generateButton;
    private boolean m_groupEditable = true;
    private CmsUUID m_groupID;
    private ByteArrayOutputStream m_importFileStream;
    private VerticalLayout m_importGroups;
    private CmsEditableGroup m_importGroupsGroup;
    private CheckBox m_importPasswords;
    private VerticalLayout m_importRoles;
    private CmsEditableGroup m_importRolesGroup;
    private TextField m_password;
    List<CmsUser> m_userImportList;
    private CheckBox m_sendMail;
    private TabSheet m_tab;
    private Upload m_upload;

    private CmsImportExportUserDialog(final String ou, CmsUUID groupID, Window window, boolean allowTechnicalFieldsExport) {
        this.setHeight(DIALOG_HEIGHT);
        this.m_groupID = groupID;
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_includeTechnicalFieldsPanel.setVisible(allowTechnicalFieldsExport);
        this.m_includeTechnicalFields.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<Boolean>(){

            public void valueChange(HasValue.ValueChangeEvent event) {
                CmsImportExportUserDialog.this.initDownloadButton();
            }
        });
        this.m_importPasswords.setValue(Boolean.TRUE);
        this.m_sendMail.setValue(Boolean.TRUE);
        this.setButtonVisibility(0);
        this.m_tab.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener & Serializable)event -> this.setButtonVisibility(this.m_tab.getTabPosition(this.m_tab.getTab(this.m_tab.getSelectedTab()))));
        this.m_password.setValue(CmsGeneratePasswordDialog.getRandomPassword());
        this.m_startImport.setEnabled(false);
        this.m_startImport.addClickListener((Button.ClickListener & Serializable)event -> this.importUserFromFile());
        this.m_generateButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 4128513094772586752L;

            public void buttonClick(Button.ClickEvent event) {
                final Window windowDialog = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.content);
                windowDialog.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GEN_PASSWORD_CAPTION_0", new Object[0]));
                CmsGeneratePasswordDialog dialog = new CmsGeneratePasswordDialog(CmsImportExportUserDialog.this, new Runnable(){

                    @Override
                    public void run() {
                        windowDialog.close();
                    }
                });
                windowDialog.setContent((Component)dialog);
                A_CmsUI.get().addWindow(windowDialog);
            }
        });
        this.m_upload.setReceiver((Upload.Receiver)this);
        this.m_upload.addSucceededListener(new Upload.SucceededListener(){
            private static final long serialVersionUID = -6865652127878123021L;

            public void uploadSucceeded(Upload.SucceededEvent event) {
                try {
                    CmsImportExportUserDialog.this.m_userImportList = CmsImportExportUserDialog.this.getUsersFromFile();
                    CmsImportExportUserDialog.this.m_startImport.setEnabled(true);
                    CmsImportExportUserDialog.this.m_uploadname.setValue(event.getFilename());
                }
                catch (Exception e) {
                    CmsImportExportUserDialog.this.m_startImport.setEnabled(false);
                    CmsImportExportUserDialog.this.m_uploadname.setValue("");
                    CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_INVALID_FILE_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_INVALID_CSV_0", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            }
        });
        if (groupID == null) {
            this.m_importGroupsGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_importGroups, new Supplier<Component>(){

                public Component get() {
                    return CmsImportExportUserDialog.this.getGroupSelect(ou, true, null);
                }
            }, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_ADD_GROUP_0", new Object[0]));
            this.m_importGroupsGroup.init();
            this.m_exportGroupsGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_exportGroups, new Supplier<Component>(){

                public Component get() {
                    return CmsImportExportUserDialog.this.getGroupSelect(ou, true, null);
                }
            }, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_ADD_GROUP_0", new Object[0]));
            this.m_exportGroupsGroup.init();
        } else {
            this.m_exportGroups.addComponent((Component)this.getGroupSelect(ou, false, groupID));
            this.m_importGroups.addComponent((Component)this.getGroupSelect(ou, false, groupID));
        }
        this.m_importRolesGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_importRoles, new Supplier<Component>(){

            public Component get() {
                return CmsImportExportUserDialog.this.getRoleComboBox(ou);
            }
        }, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_ADD_ROLE_0", new Object[0]));
        this.m_importRolesGroup.init();
        this.m_exportRolesGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_exportRoles, new Supplier<Component>(){

            public Component get() {
                return CmsImportExportUserDialog.this.getRoleComboBox(ou);
            }
        }, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_ADD_ROLE_0", new Object[0]));
        this.m_exportRolesGroup.init();
        super.init(ou, window);
    }

    public static Map<CmsUUID, CmsUser> addExportAllUsers(CmsObject cms, String ou, Map<CmsUUID, CmsUser> exportUsers) throws CmsException {
        List<CmsUser> users = OpenCms.getOrgUnitManager().getUsers(cms, ou, false);
        if (users != null && users.size() > 0) {
            for (CmsUser user : users) {
                if (exportUsers.containsKey(user.getId())) continue;
                exportUsers.put(user.getId(), user);
            }
        }
        return exportUsers;
    }

    public static Map<CmsUUID, CmsUser> addExportUsersFromGroups(CmsObject cms, List<String> groups, Map<CmsUUID, CmsUser> exportUsers) throws CmsException {
        if (groups != null && groups.size() > 0) {
            Iterator<String> itGroups = groups.iterator();
            while (itGroups.hasNext()) {
                List<CmsUser> groupUsers = cms.getUsersOfGroup(itGroups.next());
                for (CmsUser groupUser : groupUsers) {
                    if (exportUsers.containsKey(groupUser.getId())) continue;
                    exportUsers.put(groupUser.getId(), groupUser);
                }
            }
        }
        return exportUsers;
    }

    public static Map<CmsUUID, CmsUser> addExportUsersFromRoles(CmsObject cms, String ou, List<String> roles, Map<CmsUUID, CmsUser> exportUsers) throws CmsException {
        if (roles != null && roles.size() > 0) {
            Iterator<String> itRoles = roles.iterator();
            while (itRoles.hasNext()) {
                List<CmsUser> roleUsers = OpenCms.getRoleManager().getUsersOfRole(cms, CmsRole.valueOfGroupName(itRoles.next()).forOrgUnit(ou), true, false);
                for (CmsUser roleUser : roleUsers) {
                    if (exportUsers.get(roleUser.getId()) != null) continue;
                    exportUsers.put(roleUser.getId(), roleUser);
                }
            }
        }
        return exportUsers;
    }

    public static CmsImportExportUserDialog getExportUserDialogForGroup(CmsUUID groupID, String ou, Window window, boolean allowTechnicalFieldsExport) {
        CmsImportExportUserDialog res = new CmsImportExportUserDialog(ou, groupID, window, allowTechnicalFieldsExport);
        return res;
    }

    public static CmsImportExportUserDialog getExportUserDialogForOU(String ou, Window window, boolean allowTechnicalFieldsExport) {
        CmsImportExportUserDialog res = new CmsImportExportUserDialog(ou, null, window, allowTechnicalFieldsExport);
        return res;
    }

    @Override
    public void fetchPassword(String password) {
        this.m_password.setValue(password);
    }

    public OutputStream receiveUpload(String filename, String mimeType) {
        this.m_importFileStream = new ByteArrayOutputStream();
        return this.m_importFileStream;
    }

    protected CmsPrincipalSelect getGroupSelect(String ou, boolean enabled, CmsUUID groupID) {
        CmsPrincipalSelect select = new CmsPrincipalSelect();
        select.setOU(ou);
        select.setEnabled(enabled);
        select.setRealPrincipalsOnly(true);
        select.setPrincipalType("GROUP");
        select.setWidgetType(CmsPrincipalSelect.WidgetType.groupwidget);
        if (groupID != null) {
            try {
                select.setValue(this.m_cms.readGroup(groupID).getName());
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read group", (Throwable)e);
            }
        }
        return select;
    }

    protected ComboBox<CmsRole> getRoleComboBox(String ou) {
        ComboBox box = new ComboBox();
        CmsUserEditDialog.iniRole(A_CmsUI.getCmsObject(), ou, (ComboBox<CmsRole>)box, null);
        box.setSelectedItem((Object)CmsRole.EDITOR.forOrgUnit(ou));
        return box;
    }

    protected List<CmsUser> getUsersFromFile() {
        String separator = null;
        ArrayList<String> values = null;
        ArrayList<CmsUser> users = null;
        boolean keepPasswordIfPossible = this.m_importPasswords.getValue();
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.m_importFileStream.toByteArray())));
            boolean headline = true;
            boolean hasBOM = false;
            while ((line = bufferedReader.readLine()) != null) {
                if (users == null) {
                    users = new ArrayList<CmsUser>();
                }
                if (separator == null) {
                    separator = CmsXsltUtil.getPreferredDelimiter(line);
                }
                List lineValues = Splitter.on(separator).splitToList((CharSequence)line);
                if (headline) {
                    values = new ArrayList<String>();
                    for (String va : lineValues) {
                        if (va.startsWith(BOM) && va.substring(1, 2).equals("\"")) {
                            hasBOM = true;
                            va = va.substring(1);
                        }
                        if (hasBOM) {
                            va = va.substring(1, va.length() - 1);
                        }
                        values.add(va);
                    }
                    headline = false;
                    continue;
                }
                if (values == null) continue;
                CmsUser curUser = new CmsUser();
                try {
                    for (int i = 0; i < values.size(); ++i) {
                        String curValue = (String)values.get(i);
                        try {
                            Method method = CmsUser.class.getMethod("set" + curValue.substring(0, 1).toUpperCase() + curValue.substring(1), String.class);
                            String value = "";
                            if (lineValues.size() > i && lineValues.get(i) != null) {
                                value = (String)lineValues.get(i);
                                if (hasBOM) {
                                    value = value.substring(1, value.length() - 1);
                                }
                            }
                            if (curValue.equals("password") && CmsStringUtil.isEmptyOrWhitespaceOnly(value) | !keepPasswordIfPossible) {
                                value = this.m_password.getValue();
                            }
                            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value) || value.equals("null")) continue;
                            method.invoke((Object)curUser, value);
                            continue;
                        }
                        catch (NoSuchMethodException ne) {
                            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)lineValues.get(i))) continue;
                            curUser.setAdditionalInfo(curValue, lineValues.get(i));
                            continue;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            continue;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                }
                catch (CmsRuntimeException cmsRuntimeException) {
                    // empty catch block
                }
                users.add(curUser);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return users;
    }

    protected void importUserFromFile() {
        CmsImportUserThread thread = new CmsImportUserThread(this.m_cms, this.m_ou, this.m_userImportList, this.getGroupsList(this.m_importGroups, true), this.getRolesList(this.m_importRoles, true), this.m_sendMail.getValue());
        thread.start();
        CmsShowReportDialog dialog = new CmsShowReportDialog(thread, new Runnable(){

            @Override
            public void run() {
                CmsImportExportUserDialog.this.m_window.close();
            }
        });
        this.m_window.setContent((Component)dialog);
    }

    @Override
    Button getCloseButton() {
        return this.m_cancel;
    }

    @Override
    Button getDownloadButton() {
        return this.m_download;
    }

    @Override
    Map<CmsUUID, CmsUser> getUserToExport() {
        List<String> groups = this.getGroupsList(this.m_exportGroups, false);
        Iterator<I_CmsEditableGroupRow> it = this.m_exportRolesGroup.getRows().iterator();
        ArrayList<String> roles = new ArrayList<String>();
        while (it.hasNext()) {
            CmsRole role = (CmsRole)((ComboBox)it.next().getComponent()).getValue();
            roles.add(role.getGroupName());
        }
        Map<CmsUUID, CmsUser> exportUsers = new HashMap<CmsUUID, CmsUser>();
        try {
            if (groups.size() < 1 && roles.size() < 1) {
                exportUsers = CmsImportExportUserDialog.addExportAllUsers(this.m_cms, this.m_ou, exportUsers);
            } else {
                exportUsers = CmsImportExportUserDialog.addExportUsersFromGroups(this.m_cms, groups, exportUsers);
                exportUsers = CmsImportExportUserDialog.addExportUsersFromRoles(this.m_cms, this.m_ou, roles, exportUsers);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to get export user list.", (Throwable)e);
        }
        return exportUsers;
    }

    @Override
    boolean isExportWithTechnicalFields() {
        return this.m_includeTechnicalFields.getValue();
    }

    private List<String> getGroupsList(VerticalLayout parent, boolean importCase) {
        ArrayList<String> res = new ArrayList<String>();
        if (this.m_groupID != null) {
            try {
                res.add(this.m_cms.readGroup(this.m_groupID).getName());
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read group", (Throwable)e);
            }
            return res;
        }
        if (this.m_groupEditable) {
            CmsEditableGroup editableGroup = importCase ? this.m_importGroupsGroup : this.m_exportGroupsGroup;
            for (I_CmsEditableGroupRow row : editableGroup.getRows()) {
                String groupName = ((CmsPrincipalSelect)row.getComponent()).getValue();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(groupName)) continue;
                res.add(groupName);
            }
        } else {
            TextField comp = (TextField)parent.getComponent(0);
            res.add(comp.getValue());
        }
        return res;
    }

    private List<CmsRole> getRolesList(VerticalLayout parent, boolean importCase) {
        ArrayList<CmsRole> res = new ArrayList<CmsRole>();
        CmsEditableGroup editableGroup = importCase ? this.m_importRolesGroup : this.m_exportRolesGroup;
        for (I_CmsEditableGroupRow row : editableGroup.getRows()) {
            res.add((CmsRole)((ComboBox)row.getComponent()).getValue());
        }
        return res;
    }

    private void setButtonVisibility(int tab) {
        this.m_download.setVisible(tab == 1);
        this.m_startImport.setVisible(tab == 0);
    }
}

