/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsResourceInfoTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsDeleteMultiplePrincipalDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsDeleteMultiplePrincipalDialog.class);
    private static final long serialVersionUID = -1191281655158071555L;
    private Label m_icon;
    private Label m_icon2;
    Button m_okButton;
    CmsObject m_cms;
    private Label m_label;
    Button m_cancelButton;
    private Set<String> m_ids;
    private Set<CmsUUID> m_userIDs;
    private Set<CmsUUID> m_groupIDs;
    private Panel m_dependencyPanel;
    private HorizontalLayout m_label_deleteDefault;
    private HorizontalLayout m_deleteConfirm;
    private CmsPrincipalSelect m_principalSelect;
    private VerticalLayout m_principalSelectLayout;

    public CmsDeleteMultiplePrincipalDialog(CmsObject cms, Set<String> context, Window window, CmsAccountsApp app) {
        this.init(cms, window, app);
        boolean defaultUser = false;
        this.m_ids = context;
        this.m_groupIDs = new HashSet<CmsUUID>();
        this.m_userIDs = new HashSet<CmsUUID>();
        ArrayList<CmsResourceInfo> infos = new ArrayList<CmsResourceInfo>();
        for (String id : this.m_ids) {
            try {
                CmsPrincipal principal = (CmsPrincipal)CmsPrincipal.readPrincipal(cms, new CmsUUID(id));
                if (OpenCms.getDefaultUsers().isDefaultUser(principal.getName()) || OpenCms.getDefaultUsers().isDefaultGroup(principal.getName())) {
                    defaultUser = true;
                    continue;
                }
                infos.add(CmsAccountsApp.getPrincipalInfo(CmsPrincipal.readPrincipal(cms, new CmsUUID(id))));
                if (principal instanceof CmsGroup) {
                    this.m_groupIDs.add(new CmsUUID(id));
                    continue;
                }
                this.m_userIDs.add(new CmsUUID(id));
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read Principal.", (Throwable)e);
            }
        }
        this.displayResourceInfoDirectly(infos);
        String labelMessage = this.m_userIDs.isEmpty() ? "GUI_USERMANAGEMENT_GROUP_DELETE_MULTIPLE_0" : "GUI_USERMANAGEMENT_USER_DELETE_MULTIPLE_0";
        this.m_label_deleteDefault.setVisible(defaultUser && this.m_userIDs.isEmpty() && this.m_groupIDs.isEmpty());
        this.m_label.setValue(CmsVaadinUtils.getMessageText(labelMessage, new Object[0]));
        CmsResourceInfoTable table = new CmsResourceInfoTable(this.m_cms, this.m_userIDs, this.m_groupIDs);
        table.setHeight("300px");
        table.setWidth("100%");
        this.m_dependencyPanel.setVisible(table.size() > 0);
        this.m_principalSelectLayout.setVisible(table.size() > 0);
        this.m_okButton.setVisible(!this.m_userIDs.isEmpty() || !this.m_groupIDs.isEmpty());
        this.m_deleteConfirm.setVisible(!this.m_userIDs.isEmpty() || !this.m_groupIDs.isEmpty());
        if (this.m_dependencyPanel.isVisible()) {
            this.m_dependencyPanel.setContent((Component)table);
            this.m_principalSelect.setRealPrincipalsOnly(true);
            if (this.m_userIDs.size() == 0 | this.m_groupIDs.size() == 0) {
                this.m_principalSelect.setWidgetType(this.m_userIDs.size() > 0 ? CmsPrincipalSelect.WidgetType.userwidget : CmsPrincipalSelect.WidgetType.groupwidget);
                this.m_principalSelect.setPrincipalType(this.m_userIDs.size() > 0 ? "USER" : "GROUP");
            } else {
                this.m_principalSelect.setWidgetType(CmsPrincipalSelect.WidgetType.principalwidget);
            }
        }
    }

    protected void deletePrincipal() {
        try {
            String principalNameToCopyTo = this.m_principalSelect.getValue();
            I_CmsPrincipal principalTarget = null;
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(principalNameToCopyTo)) {
                principalTarget = CmsPrincipal.readPrincipal(this.m_cms, principalNameToCopyTo);
            }
            for (CmsUUID id : this.m_groupIDs) {
                this.m_cms.deleteGroup(id, principalTarget != null ? principalTarget.getId() : null);
            }
            for (CmsUUID id : this.m_userIDs) {
                this.m_cms.deleteUser(id, principalTarget != null ? principalTarget.getId() : null);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to delete principal", (Throwable)e);
        }
    }

    private void init(CmsObject cms, final Window window, final CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_icon.setContentMode(ContentMode.HTML);
        this.m_icon.setValue(FontOpenCms.WARNING.getHtml());
        this.m_icon2.setContentMode(ContentMode.HTML);
        this.m_icon2.setValue(FontOpenCms.WARNING.getHtml());
        this.m_label_deleteDefault.setVisible(false);
        this.m_cms = cms;
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -7845894751587879028L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDeleteMultiplePrincipalDialog.this.deletePrincipal();
                window.close();
                app.reload();
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 6649262870116199591L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
    }
}

