/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.google.common.base.Supplier;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.TextField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsAdditionalInfosDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 9007206105761103873L;
    private static final Log LOG = CmsLog.getLog(CmsAdditionalInfosDialog.class);
    private CmsUser m_user;
    private FormLayout m_layout;
    private FormLayout m_layoutnoedit;
    private Button m_cancel;
    private Button m_ok;
    private SortedMap<String, Object> m_addInfoEditable;
    private SortedMap<String, Object> m_addInfoReadOnly;
    private CmsEditableGroup m_userinfoGroup;
    private CmsEditableGroup m_userinfoNoEditGroup;
    private CmsObject m_cms;

    public CmsAdditionalInfosDialog(CmsObject cms, CmsUUID userID, final Window window, final CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_cms = cms;
        try {
            this.m_user = cms.readUser(userID);
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getPrincipalInfo(this.m_user)));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.setAddInfoMaps();
        Supplier<Component> fieldFactory = new Supplier<Component>(){

            public Component get() {
                return CmsAdditionalInfosDialog.this.addInfoLayout("", "", true);
            }
        };
        this.m_userinfoGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_layout, fieldFactory, "Add");
        this.m_userinfoGroup.init();
        this.m_userinfoNoEditGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_layoutnoedit, fieldFactory, "Add");
        this.m_userinfoNoEditGroup.setAddButtonVisible(false);
        this.m_userinfoNoEditGroup.init();
        for (String info : this.m_addInfoEditable.keySet()) {
            this.addAddInfoLayout(info, this.m_addInfoEditable.get(info), true);
        }
        for (String info : this.m_addInfoReadOnly.keySet()) {
            this.addAddInfoLayout(info, this.m_addInfoReadOnly.get(info), false);
        }
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_ADDITIONAL_INFOS_WINDOW_CAPTION_1", this.m_user.getSimpleName()));
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 4879585408645749L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -5168099515616397665L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAdditionalInfosDialog.this.submit();
                window.close();
                app.reload();
            }
        });
    }

    protected void submit() {
        if (this.m_userinfoNoEditGroup.getRows().size() != this.m_addInfoReadOnly.size()) {
            Iterator<String> currentKeys = this.getKeyListFromGroup(this.m_userinfoNoEditGroup);
            for (String key : this.m_addInfoReadOnly.keySet()) {
                if (currentKeys.contains(key)) continue;
                this.saveAddInfo(key, null);
            }
        }
        for (I_CmsEditableGroupRow row : this.m_userinfoGroup.getRows()) {
            String key;
            key = (String)((TextField)((HorizontalLayout)row.getComponent()).getComponent(0)).getValue();
            String value = (String)((TextField)((HorizontalLayout)row.getComponent()).getComponent(1)).getValue();
            this.saveAddInfo(key, value);
            this.m_addInfoEditable.remove(key);
        }
        for (String key : this.m_addInfoEditable.keySet()) {
            this.saveAddInfo(key, null);
        }
        try {
            this.m_cms.writeUser(this.m_user);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to write user.", (Throwable)e);
        }
    }

    HorizontalLayout addInfoLayout(String key, Object value, boolean editable) {
        HorizontalLayout res = new HorizontalLayout();
        res.setWidth("100%");
        res.setSpacing(true);
        TextField keyField = new TextField();
        keyField.setValue(key);
        keyField.setEnabled(editable);
        keyField.setWidth("100%");
        TextField valueField = new TextField();
        valueField.setValue(value.toString());
        valueField.setEnabled(editable);
        valueField.setWidth("100%");
        res.addComponent((Component)keyField);
        res.addComponent((Component)valueField);
        res.setExpandRatio((Component)keyField, 1.0f);
        res.setExpandRatio((Component)valueField, 1.0f);
        return res;
    }

    private void addAddInfoLayout(String key, Object value, boolean editable) {
        HorizontalLayout res = this.addInfoLayout(key, value, editable);
        if (editable) {
            this.m_userinfoGroup.addRow((Component)res);
        } else {
            this.m_userinfoNoEditGroup.addRow((Component)res);
        }
    }

    private List<String> getKeyListFromGroup(CmsEditableGroup group) {
        ArrayList<String> res = new ArrayList<String>();
        for (I_CmsEditableGroupRow row : group.getRows()) {
            res.add((String)((TextField)((HorizontalLayout)row.getComponent()).getComponent(0)).getValue());
        }
        return res;
    }

    private void saveAddInfo(String key, String value) {
        Class<Object> clazz;
        int pos = key.indexOf("@");
        String className = "";
        if (pos > -1) {
            className = key.substring(pos + 1);
            key = key.substring(0, pos);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            this.m_user.deleteAdditionalInfo(key);
            return;
        }
        if (pos < 0) {
            this.m_user.setAdditionalInfo(key, value);
            return;
        }
        try {
            clazz = Class.forName(className);
        }
        catch (Throwable e) {
            try {
                clazz = Class.forName(Integer.class.getPackage().getName() + "." + className);
            }
            catch (Throwable e1) {
                clazz = String.class;
            }
        }
        this.m_user.setAdditionalInfo(key, CmsDataTypeUtil.parse(value, clazz));
    }

    private void setAddInfoMaps() {
        this.m_addInfoEditable = new TreeMap<String, Object>();
        this.m_addInfoReadOnly = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.m_user.getAdditionalInfo().entrySet()) {
            Object key = entry.getKey().toString();
            if (entry.getValue() == null || CmsStringUtil.isEmptyOrWhitespaceOnly(entry.getValue().toString())) continue;
            if (!entry.getValue().getClass().equals(String.class)) {
                key = (String)key + "@" + entry.getValue().getClass().getName();
            }
            if (CmsDataTypeUtil.isParseable(entry.getValue().getClass())) {
                this.m_addInfoEditable.put((String)key, entry.getValue());
                continue;
            }
            Object value = entry.getValue().toString();
            if (((String)value).length() > 75 - ((String)key).length()) {
                value = 75 - ((String)key).length() > 5 ? ((String)value).substring(0, 75 - ((String)key).length()) + " ..." : "...";
            }
            this.m_addInfoReadOnly.put((String)key, value);
        }
    }
}

