/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsUserIconHelper;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.user.CmsDefaultTreeTypeProvider;
import org.opencms.ui.apps.user.CmsGroupEditParameters;
import org.opencms.ui.apps.user.CmsGroupTable;
import org.opencms.ui.apps.user.CmsNewElementDialog;
import org.opencms.ui.apps.user.CmsOUHandler;
import org.opencms.ui.apps.user.CmsOUTable;
import org.opencms.ui.apps.user.CmsOuTree;
import org.opencms.ui.apps.user.CmsOuTreeType;
import org.opencms.ui.apps.user.CmsRoleTable;
import org.opencms.ui.apps.user.CmsUserCsvExportDialog;
import org.opencms.ui.apps.user.CmsUserEditParameters;
import org.opencms.ui.apps.user.CmsUserTable;
import org.opencms.ui.apps.user.I_CmsFilterableTable;
import org.opencms.ui.apps.user.I_CmsOuTreeType;
import org.opencms.ui.apps.user.I_CmsToggleTable;
import org.opencms.ui.apps.user.I_CmsTreeTypeProvider;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsInfoButton;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelectDialog;
import org.opencms.ui.dialogs.permissions.I_CmsPrincipalSelect;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsAccountsApp
extends A_CmsWorkplaceApp
implements I_CmsPrincipalSelect {
    public static String STATE_SEPERATOR = "!!";
    private static final CmsDefaultTreeTypeProvider DEFAULT_TREETYPES = new CmsDefaultTreeTypeProvider();
    private static final Log LOG = CmsLog.getLog(CmsAccountsApp.class);
    protected Button m_addElementButton;
    protected CmsObject m_cms;
    protected Button m_importExport;
    protected CmsInfoButton m_infoButton;
    protected Button m_newButton;
    protected Button m_toggleButtonGroups;
    protected Button m_toggleButtonRole;
    protected Button m_toggleButtonUser;
    boolean m_doNotChange;
    CmsStateBean m_stateBean;
    private String m_baseOU = "";
    private ComboBox m_filter;
    private TextField m_filterTable;
    private CmsOUHandler m_ouHandler;
    private CmsOuTree m_ouTree;
    private Map<CmsUUID, Boolean> m_passwordResetStateCache = new ConcurrentHashMap<CmsUUID, Boolean>();
    private HorizontalSplitPanel m_splitScreen;
    private I_CmsFilterableTable m_table;

    public CmsAccountsApp() {
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            this.m_cms.getRequestContext().setSiteRoot("");
            this.m_ouHandler = new CmsOUHandler(this.m_cms);
            this.m_baseOU = this.m_ouHandler.getBaseOU();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_rootLayout.setMainHeightFull(true);
        this.m_splitScreen = new HorizontalSplitPanel();
        this.m_splitScreen.setSizeFull();
        this.m_splitScreen.setSplitPosition(399.0f, Sizeable.Unit.PIXELS);
        this.m_rootLayout.setMainContent((Component)this.m_splitScreen);
        this.m_ouTree = new CmsOuTree(this.m_cms, this, this.m_baseOU);
        this.m_splitScreen.setFirstComponent((Component)this.m_ouTree);
    }

    public static CmsResourceInfo getOUInfo(CmsOrganizationalUnit ou) {
        String style = "oc-icon-24-orgunit";
        if (ou.hasFlagWebuser()) {
            style = "oc-icon-24-webuser";
        }
        CmsCssIcon image = new CmsCssIcon(style);
        return new CmsResourceInfo(ou.getDisplayName(A_CmsUI.get().getLocale()), ou.getDescription(A_CmsUI.get().getLocale()), (Resource)image);
    }

    public static CmsResourceInfo getPrincipalInfo(I_CmsPrincipal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof CmsUser) {
            CmsUser user = (CmsUser)principal;
            CmsUserIconHelper helper = OpenCms.getWorkplaceAppManager().getUserIconHelper();
            CmsResourceInfo result = new CmsResourceInfo(user.getName(), user.getEmail(), (Resource)new ExternalResource(helper.getTinyIconPath(A_CmsUI.getCmsObject(), user)));
            result.addStyleName("o-userinfo-box");
            return result;
        }
        if (principal.getId().equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) {
            return new CmsResourceInfo(CmsVaadinUtils.getMessageText("GUI_LABEL_ALLOTHERS_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_DESCRIPTION_ALLOTHERS_0", new Object[0]), (Resource)new CmsCssIcon("oc-icon-24-principal-all"));
        }
        if (principal.getId().equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) {
            return new CmsResourceInfo(CmsVaadinUtils.getMessageText("GUI_LABEL_OVERWRITEALL_0", new Object[0]), CmsVaadinUtils.getMessageText("GUI_DESCRIPTION_OVERWRITEALL_0", new Object[0]), (Resource)new CmsCssIcon("oc-icon-24-principal-overwrite"));
        }
        CmsRole role = CmsRole.valueOfId(principal.getId());
        if (role != null) {
            return new CmsResourceInfo(role.getName(A_CmsUI.get().getLocale()), role.getDescription(A_CmsUI.get().getLocale()), (Resource)new CmsCssIcon("oc-icon-24-role"));
        }
        return new CmsResourceInfo(principal.getName(), principal.getDescription(A_CmsUI.get().getLocale()), (Resource)new CmsCssIcon("oc-icon-24-group"));
    }

    public void addGroupContainerProperties(IndexedContainer container) {
    }

    public void addUserContainerProperties(IndexedContainer container) {
    }

    public boolean canEditUser(CmsUUID id) {
        return true;
    }

    public boolean canRemoveGroupMemebers(String group) {
        return true;
    }

    public boolean checkAddGroup(CmsUser principal, Set<String> data) {
        return true;
    }

    public boolean checkRemoveGroups(CmsUser principal, Set<String> items) {
        return true;
    }

    public void fillGroupItem(Item item, CmsGroup group, List<CmsGroup> indirects) {
        item.getItemProperty((Object)CmsGroupTable.TableProperty.Name).setValue((Object)group.getName());
        item.getItemProperty((Object)CmsGroupTable.TableProperty.Description).setValue((Object)group.getDescription(A_CmsUI.get().getLocale()));
        item.getItemProperty((Object)CmsGroupTable.TableProperty.OU).setValue((Object)group.getOuFqn());
        if (indirects.contains(group)) {
            item.getItemProperty((Object)CmsGroupTable.TableProperty.INDIRECT).setValue((Object)Boolean.TRUE);
        }
    }

    public String getAppId() {
        return "accounts";
    }

    public IndexedContainer getAvailableGroupsContainerWithout(CmsObject cms, String ouFqn, String propCaption, String propIcon, String propOu, List<CmsGroup> groupsOfUser, Function<CmsGroup, CmsCssIcon> iconProvider) {
        return CmsVaadinUtils.getAvailableGroupsContainerWithout(cms, ouFqn, propCaption, propIcon, propOu, groupsOfUser, iconProvider);
    }

    public CmsGroupEditParameters getGroupEditParameters(CmsGroup group) {
        CmsGroupEditParameters params = new CmsGroupEditParameters();
        return params;
    }

    public CmsCssIcon getGroupIcon(CmsGroup group) {
        return new CmsCssIcon("oc-icon-24-group");
    }

    public Map<CmsUUID, Boolean> getPasswordResetStateCache() {
        return this.m_passwordResetStateCache;
    }

    public CmsUserEditParameters getUserEditParameters(CmsUser user) {
        CmsUserEditParameters params = new CmsUserEditParameters();
        params.setEditEnabled(true);
        params.setPasswordChangeEnabled(true);
        return params;
    }

    public IndexedContainer getUserGroupsEditorContainer(CmsUser user, String propName, String propIcon, String propStatus) {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)propName, String.class, (Object)"");
        container.addContainerProperty((Object)"ou", String.class, (Object)"");
        container.addContainerProperty((Object)propStatus, Boolean.class, (Object)true);
        container.addContainerProperty((Object)propIcon, CmsCssIcon.class, (Object)new CmsCssIcon("oc-icon-group-24"));
        try {
            for (CmsGroup group : this.m_cms.getGroupsOfUser(user.getName(), true)) {
                Item item = container.addItem((Object)group);
                item.getItemProperty((Object)propName).setValue((Object)group.getSimpleName());
                item.getItemProperty((Object)"ou").setValue((Object)group.getOuFqn());
                item.getItemProperty((Object)propIcon).setValue((Object)this.getGroupIcon(group));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read groups from user", (Throwable)e);
        }
        return container;
    }

    public List<CmsUser> getUsersWithoutAdditionalInfo(CmsObject cms, I_CmsOuTreeType type, String ou, boolean recursive) throws CmsException {
        return CmsPrincipal.filterCoreUsers(OpenCms.getOrgUnitManager().getUsersWithoutAdditionalInfo(cms, ou, recursive));
    }

    @Override
    public void handlePrincipal(I_CmsPrincipal principal) {
        if (this.m_stateBean.getType().isGroup()) {
            try {
                CmsGroup group = this.m_cms.readGroup(this.m_stateBean.getGroupID());
                this.m_cms.addUserToGroup(principal.getName(), group.getName());
            }
            catch (CmsException e) {
                return;
            }
        }
        if (this.m_stateBean.getType().isRole()) {
            try {
                OpenCms.getRoleManager().addUserToRole(this.m_cms, CmsRole.valueOfId(this.m_stateBean.getGroupID()).forOrgUnit(this.m_stateBean.getPath()), principal.getName());
            }
            catch (CmsException e) {
                return;
            }
        }
        A_CmsUI.get().reload();
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        context.addPublishButton(changed -> {});
        super.initUI(context);
    }

    public boolean isOUManagable(String ou) {
        return this.m_ouHandler.isOUManagable(ou);
    }

    public boolean isParentOfManagableOU(String name) {
        return this.m_ouHandler.isParentOfManagableOU(name);
    }

    @Override
    public void openSubView(String state, boolean updateState) {
        if (updateState) {
            CmsAppWorkplaceUi.get().changeCurrentAppState(state);
        }
        Component comp = this.getComponentForState(state);
        this.updateInfoButton();
        if (comp != null) {
            VerticalLayout layout = new VerticalLayout();
            layout.setSizeFull();
            comp.setSizeFull();
            layout.addComponent((Component)this.m_table.getEmptyLayout());
            layout.addComponent((Component)this.m_table);
            this.handleSetTable(this.m_table);
            this.m_splitScreen.setSecondComponent((Component)layout);
        } else {
            this.m_splitScreen.setSecondComponent((Component)new Label("Malformed path, tool not available for path: " + state));
            this.handleSetTable(null);
        }
        this.m_splitScreen.setSizeFull();
        this.updateSubNav(this.getSubNavEntries(state));
        this.updateBreadCrumb(this.getBreadCrumbForState(state));
    }

    public CmsStateBean parseState(String state, String baseOU) {
        String path = baseOU;
        String filter = "";
        I_CmsOuTreeType type = CmsOuTreeType.OU;
        CmsUUID groupId = null;
        List<String> fields = CmsStringUtil.splitAsList(state, STATE_SEPERATOR);
        if (!fields.isEmpty()) {
            if (fields.size() > 1 && (path = fields.get(1)).equals("") | !path.startsWith(baseOU)) {
                path = baseOU;
            }
            for (I_CmsOuTreeType ty : this.getTreeTypeProvider().getTreeTypes()) {
                if (!fields.get(0).equals(ty.getId())) continue;
                type = ty;
            }
            if (fields.size() > 2 && !CmsStringUtil.isEmptyOrWhitespaceOnly(fields.get(2))) {
                groupId = new CmsUUID(fields.get(2));
            }
            if (fields.size() > 3) {
                filter = fields.get(3);
            }
        }
        return new CmsStateBean(path, type, groupId, filter);
    }

    public List<CmsGroup> readGroupsForOu(CmsObject cms, String ou, I_CmsOuTreeType type, boolean subOus) throws CmsException {
        return CmsPrincipal.filterCoreGroups(OpenCms.getOrgUnitManager().getGroups(this.m_cms, ou, subOus));
    }

    public void reload() {
        this.update(this.m_stateBean.getPath(), this.m_stateBean.getType(), this.m_stateBean.getGroupID());
    }

    public void update(String ou, I_CmsOuTreeType type, CmsUUID groupID) {
        this.update(ou, type, groupID, (String)this.m_filterTable.getValue());
    }

    public void update(String ou, I_CmsOuTreeType type, CmsUUID roleOrGroupID, String filter) {
        CmsStateBean stateBean = new CmsStateBean(ou, type, roleOrGroupID, filter);
        try {
            this.m_ouTree.updateOU(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, ou));
        }
        catch (CmsException e) {
            LOG.error((Object)("Unable to read ou: " + ou));
        }
        this.openSubView(stateBean.getState(), true);
    }

    protected I_CmsFilterableTable createGroupTable(String path, CmsAccountsApp cmsAccountsApp, I_CmsOuTreeType type, boolean toggle) {
        return new CmsGroupTable(path, cmsAccountsApp, type, toggle);
    }

    protected I_CmsFilterableTable createOUTable(String ou) {
        return new CmsOUTable(ou, this);
    }

    protected I_CmsFilterableTable createRoleTable(String ou) {
        return new CmsRoleTable(this, ou);
    }

    protected I_CmsFilterableTable createUserTable(String ou, CmsUUID groupID, I_CmsOuTreeType type, boolean showAll, CmsAccountsApp cmsAccountsApp) {
        return new CmsUserTable(ou, groupID, type, showAll, cmsAccountsApp);
    }

    protected I_CmsFilterableTable createUserTable(String ou, I_CmsOuTreeType type, CmsAccountsApp cmsAccountsApp, boolean buttonPressed) {
        return new CmsUserTable(ou, type, cmsAccountsApp, buttonPressed);
    }

    protected void filterTable(String text) {
        if (this.m_table != null) {
            this.m_table.filter(text);
        }
    }

    protected List<Button> getAdditionalButtons() {
        return new ArrayList<Button>();
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        try {
            CmsStateBean bean = this.parseState(state, this.m_baseOU);
            String[] ouPath = bean.getPath().split("/");
            LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
            if (bean.getPath().equals(this.m_baseOU) && CmsOuTreeType.OU.equals(bean.getType()) | bean.getType() == null) {
                crumbs.put("", CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_TOOL_NAME_0", new Object[0]) + " (" + OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, this.m_baseOU).getDisplayName(A_CmsUI.get().getLocale()) + ")");
                return crumbs;
            }
            CmsStateBean beanCr = new CmsStateBean(this.m_baseOU, CmsOuTreeType.OU, null, "");
            crumbs.put(this.getAppId() + "/" + beanCr.getState(), CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_TOOL_NAME_0", new Object[0]) + " (" + OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, this.m_baseOU).getDisplayName(A_CmsUI.get().getLocale()) + ")");
            Object base = "";
            Object pathOfLastElement = "";
            for (String oP : ouPath) {
                if (oP.isEmpty()) continue;
                if ((oP + (String)base).length() > this.m_baseOU.length()) {
                    CmsStateBean beanCrumb;
                    if (oP.equals(ouPath[ouPath.length - 1])) {
                        beanCrumb = new CmsStateBean((String)base + oP, CmsOuTreeType.OU, null, "");
                        pathOfLastElement = this.getAppId() + "/" + beanCrumb.getState();
                        crumbs.put("", oP);
                    } else {
                        beanCrumb = new CmsStateBean((String)base + oP, CmsOuTreeType.OU, null, "");
                        crumbs.put(this.getAppId() + "/" + beanCrumb.getState(), oP);
                    }
                }
                base = (String)base + oP + "/";
            }
            if (bean.getType() != null && !bean.getType().equals(CmsOuTreeType.OU)) {
                if (!((String)pathOfLastElement).isEmpty()) {
                    crumbs.put((String)pathOfLastElement, crumbs.get(""));
                    crumbs.remove("");
                }
                if (bean.getGroupID() == null) {
                    crumbs.put("", bean.getType().getName());
                } else {
                    CmsStateBean beanCrumb = new CmsStateBean(bean.getPath(), bean.getType(), null, "");
                    crumbs.put(this.getAppId() + "/" + beanCrumb.getState(), beanCrumb.getType().getName());
                    if (bean.getType().equals(CmsOuTreeType.ROLE)) {
                        crumbs.put("", CmsRole.valueOfId(bean.getGroupID()).getName(A_CmsUI.get().getLocale()));
                    } else {
                        crumbs.put("", this.m_cms.readGroup(bean.getGroupID()).getSimpleName());
                    }
                }
            }
            return crumbs;
        }
        catch (CmsException e) {
            return null;
        }
    }

    @Override
    protected Component getComponentForState(String state) {
        this.m_stateBean = this.parseState(state, this.m_baseOU);
        if (this.m_filter == null) {
            this.iniButtons();
        }
        this.m_doNotChange = true;
        this.m_filter.setValue((Object)this.m_stateBean.getPath());
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_stateBean.getTableFilter())) {
            this.m_filterTable.setValue(this.m_stateBean.getTableFilter());
        } else {
            this.m_filterTable.setValue("");
        }
        this.m_newButton.setVisible(this.m_stateBean.getGroupID() == null & this.isOUManagable(this.m_stateBean.getPath()));
        this.m_toggleButtonRole.setVisible(this.m_stateBean.getType().isRole() && this.m_stateBean.getGroupID() != null);
        this.m_toggleButtonUser.setVisible(this.m_stateBean.getType().isUser());
        this.m_importExport.setVisible(this.m_stateBean.getType().isOrgUnit());
        this.m_toggleButtonGroups.setVisible(this.m_stateBean.getType().isGroup() && this.m_stateBean.getGroupID() == null);
        this.m_infoButton.setVisible(this.m_stateBean.getType().isUser() || this.m_stateBean.getType().isRole() && this.m_stateBean.getGroupID() != null || this.m_stateBean.getType().isGroup() && this.m_stateBean.getGroupID() != null);
        this.m_addElementButton.setVisible((this.m_stateBean.getType().isGroup() || this.m_stateBean.getType().isRole()) & this.m_stateBean.getGroupID() != null);
        this.m_ouTree.openPath(this.m_stateBean.getPath(), this.m_stateBean.getType(), this.m_stateBean.getGroupID());
        this.m_doNotChange = false;
        I_CmsFilterableTable table = null;
        if (this.m_stateBean.getType().equals(CmsOuTreeType.OU)) {
            table = this.m_table = this.createOUTable(this.m_stateBean.getPath());
        }
        if (this.m_stateBean.getType().isUser()) {
            table = this.m_table = this.createUserTable(this.m_stateBean.getPath(), this.m_stateBean.getType(), this, CmsVaadinUtils.isButtonPressed(this.m_toggleButtonUser));
        }
        if (this.m_stateBean.getType().isGroup()) {
            table = this.m_stateBean.getGroupID() == null ? (this.m_table = this.createGroupTable(this.m_stateBean.getPath(), this, this.m_stateBean.getType(), CmsVaadinUtils.isButtonPressed(this.m_toggleButtonGroups))) : (this.m_table = this.createUserTable(this.m_stateBean.getPath(), this.m_stateBean.getGroupID(), this.m_stateBean.getType(), false, this));
        }
        if (this.m_stateBean.getType().isRole()) {
            table = this.m_stateBean.getGroupID() == null ? (this.m_table = this.createRoleTable(this.m_stateBean.getPath())) : (this.m_table = this.createUserTable(this.m_stateBean.getPath(), this.m_stateBean.getGroupID(), this.m_stateBean.getType(), CmsVaadinUtils.isButtonPressed(this.m_toggleButtonRole), this));
        }
        if (table != null && !CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_filterTable.getValue())) {
            table.filter((String)this.m_filterTable.getValue());
        }
        return table;
    }

    protected String getElementName(CmsStateBean stateBean) {
        if (stateBean.getType().equals(CmsOuTreeType.USER)) {
            try {
                return OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, stateBean.getPath()).getDisplayName(A_CmsUI.get().getLocale());
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read OU", (Throwable)e);
            }
        }
        if (stateBean.getType().equals(CmsOuTreeType.ROLE)) {
            return CmsRole.valueOfId(stateBean.getGroupID()).getName(A_CmsUI.get().getLocale());
        }
        try {
            return this.m_cms.readGroup(stateBean.getGroupID()).getSimpleName();
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read group", (Throwable)e);
            return "";
        }
    }

    protected List<CmsUser> getFullUser(List<CmsUser> users) {
        ArrayList<CmsUser> res = new ArrayList<CmsUser>();
        for (CmsUser user : users) {
            try {
                res.add(this.m_cms.readUser(user.getId()));
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read user", (Throwable)e);
            }
        }
        return res;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    protected Button getToggleButton(CmsStateBean stateBean) {
        if (stateBean.getType().equals(CmsOuTreeType.USER)) {
            return this.m_toggleButtonUser;
        }
        if (stateBean.getType().equals(CmsOuTreeType.ROLE)) {
            return this.m_toggleButtonRole;
        }
        return this.m_toggleButtonGroups;
    }

    protected I_CmsTreeTypeProvider getTreeTypeProvider() {
        return DEFAULT_TREETYPES;
    }

    protected List<CmsUser> getVisibleUser() {
        if (this.m_table instanceof CmsUserTable) {
            return ((CmsUserTable)this.m_table).getVisibleUser();
        }
        return null;
    }

    protected void handleSetTable(Component component) {
    }

    protected void openNewDialog() {
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsNewElementDialog dialog = new CmsNewElementDialog(this.m_cms, this.m_stateBean.getPath(), window, this);
        window.setContent((Component)dialog);
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_ELEMENT_0", new Object[0]));
        A_CmsUI.get().addWindow(window);
    }

    void openAddUserDialog() {
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
        CmsPrincipalSelectDialog dialog = new CmsPrincipalSelectDialog(this, this.m_stateBean.getPath(), window, CmsPrincipalSelect.WidgetType.userwidget, true, CmsPrincipalSelect.PrincipalType.user);
        try {
            dialog.setOuComboBoxEnabled(!OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, this.m_stateBean.getPath()).hasFlagWebuser() | this.m_stateBean.getType().equals(CmsOuTreeType.ROLE));
        }
        catch (CmsException e) {
            LOG.error((Object)"Can not read OU.", (Throwable)e);
        }
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_USER_TO_GROUP_0", new Object[0]));
        window.setContent((Component)dialog);
        A_CmsUI.get().addWindow(window);
    }

    void toggleTable(Button toggleButton) {
        I_CmsToggleTable table = (I_CmsToggleTable)((Object)this.m_table);
        table.toggle(!CmsVaadinUtils.isButtonPressed(toggleButton));
        CmsVaadinUtils.toggleButton(toggleButton);
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_filterTable.getValue())) {
            this.filterTable((String)this.m_filterTable.getValue());
        }
        this.updateInfoButton();
    }

    private void iniButtons() {
        this.m_newButton = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_ELEMENT_0", new Object[0]));
        this.m_newButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAccountsApp.this.openNewDialog();
            }
        });
        this.m_infoButton = new CmsInfoButton();
        Button csvButton = new Button(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EXPORT_ONLY_USER_0", new Object[0]));
        csvButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5472430305539438757L;

            public void buttonClick(Button.ClickEvent event) {
                boolean includeTechnicalFields = false;
                try {
                    OpenCms.getRoleManager().checkRole(CmsAccountsApp.this.m_cms, CmsRole.ADMINISTRATOR);
                    includeTechnicalFields = true;
                }
                catch (CmsRoleViolationException cmsRoleViolationException) {
                    // empty catch block
                }
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                CmsUserCsvExportDialog dialog = new CmsUserCsvExportDialog(CmsAccountsApp.this.getFullUser(CmsAccountsApp.this.getVisibleUser()), CmsAccountsApp.this.m_stateBean.getPath(), CmsAccountsApp.this.m_stateBean.getType(), CmsAccountsApp.this.getElementName(CmsAccountsApp.this.m_stateBean), CmsVaadinUtils.isButtonPressed(CmsAccountsApp.this.getToggleButton(CmsAccountsApp.this.m_stateBean)), window, includeTechnicalFields);
                window.setContent((Component)dialog);
                A_CmsUI.get().addWindow(window);
            }
        });
        this.m_infoButton.setAdditionalButton(csvButton);
        this.m_addElementButton = CmsToolBar.createButton((Resource)FontAwesome.PLUS, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_USER_TO_GROUP_0", new Object[0]));
        this.m_addElementButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1859694635385726953L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAccountsApp.this.openAddUserDialog();
            }
        });
        this.m_importExport = CmsToolBar.createButton((Resource)FontOpenCms.DOWNLOAD, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_CONTEXTMENUNAME_0", new Object[0]));
        this.m_importExport.addClickListener((Button.ClickListener & Serializable)event -> CmsOUTable.openImportExportDialog(A_CmsUI.getCmsObject(), this.m_stateBean.getPath()));
        this.m_toggleButtonRole = CmsToolBar.createButton((Resource)FontOpenCms.USERS, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ROLES_TOGGLE_0", new Object[0]));
        this.m_toggleButtonRole.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 8265075332953321274L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAccountsApp.this.toggleTable(CmsAccountsApp.this.m_toggleButtonRole);
            }
        });
        this.m_toggleButtonUser = CmsToolBar.createButton((Resource)FontOpenCms.USERS, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_TOGGLE_0", new Object[0]));
        this.m_toggleButtonUser.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 8265075332953321274L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAccountsApp.this.toggleTable(CmsAccountsApp.this.m_toggleButtonUser);
            }
        });
        this.m_toggleButtonGroups = CmsToolBar.createButton((Resource)FontOpenCms.USERS, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUPS_TOGGLE_0", new Object[0]));
        this.m_toggleButtonGroups.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 8265075332953321274L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAccountsApp.this.toggleTable(CmsAccountsApp.this.m_toggleButtonGroups);
            }
        });
        this.m_uiContext.addToolbarButton((Component)this.m_newButton);
        this.m_uiContext.addToolbarButton((Component)this.m_addElementButton);
        this.m_uiContext.addToolbarButton((Component)this.m_infoButton);
        this.m_uiContext.addToolbarButton((Component)this.m_toggleButtonRole);
        this.m_uiContext.addToolbarButton((Component)this.m_toggleButtonUser);
        this.m_uiContext.addToolbarButton((Component)this.m_toggleButtonGroups);
        this.m_uiContext.addToolbarButton((Component)this.m_importExport);
        for (Button button : this.getAdditionalButtons()) {
            this.m_uiContext.addToolbarButton((Component)button);
        }
        this.m_filter = CmsVaadinUtils.getOUComboBox(this.m_cms, this.m_baseOU, LOG);
        this.m_filter.setWidth("379px");
        this.m_infoLayout.addComponent((Component)this.m_filter, 0);
        this.m_filterTable = new TextField();
        this.m_filterTable.setIcon((Resource)FontOpenCms.FILTER);
        this.m_filterTable.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_filterTable.addStyleName("inline-icon");
        this.m_filterTable.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsAccountsApp.this.filterTable(event.getText());
            }
        });
        this.m_filterTable.setWidth("200px");
        this.m_infoLayout.addComponent((Component)this.m_filterTable);
        this.m_infoLayout.addStyleName("o-many-elements");
        this.m_filter.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (CmsAccountsApp.this.m_stateBean.getType() != null & !CmsAccountsApp.this.m_doNotChange) {
                    CmsAccountsApp.this.update((String)event.getProperty().getValue(), CmsOuTreeType.OU, null);
                }
            }
        });
        if (!this.m_ouHandler.isOUManagable(this.m_stateBean.getPath())) {
            boolean change = this.m_doNotChange;
            this.m_doNotChange = false;
            this.m_filter.select(this.m_filter.getItemIds().iterator().next());
            this.m_doNotChange = change;
        }
    }

    private void updateInfoButton() {
        if (this.m_stateBean.getType().isUser()) {
            LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
            dataMap.put(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_COUNT_0", new Object[0]), String.valueOf(((Table)this.m_table).size()));
            try {
                int count = this.getUsersWithoutAdditionalInfo(this.m_cms, this.m_stateBean.getType(), this.m_stateBean.getPath(), true).size();
                if (count > ((Table)this.m_table).size()) {
                    dataMap.put(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_TOT_COUNT_0", new Object[0]), String.valueOf(count));
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            this.m_infoButton.replaceData(dataMap);
        } else {
            int size = ((Table)this.m_table).size();
            if (this.m_table instanceof CmsUserTable) {
                size = ((CmsUserTable)this.m_table).getVisibleUser().size();
            }
            this.m_infoButton.replaceData(Collections.singletonMap(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_COUNT_0", new Object[0]), String.valueOf(size)));
        }
    }

    static class CmsStateBean {
        private String m_filter;
        private CmsUUID m_groupID;
        private String m_path = "";
        private I_CmsOuTreeType m_type;

        public CmsStateBean(String path, I_CmsOuTreeType type, CmsUUID groupID, String filter) {
            this.m_path = path.equals("/") ? "" : path;
            this.m_type = type;
            this.m_groupID = groupID;
            this.m_filter = filter;
        }

        public CmsUUID getGroupID() {
            return this.m_groupID;
        }

        public String getPath() {
            return this.m_path;
        }

        public String getState() {
            String typeString = this.m_type.getId();
            String groupString = "";
            if (this.m_groupID != null) {
                groupString = this.m_groupID.getStringValue();
            }
            return typeString + STATE_SEPERATOR + this.m_path + STATE_SEPERATOR + groupString + STATE_SEPERATOR + this.m_filter;
        }

        public String getTableFilter() {
            return this.m_filter;
        }

        public I_CmsOuTreeType getType() {
            return this.m_type;
        }
    }
}

