/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Window;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.db.CmsUserExportSettings;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsCsvWriter;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public abstract class A_CmsImportExportUserDialog
extends CmsBasicDialog {
    private static final String BOM = "\ufeff";
    private static final long serialVersionUID = -3990661225158677324L;
    private static final List<String> NON_TECHNICAL_VALUES = Arrays.asList("description", "lastname", "firstname", "email", "address", "zipcode", "city", "country");
    private FileDownloader m_fileDownloader;
    protected String m_ou;
    protected Window m_window;

    protected void init(String ou, Window window) {
        try {
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getOUInfo(OpenCms.getOrgUnitManager().readOrganizationalUnit(A_CmsUI.getCmsObject(), ou))));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_ou = ou;
        this.m_window = window;
        this.getDownloadButton().setEnabled(true);
        this.initDownloadButton();
        this.getCloseButton().addClickListener((Button.ClickListener & Serializable)event -> window.close());
    }

    protected void initDownloadButton() {
        if (this.m_fileDownloader != null) {
            this.m_fileDownloader.remove();
        }
        this.m_fileDownloader = new FileDownloader(this.getDownloadResource());
        this.m_fileDownloader.extend((AbstractComponent)this.getDownloadButton());
    }

    protected boolean isExportable(CmsUser exportUser) {
        return exportUser.getFlags() < 65536;
    }

    abstract Button getCloseButton();

    abstract Button getDownloadButton();

    ByteArrayInputStream getExportStream() {
        Map<CmsUUID, CmsUser> exportUsers = this.getUserToExport();
        CmsCsvWriter csvWriter = new CmsCsvWriter();
        StringBuffer buffer = new StringBuffer(BOM);
        CmsUserExportSettings settings = OpenCms.getImportExportManager().getUserExportSettings();
        List<String> values = settings.getColumns();
        buffer.append("name");
        Iterator<String> itValues = values.iterator();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("name");
        while (itValues.hasNext()) {
            String colName = itValues.next();
            if (!this.isColumnExportable(colName)) continue;
            columns.add(colName);
        }
        String[] cols = new String[columns.size()];
        csvWriter.addLine(columns.toArray(cols));
        Object[] users = exportUsers.values().toArray();
        for (int i = 0; i < users.length; ++i) {
            CmsUser exportUser = (CmsUser)users[i];
            String[] colValues = new String[columns.size()];
            if (!this.isExportable(exportUser)) continue;
            colValues[0] = exportUser.getSimpleName();
            int colNumber = 1;
            for (String curValue : values) {
                if (!this.isColumnExportable(curValue)) continue;
                try {
                    Method method = CmsUser.class.getMethod("get" + curValue.substring(0, 1).toUpperCase() + curValue.substring(1), new Class[0]);
                    Object curOutput = (String)method.invoke((Object)exportUser, new Object[0]);
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)curOutput) || ((String)curOutput).equals("null")) {
                        curOutput = (String)exportUser.getAdditionalInfo(curValue);
                    }
                    if (curValue.equals("password")) {
                        curOutput = OpenCms.getPasswordHandler().getDigestType() + "_" + (String)curOutput;
                    }
                    if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)curOutput) && !((String)curOutput).equals("null")) {
                        colValues[colNumber] = curOutput;
                    }
                }
                catch (NoSuchMethodException e) {
                    Object obj = exportUser.getAdditionalInfo(curValue);
                    if (obj != null) {
                        String curOutput = String.valueOf(obj);
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(curOutput)) {
                            colValues[colNumber] = curOutput;
                        }
                    } else {
                        colValues[colNumber] = "";
                    }
                }
                catch (IllegalAccessException e) {
                    colValues[colNumber] = "";
                }
                catch (InvocationTargetException e) {
                    colValues[colNumber] = "";
                }
                if (colValues[colNumber] == null) {
                    colValues[colNumber] = "";
                }
                ++colNumber;
            }
            csvWriter.addLine(colValues);
        }
        return new ByteArrayInputStream(csvWriter.toString().getBytes());
    }

    abstract Map<CmsUUID, CmsUser> getUserToExport();

    abstract boolean isExportWithTechnicalFields();

    private Resource getDownloadResource() {
        return new StreamResource(new StreamResource.StreamSource(){
            private static final long serialVersionUID = -8868657402793427460L;

            public InputStream getStream() {
                return A_CmsImportExportUserDialog.this.getExportStream();
            }
        }, "User_Export.csv");
    }

    private boolean isColumnExportable(String colName) {
        if (this.isExportWithTechnicalFields()) {
            return true;
        }
        return NON_TECHNICAL_VALUES.contains(colName.toLowerCase());
    }
}

