/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.unusedcontentfinder;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlAdeConfiguration;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.components.CmsComponentState;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsFileTableDialogContext;
import org.opencms.ui.components.CmsFolderSelector;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.CmsResultFilterComponent;
import org.opencms.ui.components.CmsSiteSelector;
import org.opencms.ui.components.CmsTypeSelector;
import org.opencms.ui.contextmenu.CmsResourceContextMenuBuilder;
import org.opencms.ui.dialogs.CmsDeleteDialog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.content.I_CmsXmlContentHandler;

public class CmsUnusedContentFinderComposite {
    static final Log LOG = CmsLog.getLog(CmsUnusedContentFinderComposite.class);
    static final int MAX_RESULTS = 5000;
    static final String SCHEMA_PARAM_NAME = "unusedcontentfinder";
    static final String SCHEMA_PARAM_VALUE = "include";
    DeleteButtonComponent m_deleteButtonComponent = new DeleteButtonComponent();
    FormComponent m_formComponent = new FormComponent();
    ResultComponent m_resultComponent = new ResultComponent();
    ResultFilterComponent m_resultFilterComponent = new ResultFilterComponent();

    public Component getDeleteButtonComponent() {
        return this.m_deleteButtonComponent;
    }

    public Component getFormComponent() {
        return this.m_formComponent;
    }

    public Component getResultComponent() {
        return this.m_resultComponent;
    }

    public Component getResultFilterComponent() {
        return this.m_resultFilterComponent;
    }

    public void search(boolean updateState) {
        if (updateState) {
            CmsComponentState componentState = new CmsComponentState();
            componentState.setSite(this.m_formComponent.getSiteValue());
            componentState.setFolder(this.m_formComponent.getFolderValue());
            componentState.setResourceType(this.m_formComponent.getTypeValue());
            CmsAppWorkplaceUi.get().changeCurrentAppState(componentState.generateStateString());
        }
        this.m_resultComponent.updateResult();
    }

    public void setState(CmsComponentState componentState) {
        this.m_formComponent.setSiteValue(componentState.getSite());
        this.m_formComponent.setFolderValue(componentState.getFolder());
        this.m_formComponent.setTypeValue(componentState.getResourceType());
    }

    List<I_CmsResourceType> getAvailableTypes() {
        ArrayList<I_CmsResourceType> result = new ArrayList<I_CmsResourceType>();
        CmsObject cms = A_CmsUI.getCmsObject();
        List<I_CmsResourceType> types = OpenCms.getResourceManager().getResourceTypes();
        for (I_CmsResourceType type : types) {
            CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            if (typeSetting == null || !(type instanceof CmsResourceTypeXmlContent) || type instanceof CmsResourceTypeXmlContainerPage || type instanceof CmsResourceTypeXmlAdeConfiguration) continue;
            CmsResourceTypeXmlContent xmlType = (CmsResourceTypeXmlContent)type;
            try {
                CmsFile schemaFile = cms.readFile(xmlType.getSchema());
                CmsXmlContentDefinition definition = CmsXmlContentDefinition.unmarshal(cms, schemaFile.getRootPath());
                I_CmsXmlContentHandler contentHandler = definition.getContentHandler();
                String parameter = contentHandler.getParameter(SCHEMA_PARAM_NAME);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parameter)) {
                    if (!parameter.equalsIgnoreCase(SCHEMA_PARAM_VALUE)) continue;
                    result.add(type);
                    continue;
                }
                if (!contentHandler.isContainerPageOnly()) continue;
                result.add(type);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    CmsObject getOfflineCms() {
        CmsObject offlineCms = null;
        try {
            offlineCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            offlineCms.getRequestContext().setSiteRoot(this.m_formComponent.getSiteValue());
            offlineCms.getRequestContext().setCurrentProject(offlineCms.readProject("Offline"));
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return offlineCms;
    }

    CmsObject getOnlineCms() {
        CmsObject onlineCms = null;
        try {
            onlineCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            onlineCms.getRequestContext().setSiteRoot(this.m_formComponent.getSiteValue());
            onlineCms.getRequestContext().setCurrentProject(onlineCms.readProject(CmsProject.ONLINE_PROJECT_ID));
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return onlineCms;
    }

    boolean isExcludedByProperties(CmsResource resource, boolean online) throws CmsException {
        CmsObject cms = online ? this.getOnlineCms() : this.getOfflineCms();
        CmsProperty navInfo = cms.readPropertyObject(resource, "NavInfo", true);
        if (!navInfo.isNullProperty() && navInfo.getValue().equals("keep")) {
            return true;
        }
        CmsProperty elementModel = cms.readPropertyObject(resource, "element.model", true);
        return !elementModel.isNullProperty() && elementModel.getValue().equals("true");
    }

    boolean isUsedByOtherContents(CmsResource resource, boolean online) throws CmsException {
        if (online && resource.getState().isNew()) {
            return false;
        }
        CmsRelationFilter filter = CmsRelationFilter.SOURCES;
        CmsObject cms = online ? this.getOnlineCms() : this.getOfflineCms();
        List<CmsRelation> relations = cms.getRelationsForResource(resource, filter);
        return !relations.isEmpty();
    }

    boolean isValidFolder() {
        String rootPath = CmsStringUtil.joinPaths(this.m_formComponent.getSiteValue(), this.m_formComponent.getFolderValue());
        return CmsResource.getPathLevel(rootPath) >= 2;
    }

    private class DeleteButtonComponent
    extends Button {
        private static final long serialVersionUID = 1L;

        DeleteButtonComponent() {
            final String caption = CmsVaadinUtils.getMessageText("GUI_UNUSED_CONTENT_FINDER_DELETE_ALL_0", new Object[0]);
            this.addStyleName("o-button-red");
            this.setCaption(caption);
            this.setVisible(false);
            this.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    CmsUnusedContentFinderComposite.this.m_resultComponent.getFileTable().selectAll();
                    I_CmsDialogContext context = CmsUnusedContentFinderComposite.this.m_resultComponent.getFileTable().getContextProvider().getDialogContext();
                    context.start(caption, (Component)new CmsDeleteDialog(context));
                }
            });
        }
    }

    private class FormComponent
    extends VerticalLayout {
        private static final long serialVersionUID = 1L;
        private FormLayout m_formLayout;
        private CmsSiteSelector m_siteSelector;
        private CmsFolderSelector m_folderSelector;
        private CmsTypeSelector m_typeSelector;
        private Button m_searchButton;

        FormComponent() {
            this.setMargin(true);
            this.setSpacing(true);
            this.m_formLayout = new FormLayout();
            this.m_formLayout.setMargin(true);
            this.m_formLayout.setSpacing(true);
            this.m_formLayout.addStyleName("o-formlayout-narrow");
            this.initSiteSelector();
            this.initFolderSelector();
            this.initTypeSelector();
            this.m_formLayout.addComponent((Component)new VerticalLayout());
            this.addComponent((Component)this.m_formLayout);
            this.initSearchButton();
            this.initDeleteButton();
        }

        String getFolderValue() {
            return this.m_folderSelector.getValue();
        }

        String getSiteValue() {
            return (String)this.m_siteSelector.getValue();
        }

        I_CmsResourceType getTypeValue() {
            return (I_CmsResourceType)this.m_typeSelector.getValue();
        }

        void setFolderValue(String folder) {
            this.m_folderSelector.setValue(folder);
        }

        void setSiteValue(String site) {
            this.m_siteSelector.setValue(site);
        }

        void setTypeValue(I_CmsResourceType type) {
            this.m_typeSelector.setValue(type);
        }

        void updateSearchRoot() throws CmsException {
            CmsObject newCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            newCms.getRequestContext().setSiteRoot((String)this.m_siteSelector.getValue());
            this.m_folderSelector.setCmsObject(newCms);
            this.m_folderSelector.setValue("/");
        }

        private void initDeleteButton() {
            HorizontalLayout layout = new HorizontalLayout();
            layout.setMargin(true);
            layout.setSpacing(true);
            layout.setWidth("100%");
            layout.setStyleName("o-dialog-button-bar");
            layout.addComponent((Component)CmsUnusedContentFinderComposite.this.m_deleteButtonComponent);
            layout.setComponentAlignment((Component)CmsUnusedContentFinderComposite.this.m_deleteButtonComponent, Alignment.TOP_RIGHT);
            this.addComponent((Component)layout);
        }

        private void initFolderSelector() {
            this.m_folderSelector = new CmsFolderSelector();
            this.m_formLayout.addComponent((Component)this.m_folderSelector);
        }

        private void initSearchButton() {
            HorizontalLayout layout = new HorizontalLayout();
            layout.setMargin(true);
            layout.setSpacing(true);
            layout.setWidth("100%");
            layout.setStyleName("o-dialog-button-bar");
            this.m_searchButton = new Button(CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SEARCH_0", new Object[0]), new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    CmsUnusedContentFinderComposite.this.search(true);
                }
            });
            this.m_searchButton.addStyleName("o-button-blue");
            layout.addComponent((Component)this.m_searchButton);
            layout.setComponentAlignment((Component)this.m_searchButton, Alignment.TOP_RIGHT);
            this.addComponent((Component)layout);
        }

        private void initSiteSelector() {
            this.m_siteSelector = new CmsSiteSelector();
            this.m_siteSelector.setWidthFull();
            this.m_siteSelector.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent event) {
                    try {
                        FormComponent.this.updateSearchRoot();
                    }
                    catch (CmsException e) {
                        LOG.error((Object)"Unable to initialize CmsObject", (Throwable)e);
                    }
                }
            });
            this.m_formLayout.addComponent((Component)this.m_siteSelector);
        }

        private void initTypeSelector() {
            this.m_typeSelector = new CmsTypeSelector();
            this.m_typeSelector.updateTypes(CmsUnusedContentFinderComposite.this.getAvailableTypes());
            this.m_formLayout.addComponent((Component)this.m_typeSelector);
        }
    }

    private class ResultComponent
    extends VerticalLayout {
        private static final long serialVersionUID = 1L;
        CmsFileTable m_fileTable;
        private VerticalLayout m_infoEmptyResult;
        private VerticalLayout m_infoIntroLayout;
        private VerticalLayout m_infoTooManyResults;
        private VerticalLayout m_infoInvalidFolder;

        ResultComponent() {
            this.setSizeFull();
            this.initInfoIntroLayout();
            this.initInfoEmptyResult();
            this.initInfoTooManyResults();
            this.initInfoInvalidFolder();
            this.initFileTable();
        }

        CmsFileTable getFileTable() {
            return this.m_fileTable;
        }

        void updateResult() {
            if (!CmsUnusedContentFinderComposite.this.isValidFolder()) {
                this.showInfoInvalidFolder();
                return;
            }
            CmsObject cms = CmsUnusedContentFinderComposite.this.getOfflineCms();
            I_CmsResourceType type = CmsUnusedContentFinderComposite.this.m_formComponent.getTypeValue();
            String folderName = CmsUnusedContentFinderComposite.this.m_formComponent.getFolderValue();
            ArrayList<CmsResource> resourcesToShow = new ArrayList<CmsResource>();
            boolean tooManyResults = false;
            if (cms.existsResource(folderName)) {
                try {
                    List<Object> resourceTypes = new ArrayList<I_CmsResourceType>();
                    if (type == null) {
                        resourceTypes = CmsUnusedContentFinderComposite.this.getAvailableTypes();
                    } else {
                        resourceTypes.add(type);
                    }
                    block2: for (I_CmsResourceType i_CmsResourceType : resourceTypes) {
                        CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE.addRequireType(i_CmsResourceType);
                        List<CmsResource> resources = cms.readResources(folderName, filter);
                        for (CmsResource resource : resources) {
                            if (!(CmsUnusedContentFinderComposite.this.isExcludedByProperties(resource, false) || CmsUnusedContentFinderComposite.this.isUsedByOtherContents(resource, false) || CmsUnusedContentFinderComposite.this.isUsedByOtherContents(resource, true))) {
                                resourcesToShow.add(resource);
                            }
                            if (resourcesToShow.size() <= 5000) continue;
                            tooManyResults = true;
                            continue block2;
                        }
                    }
                    this.m_fileTable.fillTable(cms, resourcesToShow);
                }
                catch (CmsException e) {
                    CmsErrorDialog.showErrorDialog(e);
                }
            }
            this.m_infoIntroLayout.setVisible(false);
            if (resourcesToShow.isEmpty()) {
                this.showInfoEmptyResult();
                CmsUnusedContentFinderComposite.this.m_deleteButtonComponent.setVisible(false);
            } else if (tooManyResults) {
                this.showInfoTooManyResults();
                CmsUnusedContentFinderComposite.this.m_deleteButtonComponent.setVisible(false);
            } else {
                this.showFileTable();
                CmsUnusedContentFinderComposite.this.m_deleteButtonComponent.setVisible(true);
            }
        }

        private void initFileTable() {
            this.m_fileTable = new CmsFileTable(null){
                private static final long serialVersionUID = 1L;

                @Override
                public void applyWorkplaceAppSettings() {
                    super.applyWorkplaceAppSettings();
                    this.m_fileTable.setColumnCollapsed((Object)CmsResourceTableProperty.PROPERTY_SIZE, true);
                    this.m_fileTable.setColumnCollapsed((Object)CmsResourceTableProperty.PROPERTY_INTERNAL_RESOURCE_TYPE, false);
                }

                @Override
                public void filterTable(String search) {
                    this.m_container.removeAllContainerFilters();
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
                        this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_TITLE, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_TYPE, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_INTERNAL_RESOURCE_TYPE, search, true, false)}));
                    }
                    if (this.m_fileTable.getValue() != null & !((Set)this.m_fileTable.getValue()).isEmpty()) {
                        this.m_fileTable.setCurrentPageFirstItemId(((Set)this.m_fileTable.getValue()).iterator().next());
                    }
                }
            };
            this.m_fileTable.applyWorkplaceAppSettings();
            this.m_fileTable.setContextProvider(new I_CmsContextProvider(){

                @Override
                public I_CmsDialogContext getDialogContext() {
                    CmsFileTableDialogContext context = new CmsFileTableDialogContext("unused-content-finder", I_CmsDialogContext.ContextType.fileTable, ResultComponent.this.m_fileTable, ResultComponent.this.m_fileTable.getSelectedResources());
                    return context;
                }
            });
            this.m_fileTable.setSizeFull();
            this.m_fileTable.setMenuBuilder(new CmsResourceContextMenuBuilder());
            this.m_fileTable.setVisible(false);
            this.addComponent((Component)this.m_fileTable);
            this.setExpandRatio((Component)this.m_fileTable, 2.0f);
        }

        private void initInfoEmptyResult() {
            this.m_infoEmptyResult = CmsVaadinUtils.getInfoLayout("GUI_SOURCESEARCH_EMPTY_0");
            this.m_infoEmptyResult.setVisible(false);
            this.addComponent((Component)this.m_infoEmptyResult);
        }

        private void initInfoIntroLayout() {
            this.m_infoIntroLayout = CmsVaadinUtils.getInfoLayout("GUI_SOURCESEARCH_INTRO_0");
            this.m_infoIntroLayout.setVisible(true);
            this.addComponent((Component)this.m_infoIntroLayout);
        }

        private void initInfoInvalidFolder() {
            this.m_infoInvalidFolder = CmsVaadinUtils.getInfoLayout("GUI_UNUSED_CONTENT_FINDER_INVALID_FOLDER_0");
            this.m_infoInvalidFolder.setVisible(false);
            this.addComponent((Component)this.m_infoInvalidFolder);
        }

        private void initInfoTooManyResults() {
            this.m_infoTooManyResults = CmsVaadinUtils.getInfoLayout("GUI_UNUSED_CONTENT_FINDER_TOO_MANY_RESULTS_0");
            this.m_infoTooManyResults.setVisible(false);
            this.addComponent((Component)this.m_infoTooManyResults);
        }

        private void showFileTable() {
            this.m_infoIntroLayout.setVisible(false);
            this.m_infoTooManyResults.setVisible(false);
            this.m_infoInvalidFolder.setVisible(false);
            this.m_infoEmptyResult.setVisible(false);
            this.m_fileTable.setVisible(true);
        }

        private void showInfoEmptyResult() {
            this.m_fileTable.setVisible(false);
            this.m_infoIntroLayout.setVisible(false);
            this.m_infoTooManyResults.setVisible(false);
            this.m_infoInvalidFolder.setVisible(false);
            this.m_infoEmptyResult.setVisible(true);
        }

        private void showInfoInvalidFolder() {
            this.m_fileTable.setVisible(false);
            this.m_infoIntroLayout.setVisible(false);
            this.m_infoTooManyResults.setVisible(false);
            this.m_infoEmptyResult.setVisible(false);
            this.m_infoInvalidFolder.setVisible(true);
        }

        private void showInfoTooManyResults() {
            this.m_fileTable.setVisible(false);
            this.m_infoIntroLayout.setVisible(false);
            this.m_infoEmptyResult.setVisible(false);
            this.m_infoInvalidFolder.setVisible(false);
            this.m_infoTooManyResults.setVisible(true);
        }
    }

    private class ResultFilterComponent
    extends CmsResultFilterComponent {
        ResultFilterComponent() {
            this.addTextChangeListener(new FieldEvents.TextChangeListener(){

                public void textChange(FieldEvents.TextChangeEvent event) {
                    CmsUnusedContentFinderComposite.this.m_resultComponent.getFileTable().filterTable(event.getText());
                }
            });
        }
    }
}

