/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import com.google.common.collect.Maps;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Panel;
import com.vaadin.v7.ui.TextField;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sitemanager.CmsSiteManager;
import org.opencms.ui.apps.sitemanager.CmsSitesWebserverThread;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.report.CmsReportWidget;

public class CmsWebServerConfigForm
extends CmsBasicDialog {
    private static final long serialVersionUID = 6872090597762705805L;
    static Log LOG = CmsLog.getLog(CmsWebServerConfigForm.class.getName());
    private Button m_cancel;
    private Button m_ok;
    private TextField m_fieldConfigTemplate;
    private TextField m_fieldLogging;
    private TextField m_fieldPrefix;
    private TextField m_fieldScript;
    private TextField m_fieldSecureTemplate;
    private TextField m_fieldTargetPath;
    private Panel m_form;
    private CmsSiteManager m_manager;
    private Panel m_report;
    private FormLayout m_threadReport;

    public CmsWebServerConfigForm(CmsSiteManager manager) {
        this.m_manager = manager;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_report.setVisible(false);
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5105904639509364528L;

            public void buttonClick(Button.ClickEvent event) {
                CmsWebServerConfigForm.this.cancel();
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 7862341970072428829L;

            public void buttonClick(Button.ClickEvent event) {
                CmsWebServerConfigForm.this.runScript();
            }
        });
        HashMap webconfig = OpenCms.getSiteManager().getWebServerConfig();
        if (webconfig == null) {
            webconfig = Maps.newHashMap();
        }
        this.m_fieldConfigTemplate.setValue(this.nullToEmpty((String)webconfig.get("configtemplate")));
        this.m_fieldSecureTemplate.setValue(this.nullToEmpty((String)webconfig.get("securetemplate")));
        this.m_fieldTargetPath.setValue(this.nullToEmpty((String)webconfig.get("targetpath")));
        this.m_fieldScript.setValue(this.nullToEmpty((String)webconfig.get("webserverscript")));
        this.m_fieldLogging.setValue(this.nullToEmpty((String)webconfig.get("loggingdir")));
        this.m_fieldPrefix.setValue(this.nullToEmpty((String)webconfig.get("filenameprefix")));
    }

    void cancel() {
        this.m_manager.closeDialogWindow(false);
    }

    String nullToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    void runScript() {
        this.m_report.setVisible(true);
        this.m_form.setVisible(false);
        this.m_ok.setEnabled(false);
        HashMap webconfig = OpenCms.getSiteManager().getWebServerConfig();
        if (webconfig == null) {
            webconfig = Maps.newHashMap();
        }
        CmsSitesWebserverThread thread = new CmsSitesWebserverThread(A_CmsUI.getCmsObject(), (String)webconfig.get("targetpath"), (String)webconfig.get("configtemplate"), (String)webconfig.get("webserverscript"), (String)webconfig.get("filenameprefix"), (String)webconfig.get("loggingdir"), (String)webconfig.get("securetemplate"));
        thread.start();
        CmsReportWidget report = new CmsReportWidget(thread);
        this.m_threadReport.addComponent((Component)report);
    }
}

