/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import com.google.common.base.Supplier;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSSLMode;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sitemanager.CmsEditSiteForm;
import org.opencms.ui.apps.sitemanager.CmsSiteManager;
import org.opencms.ui.apps.sitemanager.CmsWorkplaceServerWidget;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;

public class CmsGlobalForm
extends CmsBasicDialog {
    private static Log LOG = CmsLog.getLog(CmsGlobalForm.class.getName());
    private static final long serialVersionUID = -3553152729226102382L;
    List<String> m_forbiddenFolder = new ArrayList<String>(){
        private static final long serialVersionUID = -52452684907673071L;
        {
            this.add("/sites/");
            this.add("/system/");
        }
    };
    private Button m_cancel;
    private ComboBox m_fieldDefaultURI;
    private ComboBox m_fieldSharedFolder;
    private CmsSiteManager m_manager;
    private Button m_ok;
    private VerticalLayout m_serverLayout;
    private CmsEditableGroup m_workplaceServerGroup;
    private CmsObject m_cms;

    public CmsGlobalForm(CmsSiteManager manager) {
        this.m_manager = manager;
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
        }
        catch (CmsException e) {
            LOG.error((Object)"Error on cloning CmsObject", (Throwable)e);
        }
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_cms.getRequestContext().setSiteRoot("/");
        List<CmsSite> allSites_temp = OpenCms.getSiteManager().getAvailableSites(this.m_cms, true, false, this.m_cms.getRequestContext().getOuFqn());
        ArrayList<CmsSite> allSites = new ArrayList<CmsSite>(allSites_temp);
        for (CmsSite site : allSites_temp) {
            if (site.getSiteRoot() != null && !site.getSiteRoot().equals("") && !site.getSiteRoot().equals("/")) continue;
            if (allSites_temp.indexOf(site) == allSites_temp.size() - 1) {
                allSites.remove(site);
                break;
            }
            allSites.remove(site);
        }
        allSites_temp.clear();
        this.setUpDefaultUriComboBox(allSites);
        this.setUpSharedFolderComboBox();
        this.setServerLayout(allSites);
        this.m_fieldSharedFolder.setValue((Object)OpenCms.getSiteManager().getSharedFolder().replace("/", ""));
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -143413645462471704L;

            public void buttonClick(Button.ClickEvent event) {
                CmsGlobalForm.this.submit();
                CmsGlobalForm.this.closeDialog();
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 8880622123062328256L;

            public void buttonClick(Button.ClickEvent event) {
                CmsGlobalForm.this.closeDialog();
            }
        });
    }

    static void selectNewWorkplaceServer(CmsSite site, ComboBox combo) {
        combo.select((Object)site);
    }

    void closeDialog() {
        this.m_manager.closeDialogWindow(false);
    }

    Map<String, CmsSSLMode> getWebserverList() {
        LinkedHashMap<String, CmsSSLMode> ret = new LinkedHashMap<String, CmsSSLMode>();
        for (I_CmsEditableGroupRow row : this.m_workplaceServerGroup.getRows()) {
            CmsWorkplaceServerWidget widget = (CmsWorkplaceServerWidget)row.getComponent();
            ret.put(widget.getServer(), widget.getSSLMode());
        }
        return ret;
    }

    void submit() {
        try {
            this.m_manager.updateGeneralSettings(this.m_cms, ((CmsSite)this.m_fieldDefaultURI.getValue()).getSiteRoot(), this.getWebserverList(), "/" + (String)this.m_fieldSharedFolder.getValue() + "/");
            if (!CmsEditSiteForm.FORBIDDEN_FOLDER_NAMES.isEmpty()) {
                CmsEditSiteForm.FORBIDDEN_FOLDER_NAMES.set(1, (String)this.m_fieldSharedFolder.getValue());
            }
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    private void setServerLayout(final List<CmsSite> sites) {
        this.m_workplaceServerGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_serverLayout, new Supplier<Component>(){

            public Component get() {
                CmsWorkplaceServerWidget row = new CmsWorkplaceServerWidget(sites, null);
                return row;
            }
        }, "Add");
        for (String server : OpenCms.getSiteManager().getWorkplaceServers()) {
            CmsWorkplaceServerWidget row = new CmsWorkplaceServerWidget(sites, server);
            this.m_workplaceServerGroup.addRow((Component)row);
        }
    }

    private void setUpDefaultUriComboBox(List<CmsSite> allSites) {
        BeanItemContainer objects = new BeanItemContainer(CmsSite.class, allSites);
        this.m_fieldDefaultURI.setContainerDataSource((Container)objects);
        this.m_fieldDefaultURI.setNullSelectionAllowed(false);
        this.m_fieldDefaultURI.setTextInputAllowed(false);
        this.m_fieldDefaultURI.setItemCaptionPropertyId((Object)"title");
        String siteRoot = OpenCms.getSiteManager().getDefaultUri();
        if (siteRoot.endsWith("/")) {
            siteRoot = siteRoot.substring(0, siteRoot.length() - 1);
        }
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        this.m_fieldDefaultURI.setValue((Object)site);
    }

    private void setUpSharedFolderComboBox() {
        this.m_fieldSharedFolder.setNullSelectionAllowed(false);
        this.m_fieldSharedFolder.setTextInputAllowed(false);
        try {
            List<CmsResource> folderUnderRoot = this.m_cms.readResources("/", CmsResourceFilter.DEFAULT_FOLDERS, false);
            for (CmsResource folder : folderUnderRoot) {
                if (this.m_forbiddenFolder.contains(folder.getRootPath())) continue;
                this.m_fieldSharedFolder.addItem((Object)folder.getRootPath().replace("/", ""));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Error reading resource.", (Throwable)e);
        }
    }
}

