/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sessions;

import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Validator;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sessions.CmsSessionsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsRichTextArea;

public class CmsSendBroadcastDialog
extends CmsBasicDialog {
    private static final Map<CmsUser, CmsBroadcast> USER_BROADCAST = new ConcurrentHashMap<CmsUser, CmsBroadcast>();
    private static final long serialVersionUID = -7642289972554010162L;
    private Button m_cancel;
    private CmsRichTextArea m_message;
    private Button m_ok;
    private Button m_resetBroadcasts;
    private CheckBox m_repeat;

    public CmsSendBroadcastDialog(final Set<String> sessionIds, final Runnable closeRunnable) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        if (sessionIds != null) {
            this.displayResourceInfoDirectly(CmsSessionsApp.getUserInfos(sessionIds));
        } else if (USER_BROADCAST.containsKey(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser())) {
            this.m_message.setValue(USER_BROADCAST.get(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser()).getMessage());
        }
        this.m_resetBroadcasts.addClickListener((Button.ClickListener & Serializable)event -> this.removeAllBroadcasts(sessionIds));
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 3105449865170606831L;

            public void buttonClick(Button.ClickEvent event) {
                closeRunnable.run();
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -1148041995591262401L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsSendBroadcastDialog.this.validateMessage()) {
                    CmsSendBroadcastDialog.this.sendBroadcast(sessionIds);
                    closeRunnable.run();
                }
            }
        });
    }

    protected void sendBroadcast(Set<String> sessionIds) {
        String cleanedHtml = CmsRichTextArea.cleanHtml(this.m_message.getValue(), true);
        if (sessionIds == null) {
            OpenCms.getSessionManager().sendBroadcast(A_CmsUI.getCmsObject(), cleanedHtml, this.m_repeat.getValue(), CmsBroadcast.ContentMode.html);
            USER_BROADCAST.put(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser(), new CmsBroadcast(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser(), cleanedHtml, this.m_repeat.getValue(), CmsBroadcast.ContentMode.html));
        } else {
            for (String id : sessionIds) {
                OpenCms.getSessionManager().sendBroadcast(A_CmsUI.getCmsObject(), cleanedHtml, id, this.m_repeat.getValue(), CmsBroadcast.ContentMode.html);
            }
        }
    }

    private void removeAllBroadcasts(Set<String> sessionIds) {
        if (sessionIds == null) {
            for (CmsSessionInfo info : OpenCms.getSessionManager().getSessionInfos()) {
                OpenCms.getSessionManager().getBroadcastQueue(info.getSessionId().getStringValue()).clear();
            }
            return;
        }
        for (String sessionId : sessionIds) {
            OpenCms.getSessionManager().getBroadcastQueue(sessionId).clear();
        }
    }

    private boolean validateMessage() {
        this.m_message.setComponentError(null);
        try {
            new CmsSessionsApp.MessageValidator().validate(this.m_message.getValue());
            return true;
        }
        catch (Validator.InvalidValueException e) {
            this.m_message.setComponentError((ErrorMessage)new UserError(e.getLocalizedMessage()));
            return false;
        }
    }
}

