/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.searchindex;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Panel;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.searchindex.CmsSearchindexApp;

public class CmsSearchindexRebuild
extends VerticalLayout {
    private static final long serialVersionUID = -3306537840428458751L;
    private Label m_confirm;
    private List<String> m_indexList;
    private FormLayout m_layout;
    private CmsSearchindexApp m_manager;
    private Button m_ok;
    private Panel m_reportPanel;
    private Panel m_startPanel;

    public CmsSearchindexRebuild(CmsSearchindexApp app, Set<String> data) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.setHeight("570px");
        this.m_manager = app;
        this.m_reportPanel.setVisible(false);
        this.m_confirm.setValue(CmsVaadinUtils.getMessageText("GUI_SEARCHINDEX_REBUILD_CONFIRM_1", this.getCommaSeperatedIndexes(data)));
        this.m_indexList = new ArrayList<String>(data);
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 7361499756763447027L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSearchindexRebuild.this.startThread();
            }
        });
    }

    protected void startThread() {
        this.m_reportPanel.setVisible(true);
        this.m_startPanel.setVisible(false);
        Component report = this.m_manager.getUpdateThreadComponent(this.m_indexList);
        report.setHeight("500px");
        report.setWidth("100%");
        this.m_layout.removeAllComponents();
        this.m_layout.addComponent(report);
    }

    private String getCommaSeperatedIndexes(Set<String> data) {
        Iterator<String> it = data.iterator();
        Object res = it.next();
        if (data.size() == 1) {
            return res;
        }
        res = (String)res + ", ";
        while (it.hasNext()) {
            res = (String)res + it.next() + ", ";
        }
        res = ((String)res).substring(0, ((String)res).length() - 2);
        return res;
    }
}

