/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.searchindex;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.searchindex.CmsSearchindexApp;
import org.opencms.ui.apps.searchindex.CmsSearchindexRebuild;
import org.opencms.ui.apps.searchindex.CmsSourceDialog;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;

public class CmsSearchIndexTable
extends Table {
    private static final long serialVersionUID = 5764331446498958798L;
    protected CmsSearchindexApp m_manager;
    private IndexedContainer m_container;
    private CmsContextMenu m_menu;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;

    public CmsSearchIndexTable(CmsSearchindexApp manager) {
        this.m_manager = manager;
        this.m_container = new IndexedContainer();
        this.setContainerDataSource((Container)this.m_container);
        for (TableProperty prop : TableProperty.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefaultValue());
            this.setColumnHeader((Object)prop, prop.getLocalizedMessage());
        }
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.setVisibleColumns(new Object[]{TableProperty.Name, TableProperty.FieldConfig, TableProperty.Rebuild, TableProperty.Project, TableProperty.Locale});
        this.setItemIconPropertyId((Object)TableProperty.Icon);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = -3595150969741628374L;

            public void itemClick(ItemClickEvent event) {
                CmsSearchIndexTable.this.onItemClick((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId());
            }
        });
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (TableProperty.Name.equals(propertyId)) {
                    return " o-hover-column";
                }
                return null;
            }
        });
    }

    public void loadTable() {
        this.m_container.removeAllItems();
        List<I_CmsSearchIndex> indexes = this.m_manager.getAllElements();
        for (I_CmsSearchIndex index : indexes) {
            if (!index.isEnabled()) continue;
            Item item = this.m_container.addItem((Object)index);
            item.getItemProperty((Object)TableProperty.Name).setValue((Object)index.getName());
            item.getItemProperty((Object)TableProperty.FieldConfig).setValue((Object)index.getFieldConfiguration().getName());
            item.getItemProperty((Object)TableProperty.Locale).setValue((Object)index.getLocale().getDisplayName());
            item.getItemProperty((Object)TableProperty.Project).setValue((Object)index.getProject());
            item.getItemProperty((Object)TableProperty.Rebuild).setValue((Object)index.getRebuildMode());
        }
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntrySources());
            this.m_menuEntries.add(new EntryRebuild());
        }
        return this.m_menuEntries;
    }

    void onItemClick(MouseEvents.ClickEvent event, Object itemId, Object propertyId) {
        if (!event.isCtrlKey() && !event.isShiftKey()) {
            this.changeValueIfNotMultiSelect(itemId);
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || propertyId == null) {
                this.m_menu.setEntries(this.getMenuEntries(), this.getSearchIndexNames());
                this.m_menu.openForTable(event, itemId, propertyId, this);
            } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && TableProperty.Name.equals(propertyId)) {
                this.showSourcesWindow(((I_CmsSearchIndex)((Set)this.getValue()).iterator().next()).getName());
            }
        }
    }

    void showSourcesWindow(String resource) {
        final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsSourceDialog sourceDialog = new CmsSourceDialog(this.m_manager, new Runnable(){

            @Override
            public void run() {
                window.close();
            }
        });
        sourceDialog.setSource(resource);
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_SEARCHINDEX_INDEXSOURCE_SHOW_1", resource));
        window.setContent((Component)sourceDialog);
        UI.getCurrent().addWindow(window);
    }

    private void changeValueIfNotMultiSelect(Object itemId) {
        Set value = (Set)this.getValue();
        if (value == null) {
            this.select(itemId);
        } else if (!value.contains(itemId)) {
            this.setValue(null);
            this.select(itemId);
        }
    }

    private Set<String> getSearchIndexNames() {
        HashSet<String> names = new HashSet<String>();
        Set indexes = (Set)this.getValue();
        for (I_CmsSearchIndex index : indexes) {
            names.add(index.getName());
        }
        return names;
    }

    static enum TableProperty {
        FieldConfig("GUI_SEARCHINDEX_COL_CONFIGURATION_0", String.class, "", false),
        Icon(null, Resource.class, new CmsCssIcon("oc-icon-24-database"), false),
        Locale("GUI_SEARCHINDEX_COL_LOCALE_0", String.class, "", false),
        Name("GUI_SEARCHINDEX_COL_NAME_0", String.class, "", false),
        Project("GUI_SEARCHINDEX_COL_PROJECT_0", String.class, "", false),
        Rebuild("GUI_SEARCHINDEX_COL_REBUILDMODE_0", String.class, "", false);

        private boolean m_collapsable;
        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableProperty(String headerMessage, Class<?> type, Object defaultValue, boolean collapsable) {
            this.m_headerMessage = headerMessage;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
            this.m_collapsable = collapsable;
        }

        static List<TableProperty> withHeader() {
            ArrayList<TableProperty> props = new ArrayList<TableProperty>();
            for (TableProperty prop : TableProperty.values()) {
                if (prop.m_headerMessage == null) continue;
                props.add(prop);
            }
            return props;
        }

        Object getDefaultValue() {
            return this.m_defaultValue;
        }

        String getLocalizedMessage() {
            if (this.m_headerMessage == null) {
                return "";
            }
            return CmsVaadinUtils.getMessageText(this.m_headerMessage, new Object[0]);
        }

        Class<?> getType() {
            return this.m_type;
        }

        boolean isCollapsable() {
            return this.m_collapsable;
        }
    }

    class EntrySources
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntrySources() {
        }

        @Override
        public void executeAction(Set<String> data) {
            String resource = data.iterator().next();
            CmsSearchIndexTable.this.showSourcesWindow(resource);
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_SEARCHINDEX_INDEXSOURCE_SHOW_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryRebuild
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryRebuild() {
        }

        @Override
        public void executeAction(Set<String> data) {
            final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
            CmsBasicDialog dialog = new CmsBasicDialog();
            dialog.setContent((Component)new CmsSearchindexRebuild(CmsSearchIndexTable.this.m_manager, data));
            Button closeButton = new Button(CmsVaadinUtils.messageClose());
            closeButton.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = -1043776488459785433L;

                public void buttonClick(Button.ClickEvent event) {
                    window.close();
                }
            });
            dialog.addButton((Component)closeButton, true);
            window.setContent((Component)dialog);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_SEARCHINDEX_ADMIN_TOOL_NAME_SHORT_0", new Object[0]));
            A_CmsUI.get().addWindow(window);
            window.center();
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_SEARCHINDEX_REBUILD_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }
}

