/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.search;

import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.UI;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsFileExplorer;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsCachableApp;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.search.CmsSearchReplaceSettings;
import org.opencms.ui.apps.search.CmsSearchReplaceThread;
import org.opencms.ui.apps.search.CmsSourceSearchForm;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsFileTableDialogContext;
import org.opencms.ui.report.CmsReportOverlay;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSourceSearchApp
extends A_CmsWorkplaceApp
implements I_CmsCachableApp {
    public static final String FOLDER = "f";
    public static final String IGNORE_SUBSITES = "igss";
    public static final String INDEX = "i";
    public static final String LOCALE = "l";
    public static final String PROJECT = "p";
    public static final String PROPERTY = "pr";
    public static final String QUERY = "q";
    public static final String REPLACE_PATTERN = "rp";
    public static final String RESOURCE_TYPE = "rt";
    public static final String SEARCH_PATTERN = "sp";
    public static final String SEARCH_TYPE = "t";
    public static final String SITE_ROOT = "s";
    public static final String XPATH = "x";
    private static final long serialVersionUID = 4675966043824229258L;
    CmsFileTable m_resultTable;
    private List<CmsResource> m_currentResources;
    private String m_currentState;
    private VerticalLayout m_infoEmptyResult;
    private VerticalLayout m_infoIntroLayout;
    private CmsReportOverlay m_report;
    private TextField m_resultTableFilter;
    private CmsSourceSearchForm m_searchForm;
    private CmsSearchReplaceThread m_thread;

    public static String generateState(CmsSearchReplaceSettings settings) {
        String state = "";
        state = A_CmsWorkplaceApp.addParamToState(state, SITE_ROOT, settings.getSiteRoot());
        state = A_CmsWorkplaceApp.addParamToState(state, SEARCH_TYPE, settings.getType().name());
        state = A_CmsWorkplaceApp.addParamToState(state, SEARCH_PATTERN, settings.getSearchpattern());
        if (!settings.getPaths().isEmpty()) {
            state = A_CmsWorkplaceApp.addParamToState(state, FOLDER, settings.getPaths().get(0));
        }
        state = A_CmsWorkplaceApp.addParamToState(state, RESOURCE_TYPE, settings.getTypes());
        state = A_CmsWorkplaceApp.addParamToState(state, LOCALE, settings.getLocale());
        state = A_CmsWorkplaceApp.addParamToState(state, QUERY, settings.getQuery());
        state = A_CmsWorkplaceApp.addParamToState(state, INDEX, settings.getSource());
        state = A_CmsWorkplaceApp.addParamToState(state, XPATH, settings.getXpath());
        state = A_CmsWorkplaceApp.addParamToState(state, IGNORE_SUBSITES, String.valueOf(settings.ignoreSubSites()));
        state = A_CmsWorkplaceApp.addParamToState(state, PROPERTY, settings.getProperty().getName());
        return state;
    }

    static CmsSearchReplaceSettings getSettingsFromState(String state) {
        try {
            state = new URLCodec().decode(state);
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        CmsSearchReplaceSettings settings = null;
        String typeString = A_CmsWorkplaceApp.getParamFromState(state, SEARCH_TYPE);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(typeString)) {
            String project;
            CmsSourceSearchForm.SearchType type = CmsSourceSearchForm.SearchType.valueOf(typeString);
            settings = new CmsSearchReplaceSettings();
            settings.setType(type);
            settings.setIgnoreSubSites(Boolean.parseBoolean(A_CmsWorkplaceApp.getParamFromState(state, IGNORE_SUBSITES)));
            settings.setSiteRoot(A_CmsWorkplaceApp.getParamFromState(state, SITE_ROOT).replace("%2F", "/"));
            settings.setPaths(Collections.singletonList(A_CmsWorkplaceApp.getParamFromState(state, FOLDER).replace("%2F", "/")));
            String resType = A_CmsWorkplaceApp.getParamFromState(state, RESOURCE_TYPE);
            if (resType != null) {
                settings.setTypes(resType);
            }
            if ((project = A_CmsWorkplaceApp.getParamFromState(state, PROJECT)) != null) {
                settings.setProject(project);
            }
            settings.setSearchpattern(A_CmsWorkplaceApp.getParamFromState(state, SEARCH_PATTERN).replace("%2F", "/"));
            if (type.isContentValuesOnly()) {
                settings.setOnlyContentValues(true);
                String locale = A_CmsWorkplaceApp.getParamFromState(state, LOCALE);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(locale)) {
                    settings.setLocale(locale);
                }
                settings.setXpath(A_CmsWorkplaceApp.getParamFromState(state, XPATH).replace("%2F", "/"));
            }
            if (type.isSolrSearch()) {
                settings.setQuery(A_CmsWorkplaceApp.getParamFromState(state, QUERY).replace("%2F", "/"));
                settings.setSource(A_CmsWorkplaceApp.getParamFromState(state, INDEX));
            }
            if (type.isPropertySearch()) {
                try {
                    settings.setProperty(A_CmsUI.getCmsObject().readPropertyDefinition(A_CmsWorkplaceApp.getParamFromState(state, PROPERTY)));
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
        }
        return settings;
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        context.addPublishButton(changed -> {});
        super.initUI(context);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public void onRestoreFromCache() {
        if (this.m_resultTable.getItemCount() < 200) {
            this.m_resultTable.update(this.m_resultTable.getAllIds(), false);
        } else if (this.m_currentResources != null) {
            HashSet<CmsUUID> ids = new HashSet<CmsUUID>();
            for (CmsResource res : this.m_currentResources) {
                ids.add(res.getStructureId());
            }
            this.m_resultTable.update(ids, false);
        }
    }

    @Override
    public void onStateChange(String state) {
        if (this.m_currentState == null || !this.m_currentState.equals(state)) {
            super.onStateChange(state);
        }
    }

    protected void displayResult() {
        if (this.m_thread.getMatchedResources().isEmpty()) {
            this.m_resultTable.setVisible(false);
            this.m_infoIntroLayout.setVisible(false);
            this.m_infoEmptyResult.setVisible(true);
            this.m_resultTable.fillTable(A_CmsUI.getCmsObject(), this.m_thread.getMatchedResources());
            this.m_searchForm.setDownload(null);
        } else {
            this.m_resultTable.setVisible(true);
            this.m_infoIntroLayout.setVisible(false);
            this.m_infoEmptyResult.setVisible(false);
            this.m_resultTable.fillTable(A_CmsUI.getCmsObject(), this.m_thread.getMatchedResources());
            SimpleDateFormat fmt = new SimpleDateFormat("hhmmss");
            String timeStr = fmt.format(new Date());
            String filename = "opencms_sourcesearch_" + timeStr + ".csv";
            StreamResource downloadResource = new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(this.m_resultTable.generateCsv()), filename);
            this.m_searchForm.setDownload(downloadResource);
        }
        this.m_searchForm.removeComponent((Component)this.m_report);
        this.m_report = null;
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        return null;
    }

    @Override
    protected Component getComponentForState(String state) {
        CmsSearchReplaceSettings settings;
        this.m_rootLayout.setMainHeightFull(true);
        HorizontalSplitPanel sp = new HorizontalSplitPanel();
        sp.setSizeFull();
        this.m_searchForm = new CmsSourceSearchForm(this);
        sp.setFirstComponent((Component)this.m_searchForm);
        VerticalLayout result = new VerticalLayout();
        result.setSizeFull();
        this.m_infoIntroLayout = CmsVaadinUtils.getInfoLayout("GUI_SOURCESEARCH_INTRO_0");
        this.m_infoEmptyResult = CmsVaadinUtils.getInfoLayout("GUI_SOURCESEARCH_EMPTY_0");
        this.m_resultTable = new CmsFileTable(null);
        result.addComponent((Component)this.m_resultTable);
        result.addComponent((Component)this.m_infoEmptyResult);
        result.addComponent((Component)this.m_infoIntroLayout);
        this.m_resultTable.setVisible(false);
        this.m_infoEmptyResult.setVisible(false);
        this.m_infoIntroLayout.setVisible(true);
        this.m_resultTable.applyWorkplaceAppSettings();
        this.m_resultTable.setContextProvider(new I_CmsContextProvider(){

            @Override
            public I_CmsDialogContext getDialogContext() {
                CmsFileTableDialogContext context = new CmsFileTableDialogContext("project-management", I_CmsDialogContext.ContextType.fileTable, CmsSourceSearchApp.this.m_resultTable, CmsSourceSearchApp.this.m_resultTable.getSelectedResources());
                CmsSourceSearchApp.this.storeCurrentFileSelection(CmsSourceSearchApp.this.m_resultTable.getSelectedResources());
                context.setEditableProperties(CmsFileExplorer.INLINE_EDIT_PROPERTIES);
                return context;
            }
        });
        this.m_resultTable.setSizeFull();
        if (this.m_resultTableFilter == null) {
            this.m_resultTableFilter = new TextField();
            this.m_resultTableFilter.setIcon((Resource)FontOpenCms.FILTER);
            this.m_resultTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
            this.m_resultTableFilter.addStyleName("inline-icon");
            this.m_resultTableFilter.setWidth("200px");
            this.m_resultTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
                private static final long serialVersionUID = 1L;

                public void textChange(FieldEvents.TextChangeEvent event) {
                    CmsSourceSearchApp.this.m_resultTable.filterTable(event.getText());
                }
            });
            this.m_infoLayout.addComponent((Component)this.m_resultTableFilter);
        }
        sp.setSecondComponent((Component)result);
        sp.setSplitPosition(399.0f, Sizeable.Unit.PIXELS);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(state) && (settings = CmsSourceSearchApp.getSettingsFromState(state)) != null) {
            this.m_currentState = state;
            this.m_searchForm.initFormValues(settings);
            this.search(settings, false);
        }
        return sp;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    protected void search(CmsSearchReplaceSettings settings, boolean updateState) {
        if (updateState) {
            String state = CmsSourceSearchApp.generateState(settings);
            CmsAppWorkplaceUi.get().changeCurrentAppState(state);
            this.m_currentState = state;
        }
        try {
            CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            if (settings.getSiteRoot() != null) {
                cms.getRequestContext().setSiteRoot(settings.getSiteRoot());
            }
            this.m_thread = new CmsSearchReplaceThread(A_CmsUI.get().getHttpSession(), cms, settings);
            if (this.m_report != null) {
                this.m_searchForm.removeComponent((Component)this.m_report);
            }
            this.m_report = new CmsReportOverlay(this.m_thread);
            this.m_report.addReportFinishedHandler(new Runnable(){

                @Override
                public void run() {
                    CmsSourceSearchApp.this.displayResult();
                }
            });
            this.m_searchForm.addComponent((Component)this.m_report);
            this.m_report.setTitle(CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_REPORT_TITLE_0", new Object[0]));
            this.m_thread.start();
            this.m_resultTableFilter.clear();
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    void storeCurrentFileSelection(List<CmsResource> resources) {
        this.m_currentResources = resources;
    }
}

