/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.search;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.ui.apps.search.CmsSourceSearchForm;
import org.opencms.util.CmsStringUtil;

public class CmsSearchReplaceSettings
implements Serializable {
    private static final long serialVersionUID = 1122133222446934991L;
    private boolean m_forceReplace;
    private String m_locale;
    private String m_message;
    private boolean m_onlyContentValues;
    private List<String> m_paths = new LinkedList<String>();
    private String m_project;
    private String m_query;
    private String m_replacepattern;
    private String[] m_resources;
    private String m_searchpattern;
    private String m_source;
    private CmsSourceSearchForm.SearchType m_type;
    private String[] m_types;
    private String m_xpath;
    private String m_siteRoot;
    private CmsPropertyDefinition m_property = CmsPropertyDefinition.getNullPropertyDefinition();
    private boolean m_ignoreSubSites;
    private CmsResource m_element;

    public CmsSearchReplaceSettings() {
        this.m_paths.add("/");
    }

    public static String replaceElementInPagePattern(CmsResource resource) {
        return "<target><![CDATA[" + resource.getRootPath() + "]]></target>//t<uuid>" + resource.getStructureId().getStringValue() + "</uuid>";
    }

    public static String searchElementInPagePattern(CmsResource resource) {
        return "<target>.{0,9}" + resource.getRootPath() + ".{0,3}</target>\\s*<uuid>" + resource.getStructureId().getStringValue() + "</uuid>";
    }

    public CmsResource getElementResource() {
        return this.m_element;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public String getMessage() {
        return this.m_message;
    }

    public List<String> getPaths() {
        return this.m_paths;
    }

    public String getProject() {
        return this.m_project;
    }

    public CmsPropertyDefinition getProperty() {
        return this.m_property;
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getReplacepattern() {
        return this.m_replacepattern;
    }

    public String getResources() {
        return CmsStringUtil.arrayAsString(this.m_resources, ",");
    }

    public String[] getResourcesArray() {
        return this.m_resources;
    }

    public String getSearchpattern() {
        return this.m_searchpattern;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public String getSource() {
        return this.m_source;
    }

    public CmsSourceSearchForm.SearchType getType() {
        return this.m_type;
    }

    public String getTypes() {
        return this.m_types != null ? CmsStringUtil.arrayAsString(this.m_types, ",") : "";
    }

    public String[] getTypesArray() {
        return this.m_types;
    }

    public String getXpath() {
        return this.m_xpath;
    }

    public boolean ignoreSubSites() {
        return this.m_ignoreSubSites;
    }

    public boolean isForceReplace() {
        return this.m_forceReplace;
    }

    public boolean isOnlyContentValues() {
        return this.m_onlyContentValues;
    }

    public boolean isSolrSearch() {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_source) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_query);
    }

    public void setElementResource(CmsResource resource) {
        this.m_element = resource;
    }

    public void setForceReplace(boolean forceReplace) {
        this.m_forceReplace = forceReplace;
    }

    public void setIgnoreSubSites(boolean ignore) {
        this.m_ignoreSubSites = ignore;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }

    public void setMessage(String message) {
    }

    public void setOnlyContentValues(boolean onlyContentValue) {
        this.m_onlyContentValues = onlyContentValue;
    }

    public void setPaths(List<String> paths) {
        this.m_paths = paths;
    }

    public void setProject(String project) {
        this.m_project = project;
    }

    public void setProperty(CmsPropertyDefinition value) {
        this.m_property = value;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }

    public void setReplacepattern(String replacepattern) {
        this.m_replacepattern = replacepattern;
    }

    public void setResources(String resources) {
        this.m_resources = CmsStringUtil.splitAsArray(resources, ",");
    }

    public void setSearchpattern(String searchpattern) {
        this.m_searchpattern = searchpattern;
    }

    public void setSiteRoot(String siteRoot) {
        this.m_siteRoot = siteRoot;
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    public void setType(CmsSourceSearchForm.SearchType type) {
        this.m_type = type;
    }

    public void setTypes(String types) {
        this.m_types = CmsStringUtil.splitAsArray(types, ",");
    }

    public void setXpath(String xpath) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(xpath)) {
            if ((xpath = xpath.trim()).startsWith("/")) {
                xpath = xpath.substring(1);
            }
            if (xpath.endsWith("/")) {
                xpath = xpath.substring(0, xpath.length() - 1);
            }
        }
        this.m_xpath = xpath;
    }
}

