/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.resourcetypes;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import java.util.LinkedHashMap;
import java.util.List;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.resourcetypes.CmsMoveResourceTypeDialog;
import org.opencms.ui.apps.resourcetypes.CmsNewResourceTypeDialog;
import org.opencms.ui.apps.resourcetypes.CmsResourceTypesTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.util.CmsStringUtil;

public class CmsResourceTypeApp
extends A_CmsWorkplaceApp {
    private TextField m_resourcetypeTableFilter;
    private CmsResourceTypesTable m_table;

    public static boolean isResourceTypeIdFree(int id) {
        try {
            OpenCms.getResourceManager().getResourceType(id);
        }
        catch (CmsLoaderException e) {
            return true;
        }
        return false;
    }

    public static boolean isResourceTypeNameFree(String name) {
        try {
            OpenCms.getResourceManager().getResourceType(name);
        }
        catch (CmsLoaderException e) {
            return true;
        }
        return false;
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        context.addPublishButton(changes -> {});
        super.initUI(context);
    }

    public void reload() {
        this.m_table.init();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_resourcetypeTableFilter.getValue())) {
            this.m_table.filterTable((String)this.m_resourcetypeTableFilter.getValue());
        }
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        return null;
    }

    @Override
    protected Component getComponentForState(String state) {
        this.addToolbarButtons();
        this.m_table = new CmsResourceTypesTable(this);
        this.m_resourcetypeTableFilter = new TextField();
        this.m_resourcetypeTableFilter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_resourcetypeTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_resourcetypeTableFilter.addStyleName("inline-icon");
        this.m_resourcetypeTableFilter.setWidth("200px");
        this.m_resourcetypeTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsResourceTypeApp.this.m_table.filterTable(event.getText());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_resourcetypeTableFilter);
        this.m_rootLayout.setMainHeightFull(true);
        return this.m_table;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    private void addToolbarButtons() {
        Button add = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_CREATE_NEW_TYPE_0", new Object[0]));
        add.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
                CmsNewResourceTypeDialog dialog = new CmsNewResourceTypeDialog(window, CmsResourceTypeApp.this);
                CmsMoveResourceTypeDialog moduleDialog = new CmsMoveResourceTypeDialog(dialog);
                window.setContent((Component)moduleDialog);
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_CREATE_NEW_TYPE_0", new Object[0]));
                A_CmsUI.get().addWindow(window);
            }
        });
        this.m_uiContext.addToolbarButton((Component)add);
    }
}

