/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.publishqueue;

import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobBase;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsUUID;

public class CmsPublishResources
extends VerticalLayout {
    private static Log LOG = CmsLog.getLog(CmsPublishResources.class.getName());
    private static final long serialVersionUID = -3197777771233458574L;
    private String m_caption;
    private VerticalLayout m_panel;

    public CmsPublishResources(String id) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsPublishJobBase job = OpenCms.getPublishManager().getJobByPublishHistoryId(new CmsUUID(id));
        this.m_caption = CmsVaadinUtils.getMessageText("GUI_PQUEUE_RESOURCES_2", job.getProjectName(), job.getUserName(A_CmsUI.getCmsObject()));
        String resourcesHTML = "";
        try {
            resourcesHTML = this.getResourcesHTML(job);
        }
        catch (NumberFormatException | CmsException e) {
            LOG.error((Object)"Error reading publish resources", (Throwable)e);
        }
        Label label = new Label();
        label.setValue(resourcesHTML);
        label.setContentMode(ContentMode.HTML);
        label.setHeight("700px");
        label.addStyleName("v-scrollable");
        label.addStyleName("o-report");
        this.m_panel.addComponent((Component)label);
    }

    public String getCaption() {
        return this.m_caption;
    }

    private String getResourcesHTML(CmsPublishJobBase job) throws CmsException {
        Object ret = "";
        if (job instanceof CmsPublishJobEnqueued) {
            List<CmsResource> resources = ((CmsPublishJobEnqueued)job).getPublishList().getAllResources();
            for (CmsResource res : resources) {
                ret = (String)ret + res.getRootPath() + "<br/>";
            }
        } else {
            List<CmsPublishedResource> resources = A_CmsUI.getCmsObject().readPublishedResources(job.getPublishHistoryId());
            for (CmsPublishedResource res : resources) {
                ret = (String)ret + res.getRootPath() + "<br/>";
            }
        }
        return ret;
    }
}

