/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.projects;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsFileExplorer;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.projects.CmsEditProjectForm;
import org.opencms.ui.apps.projects.CmsProjectHistoryTable;
import org.opencms.ui.apps.projects.CmsProjectsTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsFileTableDialogContext;
import org.opencms.ui.components.CmsInfoButton;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsProjectManager
extends A_CmsWorkplaceApp {
    public static final String PATH_NAME_FILES = "files";
    public static final String PATH_NAME_HISTORY = "history";
    private static Log LOG = CmsLog.getLog(CmsProjectManager.class.getName());
    CmsProjectsTable m_projectsTable;
    private TextField m_fileTableFilter;
    private List<Component> m_navButtons = new ArrayList<Component>();
    private TextField m_projectTableFilter;

    protected CmsProjectsTable createProjectsTable() {
        CmsProjectsTable table = new CmsProjectsTable(this);
        table.loadProjects();
        return table;
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        CmsUUID projectId;
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (!OpenCms.getRoleManager().hasRole(A_CmsUI.getCmsObject(), CmsRole.PROJECT_MANAGER)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_FILES_1", A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().getName()));
        } else if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_0", new Object[0]));
        } else if (state.equals(PATH_NAME_HISTORY)) {
            crumbs.put("project-management", CmsVaadinUtils.getMessageText("GUI_PROJECTS_0", new Object[0]));
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_HISTORY_0", new Object[0]));
        } else if (state.startsWith(PATH_NAME_FILES) && (projectId = this.getIdFromState(state)) != null) {
            crumbs.put("project-management", CmsVaadinUtils.getMessageText("GUI_PROJECTS_0", new Object[0]));
            try {
                crumbs.put("", CmsVaadinUtils.getMessageText("GUI_PROJECTS_FILES_1", A_CmsUI.getCmsObject().readProject(projectId).getName()));
            }
            catch (CmsException e) {
                LOG.error((Object)"Error reading project for bread crumb.", (Throwable)e);
            }
        }
        return crumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        if (!OpenCms.getRoleManager().hasRole(A_CmsUI.getCmsObject(), CmsRole.PROJECT_MANAGER)) {
            return this.prepareProjectFilesTable(A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().getUuid());
        }
        if (this.m_fileTableFilter != null) {
            this.m_infoLayout.removeComponent((Component)this.m_fileTableFilter);
            this.m_fileTableFilter = null;
        }
        if (this.m_projectTableFilter != null) {
            this.m_infoLayout.removeComponent((Component)this.m_projectTableFilter);
            this.m_projectTableFilter = null;
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            this.m_rootLayout.setMainHeightFull(true);
            if (this.m_projectsTable == null) {
                this.m_projectsTable = this.createProjectsTable();
            } else {
                this.m_projectsTable.loadProjects();
            }
            this.m_projectTableFilter = new TextField();
            this.m_projectTableFilter.setIcon((Resource)FontOpenCms.FILTER);
            this.m_projectTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
            this.m_projectTableFilter.addStyleName("inline-icon");
            this.m_projectTableFilter.setWidth("200px");
            this.m_projectTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
                private static final long serialVersionUID = 1L;

                public void textChange(FieldEvents.TextChangeEvent event) {
                    CmsProjectManager.this.m_projectsTable.filterTable(event.getText());
                }
            });
            this.m_infoLayout.addComponent((Component)this.m_projectTableFilter);
            this.showNavButtons();
            return this.m_projectsTable;
        }
        if (state.equals(PATH_NAME_HISTORY)) {
            this.m_rootLayout.setMainHeightFull(true);
            this.hideNavButtons();
            return new CmsProjectHistoryTable();
        }
        if (state.startsWith(PATH_NAME_FILES)) {
            this.hideNavButtons();
            CmsUUID projectId = this.getIdFromState(state);
            if (projectId != null) {
                return this.prepareProjectFilesTable(projectId);
            }
        }
        return null;
    }

    protected CmsFileTable getProjectFiles(CmsUUID projectId) {
        final CmsFileTable fileTable = new CmsFileTable(null);
        fileTable.applyWorkplaceAppSettings();
        fileTable.setContextProvider(new I_CmsContextProvider(){

            @Override
            public I_CmsDialogContext getDialogContext() {
                CmsFileTableDialogContext context = new CmsFileTableDialogContext("project-management", I_CmsDialogContext.ContextType.fileTable, fileTable, fileTable.getSelectedResources());
                context.setEditableProperties(CmsFileExplorer.INLINE_EDIT_PROPERTIES);
                return context;
            }
        });
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            List<CmsResource> childResources = cms.readProjectView(projectId, CmsResource.STATE_KEEP);
            fileTable.fillTable(cms, childResources);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_PROJECTS_CAN_NOT_DISPLAY_FILES_0", new Object[0]), e);
        }
        return fileTable;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    private CmsUUID getIdFromState(String state) {
        CmsUUID result = null;
        String temp = A_CmsWorkplaceApp.getParamFromState(state, "projectId");
        if (CmsUUID.isValidUUID(temp)) {
            result = new CmsUUID(temp);
        }
        return result;
    }

    private void hideNavButtons() {
        for (Component button : this.m_navButtons) {
            button.setVisible(false);
        }
    }

    private CmsFileTable prepareProjectFilesTable(CmsUUID projectId) {
        this.m_rootLayout.setMainHeightFull(true);
        final CmsFileTable fileTable = this.getProjectFiles(projectId);
        this.m_fileTableFilter = new TextField();
        this.m_fileTableFilter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_fileTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_fileTableFilter.addStyleName("inline-icon");
        this.m_fileTableFilter.setWidth("200px");
        this.m_fileTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                fileTable.filterTable(event.getText());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_fileTableFilter);
        return fileTable;
    }

    private void showNavButtons() {
        if (this.m_navButtons.isEmpty()) {
            Button addProject = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_PROJECTS_ADD_0", new Object[0]));
            addProject.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                    CmsEditProjectForm form = new CmsEditProjectForm(CmsProjectManager.this.m_projectsTable, window);
                    window.setContent((Component)form);
                    window.setCaption(CmsVaadinUtils.getMessageText("GUI_PROJECTS_ADD_0", new Object[0]));
                    A_CmsUI.get().addWindow(window);
                    window.center();
                }
            });
            this.m_uiContext.addToolbarButton((Component)addProject);
            this.m_navButtons.add((Component)addProject);
            Button history = CmsToolBar.createButton((Resource)FontOpenCms.CLIPBOARD, CmsVaadinUtils.getMessageText("GUI_PROJECTS_HISTORY_0", new Object[0]));
            history.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    CmsProjectManager.this.openSubView(CmsProjectManager.PATH_NAME_HISTORY, true);
                }
            });
            this.m_uiContext.addToolbarButton((Component)history);
            this.m_navButtons.add((Component)history);
            try {
                LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
                infos.put(CmsVaadinUtils.getMessageText("GUI_PROJECTS_STATISTICS_COUNT_0", new Object[0]), String.valueOf(OpenCms.getOrgUnitManager().getAllManageableProjects(A_CmsUI.getCmsObject(), "", true).size()));
                CmsInfoButton infoButton = new CmsInfoButton(infos);
                infoButton.setWindowCaption(CmsVaadinUtils.getMessageText("GUI_PROJECTS_STATISTICS_0", new Object[0]));
                infoButton.setDescription(CmsVaadinUtils.getMessageText("GUI_PROJECTS_STATISTICS_0", new Object[0]));
                this.m_uiContext.addToolbarButton((Component)infoButton);
            }
            catch (CmsException e) {
                LOG.error((Object)"unable to get orgunit manager", (Throwable)e);
            }
        } else {
            for (Component button : this.m_navButtons) {
                button.setVisible(true);
            }
        }
    }
}

