/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules.edit;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vaadin.ui.AbstractComponentContainer;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.TabSheet;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.fieldgroup.BeanFieldGroup;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.TextArea;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.CmsSiteSelectorOptionBuilder;
import org.opencms.ade.galleries.shared.CmsSiteSelectorOption;
import org.opencms.db.CmsExportPoint;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.lock.CmsLockException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleVersion;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.modules.CmsModuleApp;
import org.opencms.ui.apps.modules.edit.CmsExportPointWidget;
import org.opencms.ui.apps.modules.edit.CmsModuleDependencyWidget;
import org.opencms.ui.apps.modules.edit.CmsModuleResourceSelectField;
import org.opencms.ui.apps.modules.edit.CmsSiteSelectorNewValueHandler;
import org.opencms.ui.components.CmsAutoItemCreatingComboBox;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsRemovableFormRow;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.ui.util.CmsComponentField;
import org.opencms.ui.util.CmsNullToEmptyConverter;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsEditModuleForm
extends CmsBasicDialog {
    public static final String COMPLEX_ROW = "o-module-complex-row";
    public static final String ID_EMPTY_SITE = "!empty";
    public static final String PATH_CLASSES = "classes/";
    public static final String PATH_ELEMENTS = "elements/";
    public static final String PATH_FORMATTERS = "formatters/";
    private static final String SUFFIX_BUNDLE_FILE = ".messages";
    public static final String PATH_LIB = "lib/";
    public static final String PATH_RESOURCES = "resources/";
    public static final String PATH_SCHEMAS = "schemas/";
    public static final String PATH_TEMPLATES = "templates/";
    private static final Log LOG = CmsLog.getLog(CmsEditModuleForm.class);
    private static final String PROPERTY_SITE_NAME = "name";
    private static final long serialVersionUID = 1L;
    private static final String PATH_i18n = "i18n/";
    public static final String CONFIG_FILE = ".config";
    private TextField m_actionClass;
    private TextField m_authorEmail;
    private TextField m_authorName;
    private CheckBox m_autoIncrement;
    private Button m_cancel;
    private FormLayout m_dependencies;
    private CmsEditableGroup m_dependencyGroup;
    private TextArea m_description;
    private FormLayout m_excludedResources;
    private CmsEditableGroup m_excludedResourcesGroup;
    private CmsEditableGroup m_exportPointGroup;
    private VerticalLayout m_exportPoints;
    private BeanFieldGroup<CmsModule> m_fieldGroup = new BeanFieldGroup(CmsModule.class);
    private CheckBox m_folderClasses;
    private CheckBox m_folderI18N;
    private CheckBox m_folderFormatters;
    private CheckBox m_folderLib;
    private CheckBox m_folderModule;
    private CheckBox m_folderResources;
    private CheckBox m_folderSchemas;
    private CheckBox m_folderTemplates;
    private TextField m_group;
    private CheckBox m_hasImportSite;
    private TextArea m_importScript;
    private CmsAutoItemCreatingComboBox m_importSite;
    private CmsComponentField<CmsResourceInfo> m_info = new CmsComponentField();
    private CmsModule m_module;
    private FormLayout m_moduleResources;
    private CmsEditableGroup m_moduleResourcesGroup;
    private TextField m_name;
    private boolean m_new;
    private TextField m_niceName;
    private Button m_ok;
    private CmsModule m_oldModuleInstance;
    private CmsEditableGroup m_parameterGroup;
    private FormLayout m_parameters;
    private CheckBox m_reducedMetadata;
    private TabSheet m_tabs;
    private Runnable m_updateCallback;
    private TextField m_version;

    public CmsEditModuleForm(CmsModule module, boolean newModule, Runnable updateCallback) {
        this.m_oldModuleInstance = module;
        this.m_module = module.clone();
        String site = this.m_module.getSite();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(site) && !(site = site.trim()).equals("/")) {
            site = CmsFileUtil.removeTrailingSeparator(site);
            this.m_module.setSite(site);
        }
        this.m_new = newModule;
        this.m_updateCallback = updateCallback;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        IndexedContainer importSitesModel = CmsEditModuleForm.getModuleSiteContainer(A_CmsUI.getCmsObject(), PROPERTY_SITE_NAME, this.m_module.getSite());
        this.m_importSite.setContainerDataSource((Container)importSitesModel);
        this.m_importSite.setNullSelectionItemId(ID_EMPTY_SITE);
        this.m_importSite.setItemCaptionPropertyId(PROPERTY_SITE_NAME);
        this.m_importSite.setNewValueHandler(new CmsSiteSelectorNewValueHandler(PROPERTY_SITE_NAME));
        if (this.m_new) {
            this.m_module.setCreateModuleFolder(true);
            this.m_module.setCreateI18NFolder(true);
        }
        this.m_fieldGroup.setItemDataSource((Object)this.m_module);
        this.m_fieldGroup.bind((Field)this.m_name, (Object)PROPERTY_SITE_NAME);
        this.m_fieldGroup.bind((Field)this.m_niceName, (Object)"niceName");
        this.m_fieldGroup.bind((Field)this.m_description, (Object)"description");
        this.m_fieldGroup.bind((Field)this.m_version, (Object)"versionStr");
        this.m_fieldGroup.bind((Field)this.m_group, (Object)"group");
        this.m_fieldGroup.bind((Field)this.m_actionClass, (Object)"actionClass");
        this.m_fieldGroup.bind((Field)this.m_importScript, (Object)"importScript");
        this.m_fieldGroup.bind((Field)this.m_importSite, (Object)"site");
        this.m_fieldGroup.bind((Field)this.m_hasImportSite, (Object)"hasImportSite");
        this.m_fieldGroup.bind((Field)this.m_authorName, (Object)"authorName");
        this.m_fieldGroup.bind((Field)this.m_authorEmail, (Object)"authorEmail");
        this.m_fieldGroup.bind((Field)this.m_reducedMetadata, (Object)"reducedExportMode");
        this.m_fieldGroup.bind((Field)this.m_folderModule, (Object)"createModuleFolder");
        this.m_fieldGroup.bind((Field)this.m_folderClasses, (Object)"createClassesFolder");
        this.m_fieldGroup.bind((Field)this.m_folderI18N, (Object)"createI18NFolder");
        this.m_fieldGroup.bind((Field)this.m_folderFormatters, (Object)"createFormattersFolder");
        this.m_fieldGroup.bind((Field)this.m_folderLib, (Object)"createLibFolder");
        this.m_fieldGroup.bind((Field)this.m_folderResources, (Object)"createResourcesFolder");
        this.m_fieldGroup.bind((Field)this.m_folderSchemas, (Object)"createSchemasFolder");
        this.m_fieldGroup.bind((Field)this.m_autoIncrement, (Object)"autoIncrement");
        if (this.m_new) {
            this.m_reducedMetadata.setValue((Object)Boolean.TRUE);
            this.m_name.addValidator(new Validator(){
                private static final long serialVersionUID = 1L;

                public void validate(Object value) throws Validator.InvalidValueException {
                    if (OpenCms.getModuleManager().hasModule((String)value)) {
                        throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_MODULES_MODULE_ALREADY_EXISTS_0", new Object[0]));
                    }
                    if (!CmsStringUtil.isValidJavaClassName((String)value)) {
                        throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_MODULES_INVALID_MODULE_NAME_0", new Object[0]));
                    }
                }
            });
        }
        this.m_version.addValidator(new Validator(){
            private static final long serialVersionUID = 1L;

            public void validate(Object value) throws Validator.InvalidValueException {
                try {
                    CmsModuleVersion cmsModuleVersion = new CmsModuleVersion(String.valueOf(value));
                }
                catch (Exception e) {
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_MODULES_INVALID_MODULE_VERSION_0", new Object[0]));
                }
            }
        });
        this.m_fieldGroup.bind((Field)this.m_folderTemplates, (Object)"createTemplateFolder");
        for (AbstractField field : new AbstractField[]{this.m_name, this.m_niceName, this.m_group, this.m_importScript, this.m_actionClass}) {
            field.setConverter((Converter)new CmsNullToEmptyConverter());
        }
        if (!newModule) {
            for (AbstractField field : new AbstractField[]{this.m_folderModule, this.m_folderClasses, this.m_folderI18N, this.m_folderFormatters, this.m_folderLib, this.m_folderResources, this.m_folderSchemas, this.m_folderTemplates}) {
                field.setVisible(false);
            }
            this.m_name.setEnabled(false);
        }
        Supplier<Component> moduleResourceFieldFactory = new Supplier<Component>(){

            public Component get() {
                return CmsEditModuleForm.this.createModuleResourceField(null);
            }
        };
        String addResourceButtonText = CmsVaadinUtils.getMessageText("GUI_MODULES_ADD_RESOURCE_0", new Object[0]);
        this.m_moduleResourcesGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_moduleResources, moduleResourceFieldFactory, addResourceButtonText);
        this.m_excludedResourcesGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_excludedResources, moduleResourceFieldFactory, addResourceButtonText);
        this.m_parameterGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_parameters, new Supplier<Component>(){

            public Component get() {
                TextField result = new TextField();
                return result;
            }
        }, CmsVaadinUtils.getMessageText("GUI_MODULES_ADD_PARAMETER_0", new Object[0]));
        this.m_exportPointGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_exportPoints, new Supplier<Component>(){

            public Component get() {
                return new CmsExportPointWidget("", "");
            }
        }, CmsVaadinUtils.getMessageText("GUI_MODULES_ADD_EXPORT_POINT_0", new Object[0]));
        this.m_dependencyGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_dependencies, new Supplier<Component>(){

            public Component get() {
                CmsModuleDependencyWidget component = CmsModuleDependencyWidget.create(null);
                return component;
            }
        }, CmsVaadinUtils.getMessageText("GUI_MODULES_ADD_DEPENDENCY_0", new Object[0]));
        this.m_moduleResourcesGroup.init();
        this.m_excludedResourcesGroup.init();
        this.m_parameterGroup.init();
        this.m_exportPointGroup.init();
        this.m_dependencyGroup.init();
        String resourceListError = CmsVaadinUtils.getMessageText("GUI_MODULES_RESOURCE_LIST_ERROR_0", new Object[0]);
        this.m_moduleResourcesGroup.setErrorMessage(resourceListError);
        this.m_excludedResourcesGroup.setErrorMessage(resourceListError);
        SortedMap<String, String> params = module.getParameters();
        for (Map.Entry entry : params.entrySet()) {
            this.addParameter((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        for (CmsModuleDependency dependency : module.getDependencies()) {
            this.addDependencyRow(dependency);
        }
        for (CmsExportPoint exportPoint : module.getExportPoints()) {
            this.addExportPointRow(exportPoint.getUri(), exportPoint.getConfiguredDestination());
        }
        for (String moduleResource : module.getResources()) {
            this.addModuleResource(moduleResource);
        }
        for (String excludedResource : module.getExcludeResources()) {
            this.addExcludedResource(excludedResource);
        }
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsVaadinUtils.getWindow((Component)CmsEditModuleForm.this).close();
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsEditModuleForm.this.updateModule();
            }
        });
        this.m_importSite.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                String siteRoot = (String)event.getProperty().getValue();
                CmsEditModuleForm.this.updateSiteInfo(siteRoot);
            }
        });
        this.m_info.set(new CmsResourceInfo("", "", ""));
        this.m_info.get().getResourceIcon().initContent(null, CmsModuleApp.Icons.RESINFO_ICON, null, false, false);
        this.updateSiteInfo(module.getSite());
        this.displayResourceInfoDirectly(Arrays.asList(this.m_info.get()));
    }

    public static IndexedContainer getModuleSiteContainer(CmsObject cms, String captionPropertyName, String prevValue) {
        CmsSiteSelectorOptionBuilder optBuilder = new CmsSiteSelectorOptionBuilder(cms);
        optBuilder.addNormalSites(true, new CmsUserSettings(cms).getStartFolder());
        IndexedContainer availableSites = new IndexedContainer();
        availableSites.addContainerProperty((Object)captionPropertyName, String.class, null);
        for (CmsSiteSelectorOption option : optBuilder.getOptions()) {
            String siteRoot = option.getSiteRoot();
            if (siteRoot.equals("")) {
                siteRoot = "/";
            }
            Item siteItem = availableSites.addItem((Object)siteRoot);
            siteItem.getItemProperty((Object)captionPropertyName).setValue((Object)option.getMessage());
        }
        if (!availableSites.containsId((Object)prevValue)) {
            String caption = prevValue;
            String siteId = prevValue;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(prevValue)) {
                caption = CmsVaadinUtils.getMessageText("GUI_MODULES_MODULE_SITE_NONE_0", new Object[0]);
                siteId = ID_EMPTY_SITE;
            }
            availableSites.addItem((Object)siteId).getItemProperty((Object)captionPropertyName).setValue((Object)caption);
        }
        return availableSites;
    }

    public void addDependencyRow(CmsModuleDependency dep) {
        CmsModuleDependencyWidget w = CmsModuleDependencyWidget.create(dep);
        this.m_dependencyGroup.addRow((Component)w);
    }

    public void addExportPointRow(String src, String target) {
        CmsExportPointWidget exportPointWidget = new CmsExportPointWidget(src, target);
        this.m_exportPointGroup.addRow((Component)exportPointWidget);
    }

    public void updateModule() {
        try {
            this.m_fieldGroup.commit();
            TreeMap params = Maps.newTreeMap();
            for (I_CmsEditableGroupRow i_CmsEditableGroupRow : this.m_parameterGroup.getRows()) {
                TextField textField = (TextField)i_CmsEditableGroupRow.getComponent();
                String string = (String)textField.getValue();
                int eqPos = string.indexOf("=");
                if (eqPos < 0) continue;
                String key = string.substring(0, eqPos);
                key = key.trim();
                String value = string.substring(eqPos + 1);
                value = value.trim();
                if (CmsStringUtil.isEmpty(key)) continue;
                params.put(key, value);
            }
            this.m_module.setParameters(params);
            ArrayList exportPoints = Lists.newArrayList();
            for (I_CmsEditableGroupRow i_CmsEditableGroupRow : this.m_exportPointGroup.getRows()) {
                CmsExportPointWidget cmsExportPointWidget = (CmsExportPointWidget)i_CmsEditableGroupRow.getComponent();
                String source = cmsExportPointWidget.getUri().trim();
                String target = cmsExportPointWidget.getDestination().trim();
                if (CmsStringUtil.isEmpty(source) || CmsStringUtil.isEmpty(target)) continue;
                CmsExportPoint point = new CmsExportPoint(source, target);
                exportPoints.add(point);
            }
            this.m_module.setExportPoints(exportPoints);
            ArrayList arrayList = Lists.newArrayList();
            for (CmsModuleDependencyWidget cmsModuleDependencyWidget : this.getFormRowChildren((AbstractComponentContainer)this.m_dependencies, CmsModuleDependencyWidget.class)) {
                String moduleName = cmsModuleDependencyWidget.getModuleName();
                String moduleVersion = cmsModuleDependencyWidget.getModuleVersion();
                try {
                    CmsModuleDependency dep = new CmsModuleDependency(moduleName, new CmsModuleVersion(moduleVersion));
                    arrayList.add(dep);
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.m_module.setDependencies(arrayList);
            ArrayList arrayList2 = Lists.newArrayList();
            for (I_CmsEditableGroupRow row : this.m_moduleResourcesGroup.getRows()) {
                CmsModuleResourceSelectField field = (CmsModuleResourceSelectField)row.getComponent();
                String moduleResource = field.getValue().trim();
                if (moduleResource.isEmpty()) continue;
                arrayList2.add(moduleResource);
            }
            this.m_module.setResources(arrayList2);
            ArrayList arrayList3 = Lists.newArrayList();
            for (I_CmsEditableGroupRow row : this.m_excludedResourcesGroup.getRows()) {
                CmsModuleResourceSelectField field = (CmsModuleResourceSelectField)row.getComponent();
                String moduleResource = field.getValue().trim();
                if (moduleResource.isEmpty()) continue;
                arrayList3.add(moduleResource);
            }
            this.m_module.setExcludeResources(arrayList3);
            if (!this.m_oldModuleInstance.isAutoIncrement() && this.m_module.isAutoIncrement()) {
                this.m_module.setCheckpointTime(System.currentTimeMillis());
            }
            CmsObject cms = A_CmsUI.getCmsObject();
            if (this.m_new) {
                this.createModuleFolders(cms, this.m_module);
                OpenCms.getModuleManager().addModule(cms, this.m_module);
            } else {
                OpenCms.getModuleManager().updateModule(cms, this.m_module);
            }
            CmsVaadinUtils.getWindow((Component)this).close();
            this.m_updateCallback.run();
        }
        catch (FieldGroup.CommitException e) {
            if (e.getCause() instanceof FieldGroup.FieldGroupInvalidValueException) {
                int minTabIdx = 999;
                for (Field field : e.getInvalidFields().keySet()) {
                    int n = this.getTabIndex((Component)field);
                    if (n == -1) continue;
                    minTabIdx = Math.min(n, minTabIdx);
                }
                this.m_tabs.setSelectedTab(minTabIdx);
            } else {
                CmsErrorDialog.showErrorDialog(e);
            }
            return;
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    void addDependency(String moduleName, String version) {
        try {
            this.m_dependencies.addComponent(new CmsRemovableFormRow<CmsModuleDependencyWidget>(CmsModuleDependencyWidget.create(new CmsModuleDependency(moduleName, new CmsModuleVersion(version))), ""));
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    void addExcludedResource(String moduleResource) {
        CmsModuleResourceSelectField resField = this.createModuleResourceField(moduleResource);
        if (resField != null) {
            this.m_excludedResourcesGroup.addRow((Component)resField);
        }
    }

    void addModuleResource(String moduleResource) {
        CmsModuleResourceSelectField resField = this.createModuleResourceField(moduleResource);
        if (resField != null) {
            this.m_moduleResourcesGroup.addRow((Component)resField);
        }
    }

    void addParameter(String parameter) {
        TextField textField = new TextField();
        if (parameter != null) {
            textField.setValue(parameter);
        }
        this.m_parameterGroup.addRow((Component)textField);
    }

    CmsModuleResourceSelectField createModuleResourceField(String moduleResource) {
        CmsModuleResourceSelectField resField = new CmsModuleResourceSelectField();
        CmsObject moduleCms = null;
        try {
            moduleCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            if (this.getSelectedSite() != null) {
                moduleCms.getRequestContext().setSiteRoot(this.getSelectedSite());
            }
            resField.setCmsObject(moduleCms);
            if (moduleResource != null) {
                resField.setValue(moduleResource);
            }
            return resField;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    <T extends Component> List<T> getFormRowChildren(AbstractComponentContainer container, final Class<T> cls) {
        final ArrayList result = Lists.newArrayList();
        CmsVaadinUtils.visitDescendants((Component)container, new Predicate<Component>(){

            public boolean apply(Component comp) {
                if (cls.isAssignableFrom(comp.getClass())) {
                    result.add((Component)cls.cast(comp));
                }
                return true;
            }
        });
        return result;
    }

    String getSelectedSite() {
        return (String)this.m_importSite.getValue();
    }

    int getTabIndex(Component component) {
        ArrayList tabs = Lists.newArrayList((Iterator)this.m_tabs.iterator());
        while (component != null) {
            int pos = tabs.indexOf(component);
            if (pos >= 0) {
                return pos;
            }
            component = component.getParent();
        }
        return -1;
    }

    private CmsModule createModuleFolders(CmsObject cms, CmsModule module) throws CmsException {
        CmsExportPoint exp;
        CmsResource resource;
        String path;
        String modulePath = "/system/modules/" + module.getName() + "/";
        List<CmsExportPoint> exportPoints = module.getExportPoints();
        List<String> resources = module.getResources();
        if (module.isCreateClassesFolder() || module.isCreateElementsFolder() || module.isCreateI18NFolder() || module.isCreateLibFolder() || module.isCreateResourcesFolder() || module.isCreateSchemasFolder() || module.isCreateTemplateFolder() || module.isCreateFormattersFolder()) {
            module.setCreateModuleFolder(true);
        }
        HashSet<String> exportPointPaths = new HashSet<String>();
        for (CmsExportPoint exportPoint : exportPoints) {
            exportPointPaths.add(exportPoint.getUri());
        }
        I_CmsResourceType folderType = OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName());
        I_CmsResourceType configType = OpenCms.getResourceManager().getResourceType("module_config");
        if (module.isCreateModuleFolder()) {
            CmsResource resource2 = cms.createResource(modulePath, folderType);
            CmsResource configResource = cms.createResource(modulePath + CONFIG_FILE, configType);
            try {
                cms.unlockResource(resource2);
                cms.unlockResource(configResource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
            resources.add(modulePath);
            module.setResources(resources);
        }
        if (module.isCreateTemplateFolder()) {
            path = modulePath + PATH_TEMPLATES;
            resource = cms.createResource(path, folderType);
            try {
                cms.unlockResource(resource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
        }
        if (module.isCreateI18NFolder()) {
            path = modulePath + PATH_i18n;
            resource = cms.createResource(path, folderType);
            CmsResource bundleResource = cms.createResource(path + module.getName() + ".messages_" + String.valueOf(CmsLocaleManager.getDefaultLocale()), OpenCms.getResourceManager().getResourceType("propertyvfsbundle"), null, null);
            cms.writeResource(bundleResource);
            try {
                cms.unlockResource(resource);
                cms.unlockResource(bundleResource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
        }
        if (module.isCreateElementsFolder()) {
            path = modulePath + PATH_ELEMENTS;
            resource = cms.createResource(path, folderType);
            try {
                cms.unlockResource(resource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
        }
        if (module.isCreateFormattersFolder()) {
            path = modulePath + PATH_FORMATTERS;
            resource = cms.createResource(path, folderType);
            try {
                cms.unlockResource(resource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
        }
        if (module.isCreateSchemasFolder()) {
            path = modulePath + PATH_SCHEMAS;
            resource = cms.createResource(path, folderType);
            try {
                cms.unlockResource(resource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
        }
        if (module.isCreateResourcesFolder()) {
            path = modulePath + PATH_RESOURCES;
            resource = cms.createResource(path, folderType);
            try {
                cms.unlockResource(resource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
        }
        if (module.isCreateLibFolder()) {
            path = modulePath + PATH_LIB;
            resource = cms.createResource(path, folderType);
            try {
                cms.unlockResource(resource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
            if (!exportPointPaths.contains(path)) {
                exp = new CmsExportPoint(path, "WEB-INF/lib/");
                exportPoints.add(exp);
            }
            module.setExportPoints(exportPoints);
        }
        if (module.isCreateClassesFolder()) {
            path = modulePath + PATH_CLASSES;
            resource = cms.createResource(path, folderType);
            try {
                cms.unlockResource(resource);
            }
            catch (CmsLockException locke) {
                LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
            }
            if (!exportPointPaths.contains(path)) {
                exp = new CmsExportPoint(path, "WEB-INF/classes/");
                exportPoints.add(exp);
                module.setExportPoints(exportPoints);
            }
            StringTokenizer tok = new StringTokenizer(this.m_module.getName(), ".");
            while (tok.hasMoreTokens()) {
                String folder = tok.nextToken();
                path = path + folder + "/";
                CmsResource resource2 = cms.createResource(path, folderType);
                try {
                    cms.unlockResource(resource2);
                }
                catch (CmsLockException locke) {
                    LOG.warn((Object)"Unbale to unlock resource", (Throwable)locke);
                }
            }
        }
        return module;
    }

    private void updateSiteInfo(final String siteRoot) {
        CmsSiteManagerImpl siteManager;
        CmsSite cmsSite;
        String top = "";
        String bottom = "";
        top = this.m_new ? CmsVaadinUtils.getMessageText("GUI_MODULES_RESINFO_NEW_MODULE_0", new Object[0]) : this.m_module.getName();
        bottom = siteRoot == null ? CmsVaadinUtils.getMessageText("GUI_MODULES_MODULE_SITE_NOT_SET_0", new Object[0]) : ((cmsSite = (siteManager = OpenCms.getSiteManager()).getSiteForSiteRoot(siteRoot)) != null ? CmsVaadinUtils.getMessageText("GUI_MODULES_MODULE_SITE_1", cmsSite.getTitle() + " (" + siteRoot + ")") : (siteRoot.equals("") || siteRoot.equals("/") ? CmsVaadinUtils.getMessageText("GUI_MODULES_MODULE_SITE_ROOT_FOLDER_0", new Object[0]) : CmsVaadinUtils.getMessageText("GUI_MODULES_MODULE_SITE_1", siteRoot)));
        this.m_info.get().getTopLine().setValue(top);
        this.m_info.get().getBottomLine().setValue(CmsJspElFunctions.stripHtml(bottom));
        for (Component component : Arrays.asList(this.m_moduleResources, this.m_excludedResources)) {
            CmsVaadinUtils.visitDescendants(component, new Predicate<Component>(){

                public boolean apply(Component comp) {
                    if (comp instanceof CmsModuleResourceSelectField) {
                        ((CmsModuleResourceSelectField)comp).updateSite(siteRoot);
                    }
                    return true;
                }
            });
        }
    }
}

