/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.google.common.collect.Lists;
import com.vaadin.ui.Button;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.apps.modules.A_CmsModuleImportForm;
import org.opencms.ui.apps.modules.CmsModuleApp;
import org.opencms.ui.apps.modules.CmsModuleImportFile;
import org.opencms.ui.components.CmsAutoItemCreatingComboBox;

public class CmsServerModuleImportForm
extends A_CmsModuleImportForm {
    private static final Log LOG = CmsLog.getLog(CmsServerModuleImportForm.class);
    private Button m_cancel;
    private ComboBox m_moduleSelect;
    private Button m_ok;
    private CmsAutoItemCreatingComboBox m_siteSelect;

    public CmsServerModuleImportForm(CmsModuleApp app, VerticalLayout start, VerticalLayout report, Runnable run) {
        super(app, start, report, run);
        IndexedContainer options = new IndexedContainer();
        options.addContainerProperty((Object)"label", String.class, (Object)"");
        this.m_moduleSelect.setContainerDataSource((Container)options);
        this.m_moduleSelect.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.m_moduleSelect.setItemCaptionPropertyId((Object)"label");
        this.m_moduleSelect.setNullSelectionAllowed(false);
        String moduleDir = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf("packages/modules");
        File moduleDirFile = new File(moduleDir);
        if (moduleDirFile.exists()) {
            ArrayList files = Lists.newArrayList((Object[])moduleDirFile.listFiles());
            Collections.sort(files);
            for (File file : files) {
                if (file.isDirectory()) continue;
                String path = file.getAbsolutePath();
                String name = file.getName();
                options.addItem((Object)path).getItemProperty((Object)"label").setValue((Object)name);
            }
        }
        this.m_moduleSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                String path = (String)event.getProperty().getValue();
                CmsServerModuleImportForm.this.m_importFile = new CmsModuleImportFile(path);
                CmsServerModuleImportForm.this.m_ok.setEnabled(false);
                CmsServerModuleImportForm.this.validateModuleFile();
            }
        });
    }

    @Override
    protected Button getCancelButton() {
        return this.m_cancel;
    }

    @Override
    protected Button getOkButton() {
        return this.m_ok;
    }

    @Override
    protected CmsAutoItemCreatingComboBox getSiteSelector() {
        return this.m_siteSelect;
    }
}

