/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.google.common.collect.Sets;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.modules.CmsModuleApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.CmsRichTextArea;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsModuleInfoDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 1L;
    private Label m_description;
    private Button m_edit;
    private VerticalLayout m_explorerTypes;
    private Panel m_explorerTypesPanel;
    private Button m_ok;
    private VerticalLayout m_resourceTypes;

    public CmsModuleInfoDialog(String moduleName, Consumer<String> editAction) {
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsResourceInfo resInfo = new CmsResourceInfo(module.getName(), module.getNiceName(), CmsModuleApp.Icons.RESINFO_ICON);
        this.displayResourceInfoDirectly(Arrays.asList(resInfo));
        this.m_description.setContentMode(ContentMode.HTML);
        this.m_description.setValue(CmsRichTextArea.cleanHtml(module.getDescription(), true));
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsVaadinUtils.getWindow((Component)CmsModuleInfoDialog.this).close();
            }
        });
        this.m_edit.addClickListener((Button.ClickListener & Serializable)event -> {
            CmsVaadinUtils.getWindow((Component)this).close();
            editAction.accept(moduleName);
        });
        this.initialize(module);
    }

    public void initialize(CmsModule module) {
        boolean empty = true;
        HashSet resTypeNames = Sets.newHashSet();
        for (I_CmsResourceType type : module.getResourceTypes()) {
            this.m_resourceTypes.addComponent((Component)this.formatResourceType(type));
            resTypeNames.add(type.getTypeName());
            empty = false;
        }
        if (empty) {
            this.m_resourceTypes.addComponent((Component)new Label(CmsVaadinUtils.getMessageText("GUI_MODULES_NO_RESOURCE_TYPES_0", new Object[0])));
        }
        empty = true;
        for (CmsExplorerTypeSettings expType : module.getExplorerTypes()) {
            if (resTypeNames.contains(expType.getName())) continue;
            this.m_explorerTypes.addComponent((Component)this.formatExplorerType(expType));
            empty = false;
        }
        if (empty) {
            this.m_explorerTypesPanel.setVisible(false);
        }
    }

    CmsResourceInfo formatExplorerType(CmsExplorerTypeSettings explorerType) {
        Resource icon = CmsResourceUtil.getBigIconResource(explorerType, null);
        String title = CmsVaadinUtils.getMessageText(explorerType.getKey(), new Object[0]);
        if (title.startsWith("???")) {
            title = explorerType.getName();
        }
        Object subtitle = explorerType.getName();
        if (explorerType.getReference() != null) {
            subtitle = (String)subtitle + " (" + explorerType.getReference() + ")";
        }
        CmsResourceInfo info = new CmsResourceInfo(title, (String)subtitle, icon);
        return info;
    }

    CmsResourceInfo formatResourceType(I_CmsResourceType type) {
        String subtitle;
        String title;
        Resource icon;
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
        if (settings != null) {
            icon = CmsResourceUtil.getBigIconResource(settings, null);
            title = CmsVaadinUtils.getMessageText(settings.getKey(), new Object[0]);
            if (title.startsWith("???")) {
                title = type.getTypeName();
            }
            subtitle = type.getTypeName() + " (ID: " + type.getTypeId() + (String)(settings.getReference() != null ? ", " + settings.getReference() : "") + ")";
        } else {
            icon = CmsResourceUtil.getBigIconResource(OpenCms.getWorkplaceManager().getExplorerTypeSetting("unknown"), null);
            title = type.getTypeName();
            subtitle = type.getTypeName() + " (ID: " + type.getTypeId() + ")";
        }
        CmsResourceInfo info = new CmsResourceInfo(title, subtitle, icon);
        return info;
    }
}

