/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.logfile;

import com.vaadin.server.FileDownloader;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.logfile.CmsLogFileApp;
import org.opencms.ui.apps.logfile.CmsLogFileOptionProvider;
import org.opencms.util.CmsRfsException;
import org.opencms.util.CmsRfsFileViewer;

public class CmsLogFileView
extends VerticalLayout {
    protected static String ATTR_FILE_VIEW_CHARSET = "log-file-char";
    protected static String ATTR_FILE_VIEW_PATH = "log-file";
    protected static String ATTR_FILE_VIEW_SIZE = "log-file-size";
    protected static int WINDOW_SIZE = 1000;
    private static final Log LOG = CmsLog.getLog(CmsLogFileView.class);
    private static final long serialVersionUID = -6323034856756469160L;
    protected boolean m_blockChangeEvent;
    protected FileDownloader m_fileDownloader;
    private Label m_fileContent;
    private ComboBox m_logfile;
    private CmsRfsFileViewer m_logView;
    private Panel m_panelComp;
    private CmsLogFileApp m_app;

    protected CmsLogFileView(CmsLogFileApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_app = app;
        this.m_logView = (CmsRfsFileViewer)OpenCms.getWorkplaceManager().getFileViewSettings().clone();
        this.m_logView.setAdditionalRoots(CmsLogFileOptionProvider.getAdditionalLogDirectories());
        this.m_logView.setWindowSize(WINDOW_SIZE);
        if (CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_SIZE) == null) {
            CmsVaadinUtils.getRequest().getSession().setAttribute(ATTR_FILE_VIEW_SIZE, (Object)String.valueOf(this.m_logView.getWindowSize()));
        }
        this.initLogFileCombo();
        this.m_logfile.setFilteringMode(FilteringMode.CONTAINS);
        this.m_logfile.setNullSelectionAllowed(false);
        this.m_logfile.setNewItemsAllowed(false);
        this.m_logfile.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1899253995224124911L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (CmsLogFileView.this.m_blockChangeEvent) {
                    return;
                }
                CmsVaadinUtils.getRequest().getSession().setAttribute(ATTR_FILE_VIEW_PATH, (Object)CmsLogFileView.this.getCurrentFile());
                CmsLogFileView.this.updateView();
            }
        });
        this.updateView();
        this.m_fileContent.addStyleName("v-scrollable");
        this.m_fileContent.addStyleName("o-report");
    }

    public void updateView() {
        if (CmsLogFileApp.LOG_FOLDER.isEmpty()) {
            return;
        }
        try {
            this.initLogFileCombo();
            this.m_logView.setWindowSize(this.getSize());
            this.m_logView.setFileEncoding(this.getChar());
            Object content = "<pre style='line-height:1.1;'>";
            content = (String)content + this.m_app.getLogFilePortion(this.m_logView, this.getCurrentFile());
            content = (String)content + "</pre>";
            this.m_fileContent.setValue((String)content);
            this.m_panelComp.setScrollTop(100000000);
        }
        catch (CmsRfsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected String getCurrentFile() {
        return (String)this.m_logfile.getValue();
    }

    private String getChar() {
        return ((Charset)CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_CHARSET)).name();
    }

    private int getSize() {
        return Integer.valueOf((String)CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_SIZE));
    }

    private void initLogFileCombo() {
        this.m_blockChangeEvent = true;
        this.m_logfile.removeAllItems();
        for (String path : this.m_app.getAvailableLogFilePaths()) {
            this.m_logfile.addItem((Object)path);
        }
        if (CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_CHARSET) == null) {
            Charset defaultCs = Charset.forName(new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
            CmsVaadinUtils.getRequest().getSession().setAttribute(ATTR_FILE_VIEW_CHARSET, (Object)defaultCs);
        }
        if (CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_PATH) != null) {
            this.m_logfile.select(CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_PATH));
        } else {
            this.selectLogFile();
        }
        this.m_blockChangeEvent = false;
    }

    private void selectLogFile() {
        this.m_logfile.select((Object)this.m_app.getDefaultLogFilePath(this.m_logView));
    }
}

