/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.logfile;

import com.google.common.collect.ComparisonChain;
import com.vaadin.data.HasValue;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsCRUDApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.logfile.CmsDefaultLogDownloadProvider;
import org.opencms.ui.apps.logfile.CmsLogChannelTable;
import org.opencms.ui.apps.logfile.CmsLogDownloadDialog;
import org.opencms.ui.apps.logfile.CmsLogFileOptionProvider;
import org.opencms.ui.apps.logfile.CmsLogFileView;
import org.opencms.ui.apps.logfile.CmsLogFileViewSettings;
import org.opencms.ui.apps.logfile.I_CmsLogDownloadProvider;
import org.opencms.ui.components.CmsAppViewLayout;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.util.CmsLog4jUtil;
import org.opencms.util.CmsRfsException;
import org.opencms.util.CmsRfsFileViewer;
import org.opencms.util.CmsStringUtil;

public class CmsLogFileApp
extends A_CmsWorkplaceApp
implements I_CmsCRUDApp<Logger> {
    protected static final String LOG_FOLDER = OpenCms.getSystemInfo().getLogFileRfsFolder() == null ? "" : OpenCms.getSystemInfo().getLogFileRfsFolder();
    protected static String PATH_LOGCHANNEL = "log-channel";
    private static Log LOG = CmsLog.getLog(CmsLogFileApp.class);
    private static final String OPENCMS_CLASS_PREFIX = "org.opencms";
    protected CmsLogFileView m_fileView;
    protected CmsLogChannelTable m_table;
    private TextField m_tableFilter;

    public static String getDirectLogFile(Logger logger) {
        for (LoggerConfig conf = logger.get(); conf != null; conf = conf.getParent()) {
            for (Appender appender : conf.getAppenders().values()) {
                if (!CmsLogFileApp.isFileAppender(appender)) continue;
                String path = CmsLogFileApp.getFileName(appender);
                String name = path.substring(path.lastIndexOf(File.separatorChar) + 1);
                return name;
            }
        }
        return null;
    }

    public static String getFileName(Appender app) {
        String result = null;
        try {
            Method getFileName = app.getClass().getDeclaredMethod("getFileName", null);
            result = (String)getFileName.invoke((Object)app, (Object[])null);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean isFileAppender(Appender appender) {
        boolean result = false;
        try {
            Method getFileNameMethod = appender.getClass().getDeclaredMethod("getFileName", null);
            result = getFileNameMethod != null;
        }
        catch (Exception e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean isloggingactivated(Logger logchannel) {
        boolean check = false;
        for (Appender appender : logchannel.getAppenders().values()) {
            check = appender.getName().equals(logchannel.getName());
        }
        return check;
    }

    public static void toggleOwnFile(Logger logchannel) {
        String filepath = "";
        Layout layout = null;
        if (CmsLogFileApp.isloggingactivated(logchannel)) {
            for (Appender appender : logchannel.getAppenders().values()) {
                logchannel.removeAppender(appender);
            }
            logchannel.setAdditive(true);
        } else {
            for (Appender appender : ((Logger)LogManager.getRootLogger()).getAppenders().values()) {
                if (!CmsLogFileApp.isFileAppender(appender)) continue;
                String fileName = CmsLogFileApp.getFileName(appender);
                filepath = fileName.substring(0, fileName.lastIndexOf(File.separatorChar));
                layout = appender.getLayout();
                break;
            }
            for (Appender appender : logchannel.getAppenders().values()) {
                if (!CmsLogFileApp.isFileAppender(appender)) continue;
                layout = appender.getLayout();
                break;
            }
            Object logfilename = "";
            String temp = logchannel.getName();
            logfilename = logchannel.getName().contains(OPENCMS_CLASS_PREFIX) ? ((temp = temp.replace(OPENCMS_CLASS_PREFIX, "")).length() >= 1 ? filepath + File.separator + "opencms-" + temp.substring(1).replace(".", "-") + ".log" : filepath + File.separator + "opencms" + temp.replace(".", "-") + ".log") : filepath + File.separator + "opencms-" + temp.replace(".", "-") + ".log";
            FileAppender fapp = ((FileAppender.Builder)FileAppender.newBuilder().withFileName((String)logfilename).withLayout(layout).withName(logchannel.getName())).build();
            logchannel.setAdditive(false);
            for (Appender appender : logchannel.getAppenders().values()) {
                logchannel.removeAppender(appender);
            }
            logchannel.addAppender((Appender)fapp);
        }
    }

    public void addMark(String logFile) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        ArrayList loggers = new ArrayList(context.getLoggers());
        loggers.sort((l1, l2) -> ComparisonChain.start().compare((Comparable)((Object)l1.getName()), (Comparable)((Object)l2.getName())).result());
        boolean found = false;
        block0: for (Logger logger : loggers) {
            for (Map.Entry entry : logger.getAppenders().entrySet()) {
                Appender appender = (Appender)entry.getValue();
                if (!logFile.equals(CmsLogFileApp.getFileName((Appender)entry.getValue()))) continue;
                String message = "---------- Mark created by '" + A_CmsUI.getCmsObject().getRequestContext().getCurrentUser().getName() + "' ----------";
                Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName(OPENCMS_CLASS_PREFIX).setIncludeLocation(true).setLoggerFqcn(CmsLogFileApp.class.getName()).setMessage((Message)new SimpleMessage(message)).build();
                appender.append((LogEvent)event);
                found = true;
                break block0;
            }
        }
        if (!found) {
            Notification.show((String)CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGFILE_NOT_ACTIVE_0", new Object[0]));
        }
    }

    @Override
    public void createElement(Logger element) {
    }

    @Override
    public void defaultAction(String elementId) {
    }

    @Override
    public void deleteElements(List<String> elementId) {
    }

    @Override
    public List<Logger> getAllElements() {
        return CmsLog4jUtil.getAllLoggers();
    }

    public Set<String> getAvailableLogFilePaths() {
        TreeSet<File> files = CmsLogFileOptionProvider.getLogFiles();
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        for (File f : files) {
            if (f.getAbsolutePath().endsWith(".zip") || f.getAbsolutePath().endsWith(".gz")) continue;
            res.add(f.getAbsolutePath());
        }
        return res;
    }

    public String getDefaultLogFilePath(CmsRfsFileViewer logView) {
        List<Logger> allLogger = CmsLog4jUtil.getAllLoggers();
        ArrayList<Appender> allAppender = new ArrayList<Appender>();
        allLogger.add(0, (Logger)LogManager.getRootLogger());
        for (Logger logger : allLogger) {
            for (Appender appender : logger.getAppenders().values()) {
                if (!CmsLogFileApp.isFileAppender(appender) || allAppender.contains(appender)) continue;
                allAppender.add(appender);
            }
        }
        for (Appender app : allAppender) {
            String fileName = CmsLogFileApp.getFileName(app);
            if (fileName == null || !fileName.equals(logView.getFilePath())) continue;
            return fileName;
        }
        if (!allAppender.isEmpty()) {
            Appender app = (Appender)allAppender.get(0);
            String fileName = CmsLogFileApp.getFileName(app);
            return fileName;
        }
        return null;
    }

    @Override
    public Logger getElement(String elementId) {
        return null;
    }

    public String getLogFile(Logger logger) {
        return CmsLogFileApp.getDirectLogFile(logger);
    }

    public String getLogFilePortion(CmsRfsFileViewer logView, String currentFile) throws CmsRfsException, CmsRuntimeException {
        logView.setFilePath(currentFile);
        return logView.readFilePortion();
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        super.initUI(context);
    }

    public void toggleOwnFileForLogger(Logger logchannel) {
        CmsLogFileApp.toggleOwnFile(logchannel);
    }

    public void updateTable() {
        if (this.m_table != null) {
            this.m_table = new CmsLogChannelTable(this);
            this.m_table.setSizeFull();
            this.m_rootLayout.setMainContent((Component)this.m_table);
            this.m_table.filterTable(this.m_tableFilter.getValue());
        }
    }

    @Override
    public void writeElement(Logger logger) {
        LoggerConfig loggerConfig;
        LoggerContext context = logger.getContext();
        Configuration config = context.getConfiguration();
        LoggerConfig specificConfig = loggerConfig = config.getLoggerConfig(logger.getName());
        if (!loggerConfig.getName().equals(logger.getName())) {
            specificConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            specificConfig.setParent(loggerConfig);
            config.addLogger(logger.getName(), specificConfig);
        }
        specificConfig.setLevel(logger.getLevel());
        context.updateLoggers();
    }

    protected void addChannelButton() {
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.LOG, CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGSETTINGS_TOOL_NAME_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLogFileApp.this.openSubView(PATH_LOGCHANNEL, true);
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    protected void addDownloadButton(final CmsLogFileView view) {
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.DOWNLOAD, CmsVaadinUtils.getMessageText("GUI_LOGFILE_DOWNLOAD_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_LOGFILE_DOWNLOAD_0", new Object[0]));
                window.setContent((Component)new CmsLogDownloadDialog(window, view.getCurrentFile(), CmsLogFileApp.this.getLogDownloadProvider()));
                A_CmsUI.get().addWindow(window);
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    protected void addMarkButton() {
        Button button = CmsToolBar.createButton((Resource)FontAwesome.PLUS, CmsVaadinUtils.getMessageText("GUI_LOGFILE_ADD_MARK_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsLogFileApp.this.m_fileView != null && CmsLogFileApp.this.m_fileView.getCurrentFile() != null) {
                    CmsLogFileApp.this.addMark(CmsLogFileApp.this.m_fileView.getCurrentFile());
                    CmsLogFileApp.this.m_fileView.updateView();
                }
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    protected void addPublishButton() {
        this.m_uiContext.addToolbarButton((Component)CmsAppViewLayout.createPublishButton(ids -> {}));
    }

    protected void addRefreshButton() {
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.RESET, CmsVaadinUtils.getMessageText("GUI_LOGFILE_REFRESH_FILEVIEW_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLog.INIT.info((Object)("Logfile was reloaded by user " + A_CmsUI.getCmsObject().getRequestContext().getCurrentUser().getName()));
                CmsLogFileApp.this.m_fileView.updateView();
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    protected void addSettingsButton() {
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.SETTINGS, CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGSETTINGS_TOOL_NAME_SHORT_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGVIEW_SETTINGS_SHORT_0", new Object[0]));
                window.setContent((Component)new CmsLogFileViewSettings(window));
                window.addCloseListener(new Window.CloseListener(){
                    private static final long serialVersionUID = -7058276628732771106L;

                    public void windowClose(Window.CloseEvent e) {
                        CmsLogFileApp.this.m_fileView.updateView();
                    }
                });
                A_CmsUI.get().addWindow(window);
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    protected void filterTable(String filter) {
        this.m_table.filterTable(filter);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_LOGFILE_VIEW_TOOL_NAME_0", new Object[0]));
            return crumbs;
        }
        if (state.startsWith(PATH_LOGCHANNEL)) {
            crumbs.put("logfile-app", CmsVaadinUtils.getMessageText("GUI_LOGFILE_VIEW_TOOL_NAME_0", new Object[0]));
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGSETTINGS_TOOL_NAME_0", new Object[0]));
            return crumbs;
        }
        return new LinkedHashMap<String, String>();
    }

    @Override
    protected Component getComponentForState(String state) {
        if (this.m_tableFilter != null) {
            this.m_infoLayout.removeComponent((Component)this.m_tableFilter);
            this.m_tableFilter = null;
        }
        if (!state.startsWith(PATH_LOGCHANNEL)) {
            this.m_rootLayout.setMainHeightFull(true);
            this.m_fileView = new CmsLogFileView(this);
            this.addPublishButton();
            this.addDownloadButton(this.m_fileView);
            this.addSettingsButton();
            this.addChannelButton();
            this.addMarkButton();
            this.addRefreshButton();
            this.m_table = null;
            return this.m_fileView;
        }
        this.m_uiContext.clearToolbarButtons();
        this.m_rootLayout.setMainHeightFull(true);
        this.m_table = new CmsLogChannelTable(this);
        this.m_tableFilter = new TextField();
        this.m_tableFilter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_tableFilter.setPlaceholder(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_tableFilter.addStyleName("inline-icon");
        this.m_tableFilter.setWidth("200px");
        this.m_tableFilter.setValueChangeMode(ValueChangeMode.TIMEOUT);
        this.m_tableFilter.setValueChangeTimeout(400);
        this.m_tableFilter.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){
            private static final long serialVersionUID = 1L;

            public void valueChange(HasValue.ValueChangeEvent<String> event) {
                CmsLogFileApp.this.filterTable((String)event.getValue());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_tableFilter);
        return this.m_table;
    }

    protected I_CmsLogDownloadProvider getLogDownloadProvider() {
        return new CmsDefaultLogDownloadProvider();
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }
}

