/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager.sqlconsole;

import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.Table;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.dbmanager.sqlconsole.CmsSqlConsoleResults;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsSqlConsoleResultsForm
extends CmsBasicDialog {
    private static final long serialVersionUID = 1L;
    protected Button m_csv;
    protected Button m_ok;
    protected VerticalLayout m_tableContainer;
    private Label m_reportOutput;

    public CmsSqlConsoleResultsForm(CmsSqlConsoleResults results, String reportOutput) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_ok.addClickListener((Button.ClickListener & Serializable)evt -> CmsVaadinUtils.getWindow((Component)this).close());
        if (results != null) {
            Table table = this.buildTable(results);
            this.m_tableContainer.addComponent((Component)table);
            StreamResource res = new StreamResource((StreamResource.StreamSource)new CsvSource(results), "data.csv");
            res.setMIMEType("text/plain; charset=utf-8");
            FileDownloader downloader = new FileDownloader((Resource)res);
            downloader.extend((AbstractComponent)this.m_csv);
        } else {
            this.m_csv.setVisible(false);
        }
        this.m_reportOutput.setContentMode(ContentMode.PREFORMATTED);
        this.m_reportOutput.setValue(reportOutput);
    }

    private Table buildTable(CmsSqlConsoleResults results) {
        IndexedContainer container = new IndexedContainer();
        int numCols = results.getColumns().size();
        for (int c = 0; c < numCols; ++c) {
            container.addContainerProperty((Object)c, results.getColumnType(c), null);
        }
        int r = 0;
        for (List<Object> row : results.getData()) {
            Item item = container.addItem((Object)r);
            for (int c = 0; c < numCols; ++c) {
                item.getItemProperty((Object)c).setValue(row.get(c));
            }
            ++r;
        }
        Table table = new Table();
        table.setContainerDataSource((Container)container);
        for (int c = 0; c < numCols; ++c) {
            String col = results.getColumns().get(c);
            table.setColumnHeader((Object)c, col);
        }
        table.setWidth("100%");
        table.setHeight("100%");
        table.setColumnCollapsingAllowed(true);
        return table;
    }

    public class CsvSource
    implements StreamResource.StreamSource {
        private static final long serialVersionUID = 1L;
        private CmsSqlConsoleResults m_results;

        public CsvSource(CmsSqlConsoleResults results) {
            this.m_results = results;
        }

        public InputStream getStream() {
            try {
                return new ByteArrayInputStream(this.m_results.getCsv().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    }
}

