/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager.sqlconsole;

import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import org.opencms.db.CmsDbPoolV11;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsStringBufferReport;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.dbmanager.sqlconsole.CmsSqlConsoleExecutor;
import org.opencms.ui.apps.dbmanager.sqlconsole.CmsSqlConsoleResults;
import org.opencms.ui.apps.dbmanager.sqlconsole.CmsSqlConsoleResultsForm;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;

public class CmsSqlConsoleLayout
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected Button m_ok;
    protected ComboBox<String> m_pool;
    protected TextArea m_script;
    private CmsSqlConsoleExecutor m_console;

    public CmsSqlConsoleLayout(CmsSqlConsoleExecutor console) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_console = console;
        this.m_ok.addClickListener((Button.ClickListener & Serializable)evt -> this.runQuery());
        this.m_pool.setItems(OpenCms.getDbPoolNames());
        this.m_pool.setValue((Object)CmsDbPoolV11.getDefaultDbPoolName());
        this.m_pool.setEmptySelectionAllowed(false);
    }

    protected void runQuery() {
        String pool = (String)this.m_pool.getValue();
        String stmt = this.m_script.getValue();
        if (stmt.trim().isEmpty()) {
            return;
        }
        CmsStringBufferReport report = new CmsStringBufferReport(Locale.ENGLISH);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        CmsSqlConsoleResults result = this.m_console.execute(stmt, pool, report, errors);
        if (errors.size() > 0) {
            CmsErrorDialog.showErrorDialog(report.toString() + ((Throwable)errors.get(0)).getMessage(), (Throwable)errors.get(0));
        } else {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_SQLCONSOLE_QUERY_RESULTS_0", new Object[0]));
            window.setContent((Component)new CmsSqlConsoleResultsForm(result, report.toString()));
            A_CmsUI.get().addWindow(window);
            window.center();
        }
    }
}

