/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager.sqlconsole;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.db.generic.CmsSqlManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsSecurityException;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.dbmanager.sqlconsole.CmsSqlConsoleResults;

public final class CmsSqlConsoleExecutor {
    private static final Log LOG = CmsLog.getLog(CmsSqlConsoleExecutor.class);
    private CmsSqlManager m_sqlManager = new CmsSqlManager();

    public CmsSqlConsoleExecutor() {
        this.m_sqlManager.init(3, "default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsSqlConsoleResults execute(String sql, String pool, I_CmsReport report, List<Throwable> errors) {
        block14: {
            CmsMessageContainer message;
            try {
                List<String> sentences;
                message = Messages.get().container("RPT_SQLCONSOLE_BEGIN_0");
                report.println(message, 2);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)message.key());
                }
                if ((sentences = this.normalize(sql)).size() < 1) {
                    this.write(report, Messages.get().getBundle(report.getLocale()).key("ERR_SQLCONSOLE_NOTHING_TO_EXECUTE_0"));
                    break block14;
                }
                for (String sentence : sentences) {
                    if (!this.checkPermissions(sentence)) {
                        this.writeError(report, new CmsSecurityException(Messages.get().container("ERR_SQLCONSOLE_NO_PERMISSIONS_EXEC_SENTENCE_1", sentence)));
                        continue;
                    }
                    if (!sentence.toUpperCase().startsWith("SELECT") && !sentence.toUpperCase().startsWith("SHOW")) {
                        int res = this.executeUpdate(sentence, pool);
                        message = Messages.get().container("RPT_SQLCONSOLE_ROWS_AFFECTED_1", res);
                        report.println(message);
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)message);
                        }
                        continue;
                    }
                    CmsSqlConsoleResults res = this.executeQuery(sentence, pool);
                    message = Messages.get().container("RPT_SQLCONSOLE_NUM_ROWS_RETRIEVED_1", res.getData().size());
                    report.println(message);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)message);
                    }
                    CmsSqlConsoleResults cmsSqlConsoleResults = res;
                    return cmsSqlConsoleResults;
                }
            }
            catch (Throwable e) {
                errors.add(e);
            }
            finally {
                message = Messages.get().container("RPT_SQLCONSOLE_END_0");
                report.println(message, 2);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)message.key());
                }
            }
        }
        return null;
    }

    private boolean checkPermissions(String sentence) {
        return !(sentence = sentence.toUpperCase()).contains("DELETE FROM") || sentence.contains("WHERE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsSqlConsoleResults executeQuery(String sentence, String poolName) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        CmsSqlManager sqlManager = this.m_sqlManager;
        try {
            conn = sqlManager.getConnection(poolName);
            stmt = sqlManager.getPreparedStatementForSql(conn, sentence);
            res = stmt.executeQuery();
            ResultSetMetaData metadata = res.getMetaData();
            ArrayList<String> heading = new ArrayList<String>();
            for (int i = 0; i < metadata.getColumnCount(); ++i) {
                heading.add(metadata.getColumnName(i + 1));
            }
            ArrayList<List<Object>> data = new ArrayList<List<Object>>();
            while (res.next()) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 0; i < metadata.getColumnCount(); ++i) {
                    Object value = res.getObject(i + 1);
                    if (value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                        row.add(value);
                        continue;
                    }
                    if (value == null) {
                        row.add(null);
                        continue;
                    }
                    row.add(String.valueOf(value));
                }
                data.add(row);
            }
            CmsSqlConsoleResults cmsSqlConsoleResults = new CmsSqlConsoleResults(heading, data);
            sqlManager.closeAll(null, conn, stmt, res);
            return cmsSqlConsoleResults;
        }
        catch (Throwable throwable) {
            sqlManager.closeAll(null, conn, stmt, res);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(String sentence, String poolName) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        int ret = 0;
        CmsSqlManager sqlManager = this.m_sqlManager;
        try {
            conn = sqlManager.getConnection(poolName);
            stmt = sqlManager.getPreparedStatementForSql(conn, sentence);
            ret = stmt.executeUpdate();
            sqlManager.closeAll(null, conn, stmt, null);
        }
        catch (Throwable throwable) {
            sqlManager.closeAll(null, conn, stmt, null);
            throw throwable;
        }
        return ret;
    }

    private List<String> normalize(String sql) {
        String normSql = sql.replaceAll(";", "; ");
        normSql = normSql.replaceAll("\\s+", " ");
        return Arrays.stream(normSql.split(";")).map(s -> s.trim()).collect(Collectors.toList());
    }

    private void write(I_CmsReport report, String string) {
        report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", string.replaceAll("'", "\\\\'")));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("SQLConsole:" + string));
        }
    }

    private void writeError(I_CmsReport report, Throwable e) {
        report.println(e);
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"SQLConsole", e);
        }
    }
}

