/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import java.util.List;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleImportExportHandler;

public class CmsImportFile {
    private String m_path;
    private CmsModule m_module;

    public CmsImportFile(String path) {
        this.m_path = path;
    }

    public CmsModule getModule() {
        return this.m_module;
    }

    public String getPath() {
        return this.m_path;
    }

    public void loadAndValidate() throws CmsConfigurationException {
        CmsModule module;
        this.m_module = module = CmsModuleImportExportHandler.readModuleFromImport(this.m_path);
        List<CmsModuleDependency> dependencies = OpenCms.getModuleManager().checkDependencies(module, 1);
        if (!dependencies.isEmpty()) {
            StringBuffer dep = new StringBuffer(32);
            for (int i = 0; i < dependencies.size(); ++i) {
                CmsModuleDependency dependency = dependencies.get(i);
                dep.append("\n - ");
                dep.append(dependency.getName());
                dep.append(" (Version: ");
                dep.append(dependency.getVersion());
                dep.append(")");
            }
        }
    }
}

