/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import java.util.LinkedHashMap;
import java.util.List;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.dbmanager.CmsAddPropertyDefinitionDialog;
import org.opencms.ui.apps.dbmanager.CmsPropertyTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsToolBar;

public class CmsDbPropertiesApp
extends A_CmsWorkplaceApp {
    protected CmsPropertyTable m_table;

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        crumbs.put("", CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_TOOL_NAME_0", new Object[0]));
        return crumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        this.m_rootLayout.setMainHeightFull(true);
        this.m_table = new CmsPropertyTable();
        TextField filter = new TextField();
        filter.setIcon((Resource)FontOpenCms.FILTER);
        filter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        filter.addStyleName("inline-icon");
        filter.setWidth("200px");
        filter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsDbPropertiesApp.this.m_table.filterTable(event.getText());
            }
        });
        this.m_infoLayout.addComponent((Component)filter);
        this.m_table.setSizeFull();
        this.addNewPropertyButton(this.m_table);
        return this.m_table;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    private void addNewPropertyButton(final CmsPropertyTable table) {
        Button add = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_NEW_CAPTION_0", new Object[0]));
        add.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Window window = CmsBasicDialog.prepareWindow();
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_NEW_CAPTION_0", new Object[0]));
                window.setContent((Component)new CmsAddPropertyDefinitionDialog(window, table));
                A_CmsUI.get().addWindow(window);
            }
        });
        this.m_uiContext.addToolbarButton((Component)add);
    }
}

