/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.ui.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.A_CmsAttributeAwareApp;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.dbmanager.CmsResourceTypeStatsView;
import org.opencms.util.CmsStringUtil;

public class CmsDbManager
extends A_CmsAttributeAwareApp {
    private static final String FILE_MANIFEST = "manifest.xml";
    private static final String FOLDER_MODULES = "modules";

    protected static List<String> getFileListFromServer(boolean includeFolders) {
        ArrayList<String> result = new ArrayList<String>();
        String exportpath = OpenCms.getSystemInfo().getPackagesRfsPath();
        File folder = new File(exportpath);
        String[] files = folder.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File diskFile = new File(exportpath, files[i]);
                if (diskFile.isFile() && diskFile.getName().endsWith(".zip")) {
                    result.add(diskFile.getName());
                    continue;
                }
                if (!diskFile.isDirectory() || !includeFolders || diskFile.getName().equalsIgnoreCase(FOLDER_MODULES) || !new File(String.valueOf(diskFile) + File.separator + FILE_MANIFEST).exists()) continue;
                result.add(diskFile.getName());
            }
        }
        return result;
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_STATS_TITLE_0", new Object[0]));
            return crumbs;
        }
        return new LinkedHashMap<String, String>();
    }

    @Override
    protected Component getComponentForState(String state) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            return new CmsResourceTypeStatsView();
        }
        return null;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }
}

