/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.vaadin.server.Resource;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.Table;
import java.util.List;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.cacheadmin.CmsImageCacheTable;
import org.opencms.ui.apps.cacheadmin.CmsVariationBean;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsImageVariationsTable
extends Table {
    private static final long serialVersionUID = 4050556105747017491L;
    protected static final String PROP_ICON = "icon";
    protected static final String PROP_NAME = "name";
    protected static final String PROP_DIMENSION = "dimension";
    protected static final String PROP_LENGTH = "length";
    private IndexedContainer m_container = new IndexedContainer();

    public CmsImageVariationsTable(String resource) {
        this.m_container.addContainerProperty((Object)PROP_ICON, Resource.class, (Object)CmsResourceUtil.getBigIconResource(OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypeImage.getStaticTypeName()), null));
        this.m_container.addContainerProperty((Object)PROP_NAME, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_DIMENSION, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_LENGTH, String.class, (Object)"");
        List<CmsVariationBean> variations = CmsImageCacheTable.HELPER.getVariations(resource);
        for (CmsVariationBean var : variations) {
            Item item = this.m_container.addItem((Object)var);
            item.getItemProperty((Object)PROP_NAME).setValue((Object)var.getName());
            item.getItemProperty((Object)PROP_DIMENSION).setValue((Object)var.getDimensions());
            item.getItemProperty((Object)PROP_LENGTH).setValue((Object)var.getLength());
        }
        this.setContainerDataSource((Container)this.m_container);
        this.setColumnHeader(null, "");
        this.setColumnHeader(PROP_DIMENSION, CmsVaadinUtils.getMessageText("GUI_CACHE_IMAGECACHE_LIST_COLS_SIZE_0", new Object[0]));
        this.setColumnHeader(PROP_NAME, CmsVaadinUtils.getMessageText("GUI_CACHE_IMAGECACHE_LIST_COLS_RESOURCE_0", new Object[0]));
        this.setColumnHeader(PROP_LENGTH, CmsVaadinUtils.getMessageText("GUI_CACHE_IMAGECACHE_LIST_COLS_LENGTH_0", new Object[0]));
        this.setItemIconPropertyId(PROP_ICON);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setWidth("100%");
        this.setHeight("500px");
        this.setVisibleColumns(new Object[]{PROP_NAME, PROP_DIMENSION, PROP_LENGTH});
    }
}

