/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ui.apps.CmsAppCategoryNode;
import org.opencms.ui.apps.I_CmsAppCategory;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.util.CmsStringUtil;

public class CmsAppHierarchyBuilder {
    private static final Log LOG = CmsLog.getLog(CmsAppHierarchyBuilder.class);
    private List<I_CmsAppCategory> m_appCategoryList = Lists.newArrayList();
    private List<I_CmsWorkplaceAppConfiguration> m_appConfigs = Lists.newArrayList();
    private Map<String, CmsAppCategoryNode> m_nodes = Maps.newHashMap();
    private CmsAppCategoryNode m_rootNode = new CmsAppCategoryNode();

    public void addAppConfiguration(I_CmsWorkplaceAppConfiguration appConfig) {
        this.m_appConfigs.add(appConfig);
    }

    public void addCategory(I_CmsAppCategory category) {
        this.m_appCategoryList.add(category);
    }

    public CmsAppCategoryNode buildHierarchy() {
        Collections.sort(this.m_appCategoryList, new Comparator<I_CmsAppCategory>(){

            @Override
            public int compare(I_CmsAppCategory cat1, I_CmsAppCategory cat2) {
                return ComparisonChain.start().compare(cat1.getPriority(), cat2.getPriority()).result();
            }
        });
        this.m_rootNode = new CmsAppCategoryNode();
        this.m_nodes.clear();
        this.m_nodes.put(null, this.m_rootNode);
        for (I_CmsAppCategory category : this.m_appCategoryList) {
            this.m_nodes.put(category.getId(), new CmsAppCategoryNode(category));
        }
        for (CmsAppCategoryNode node : this.m_nodes.values()) {
            if (node == this.m_rootNode) continue;
            this.addNodeToItsParent(node);
        }
        for (I_CmsWorkplaceAppConfiguration appConfig : this.m_appConfigs) {
            this.addAppConfigToCategory(appConfig);
        }
        Set<String> usedNodes = this.findReachableNodes(this.m_rootNode, new HashSet<String>());
        if (usedNodes.size() < this.m_nodes.size()) {
            LOG.warn((Object)("Unused app categories: " + String.valueOf(Sets.difference(this.m_nodes.keySet(), usedNodes))));
        }
        HashSet unusedApps = Sets.newHashSet();
        for (I_CmsWorkplaceAppConfiguration appConfig : this.m_appConfigs) {
            if (usedNodes.contains(appConfig.getAppCategory())) continue;
            unusedApps.add(appConfig.getId());
        }
        if (unusedApps.size() > 0) {
            LOG.warn((Object)("Unused apps: " + String.valueOf(unusedApps)));
        }
        this.m_rootNode.removeApplessSubtrees();
        this.m_rootNode.sortRecursively();
        return this.m_rootNode;
    }

    public CmsAppCategoryNode getRootNode() {
        return this.m_rootNode;
    }

    protected void addAppConfigToCategory(I_CmsWorkplaceAppConfiguration appConfig) {
        CmsAppCategoryNode node = this.m_nodes.get(appConfig.getAppCategory());
        if (node == null) {
            LOG.info((Object)("Missing parent [" + appConfig.getAppCategory() + "] for " + appConfig.getId() + " / " + appConfig.getClass().getName()));
        } else {
            node.addAppConfiguration(appConfig);
        }
    }

    protected void addNodeToItsParent(CmsAppCategoryNode node) {
        CmsAppCategoryNode parentNode;
        String parentId = node.getCategory().getParentId();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(parentId)) {
            parentId = null;
        }
        if ((parentNode = this.m_nodes.get(parentId)) == null) {
            LOG.error((Object)("Missing parent [" + node.getCategory().getParentId() + "] for [" + node.getCategory().getId() + "]"));
        } else {
            parentNode.addChild(node);
        }
    }

    private Set<String> findReachableNodes(CmsAppCategoryNode rootNode, HashSet<String> reachableNodes) {
        reachableNodes.add(rootNode.getCategory().getId());
        for (CmsAppCategoryNode child : rootNode.getChildren()) {
            this.findReachableNodes(child, reachableNodes);
        }
        return reachableNodes;
    }
}

