/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.google.common.collect.Lists;
import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.apps.CmsAppHierarchyBuilder;
import org.opencms.ui.apps.CmsAppHierarchyPanel;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsDefaultAppButtonProvider;
import org.opencms.ui.apps.I_CmsAppCategory;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsCachableApp;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;

public class CmsAppHierachy
implements I_CmsWorkplaceApp,
I_CmsCachableApp {
    private static final long serialVersionUID = -2767203655877536034L;

    @Override
    public void initUI(I_CmsAppUIContext context) {
        CmsObject cms = A_CmsUI.getCmsObject();
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        ArrayList visibleApps = Lists.newArrayList();
        for (I_CmsWorkplaceAppConfiguration i_CmsWorkplaceAppConfiguration : OpenCms.getWorkplaceAppManager().getWorkplaceApps()) {
            CmsAppVisibilityStatus status = i_CmsWorkplaceAppConfiguration.getVisibility(cms);
            if (!status.isVisible()) continue;
            visibleApps.add(i_CmsWorkplaceAppConfiguration);
        }
        CmsAppHierarchyBuilder hierarchyBuilder = new CmsAppHierarchyBuilder();
        for (I_CmsWorkplaceAppConfiguration app : visibleApps) {
            hierarchyBuilder.addAppConfiguration(app);
        }
        for (I_CmsAppCategory category : OpenCms.getWorkplaceAppManager().getCategories()) {
            hierarchyBuilder.addCategory(category);
        }
        CmsAppHierarchyPanel cmsAppHierarchyPanel = new CmsAppHierarchyPanel(new CmsDefaultAppButtonProvider());
        cmsAppHierarchyPanel.fill(hierarchyBuilder.buildHierarchy(), locale);
        context.setAppContent((Component)cmsAppHierarchyPanel);
        context.showInfoArea(false);
        context.addPublishButton(new I_CmsUpdateListener<String>(){

            @Override
            public void onUpdate(List<String> updatedItems) {
            }
        });
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public void onRestoreFromCache() {
    }

    @Override
    public void onStateChange(String state) {
    }
}

