/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.components.CmsBreadCrumb;
import org.opencms.ui.components.CmsToolLayout;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsWorkplaceApp
implements I_CmsWorkplaceApp {
    public static final String PARAM_ASSIGN = "::";
    public static final String PARAM_SEPARATOR = "!!";
    protected HorizontalLayout m_infoLayout;
    protected CmsToolLayout m_rootLayout = new CmsToolLayout();
    protected I_CmsAppUIContext m_uiContext;
    private CmsBreadCrumb m_breadCrumb;

    protected A_CmsWorkplaceApp() {
        this.m_rootLayout.setSizeFull();
    }

    public static String addParamToState(String state, String paramName, String value) {
        return state + PARAM_SEPARATOR + paramName + PARAM_ASSIGN + CmsEncoder.encode(value, "UTF-8");
    }

    public static String getParamFromState(String state, String paramName) {
        String prefix = PARAM_SEPARATOR + paramName + PARAM_ASSIGN;
        if (state.contains(prefix)) {
            String result = state.substring(state.indexOf(prefix) + prefix.length());
            if (result.contains(PARAM_SEPARATOR)) {
                result = result.substring(0, result.indexOf(PARAM_SEPARATOR));
            }
            return CmsEncoder.decode(result, "UTF-8");
        }
        return null;
    }

    public static Map<String, String> getParamsFromState(String state) {
        HashMap<String, String> result = new HashMap<String, String>();
        int separatorIndex = state.indexOf(PARAM_SEPARATOR);
        while (separatorIndex >= 0) {
            int assignIndex = (state = state.substring(separatorIndex + 2)).indexOf(PARAM_ASSIGN);
            if (assignIndex > 0) {
                String key = state.substring(0, assignIndex);
                state = state.substring(assignIndex + 2);
                separatorIndex = state.indexOf(PARAM_SEPARATOR);
                String value = null;
                if (separatorIndex < 0) {
                    value = state;
                } else if (separatorIndex > 0) {
                    value = state.substring(0, separatorIndex);
                }
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) continue;
                result.put(key, CmsEncoder.decode(value, "UTF-8"));
                continue;
            }
            separatorIndex = -1;
        }
        return result;
    }

    public static String removeParamsFromState(String state) {
        return state.split(PARAM_SEPARATOR)[0];
    }

    public CmsObject getOfflineCmsObject(CmsObject cms) {
        CmsObject res = null;
        try {
            if (!cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                return OpenCms.initCmsObject(cms);
            }
            res = OpenCms.initCmsObject(cms);
            List<CmsProject> projects = OpenCms.getOrgUnitManager().getAllAccessibleProjects(res, "/", true);
            Iterator<CmsProject> projIterator = projects.iterator();
            boolean offFound = false;
            while (projIterator.hasNext() & !offFound) {
                CmsProject offP = projIterator.next();
                if (offP.isOnlineProject()) continue;
                res.getRequestContext().setCurrentProject(offP);
                offFound = true;
            }
        }
        catch (CmsException e) {
            return cms;
        }
        return res;
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        this.m_uiContext = context;
        this.m_uiContext.showInfoArea(true);
        this.m_breadCrumb = new CmsBreadCrumb();
        this.m_infoLayout = new HorizontalLayout();
        this.m_infoLayout.setSizeFull();
        this.m_infoLayout.setSpacing(true);
        this.m_infoLayout.setMargin(true);
        this.m_uiContext.setAppInfo((Component)this.m_infoLayout);
        this.m_infoLayout.addComponent((Component)this.m_breadCrumb);
        this.m_infoLayout.setExpandRatio((Component)this.m_breadCrumb, 2.0f);
        this.m_uiContext.setAppContent((Component)this.m_rootLayout);
    }

    @Override
    public void onStateChange(String state) {
        this.openSubView(state, false);
    }

    public void openSubView(String state, boolean updateState) {
        Component comp;
        if (updateState) {
            CmsAppWorkplaceUi.get().changeCurrentAppState(state);
        }
        if ((comp = this.getComponentForState(state)) != null) {
            comp.setSizeFull();
            this.m_rootLayout.setMainContent(comp);
        } else {
            this.m_rootLayout.setMainContent((Component)new Label("Malformed path, tool not available for path: " + state));
        }
        this.updateSubNav(this.getSubNavEntries(state));
        this.updateBreadCrumb(this.getBreadCrumbForState(state));
    }

    protected void addSubNavEntry(final NavEntry navEntry) {
        Button button = this.m_rootLayout.addSubNavEntry(navEntry);
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                A_CmsWorkplaceApp.this.openSubView(navEntry.getTargetState(), true);
            }
        });
    }

    protected abstract LinkedHashMap<String, String> getBreadCrumbForState(String var1);

    protected abstract Component getComponentForState(String var1);

    protected String getLastPathLevel(String path) {
        if ((path = path.trim()).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.contains("/")) {
            path = path.substring(path.lastIndexOf("/"));
        }
        return path;
    }

    protected abstract List<NavEntry> getSubNavEntries(String var1);

    protected void setBreadCrumbEntries(LinkedHashMap<String, String> entries) {
        this.m_breadCrumb.setEntries(entries);
    }

    protected void updateBreadCrumb(Map<String, String> breadCrumbEntries) {
        LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
        I_CmsWorkplaceAppConfiguration launchpadConfig = OpenCms.getWorkplaceAppManager().getAppConfiguration("launchpad");
        if (launchpadConfig.getVisibility(A_CmsUI.getCmsObject()).isActive()) {
            entries.put("launchpad", launchpadConfig.getName(UI.getCurrent().getLocale()));
        }
        if (breadCrumbEntries != null && !breadCrumbEntries.isEmpty()) {
            entries.putAll(breadCrumbEntries);
        } else {
            entries.put("", OpenCms.getWorkplaceAppManager().getAppConfiguration(this.m_uiContext.getAppId()).getName(UI.getCurrent().getLocale()));
        }
        this.m_breadCrumb.setEntries(entries);
    }

    protected void updateSubNav(List<NavEntry> subEntries) {
        this.m_rootLayout.clearSubNav();
        if (subEntries == null || subEntries.isEmpty()) {
            this.m_rootLayout.setSubNavVisible(false);
        } else {
            this.m_rootLayout.setSubNavVisible(true);
            for (NavEntry entry : subEntries) {
                this.addSubNavEntry(entry);
            }
        }
    }

    public static class NavEntry {
        private String m_description;
        private Resource m_icon;
        private String m_name;
        private String m_targetState;

        public NavEntry(String name, String description, Resource icon, String targetState) {
            this.m_name = name;
            this.m_description = description;
            this.m_icon = icon;
            this.m_targetState = targetState;
        }

        public String getDescription() {
            return this.m_description;
        }

        public Resource getIcon() {
            return this.m_icon;
        }

        public String getName() {
            return this.m_name;
        }

        public String getTargetState() {
            return this.m_targetState;
        }
    }
}

