/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.ui.sitemap.CmsUnlinkDialog;

public class CmsUnlinkLocaleVariantAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "unlinklocale";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.DEFAULT_DEFAULTFILE);
    private static final Log LOG = CmsLog.getLog(CmsUnlinkLocaleVariantAction.class);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        try {
            CmsResource resource = context.getResources().get(0);
            CmsObject cms = context.getCms();
            List<CmsRelation> relations = this.readOutgoingRelations(cms, resource);
            for (CmsRelation relation : relations) {
                try {
                    CmsResource target = relation.getTarget(cms, CmsResourceFilter.IGNORE_EXPIRATION);
                    CmsUnlinkDialog unlinkDialog = new CmsUnlinkDialog(context, target);
                    this.openDialog(unlinkDialog, context);
                    break;
                }
                catch (CmsException e) {
                    LOG.info((Object)("No target found for: " + String.valueOf(relation)), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            context.error(e);
        }
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getTitleKey() {
        return "GUI_LOCALECOMPARE_UNLINK_LOCALE_VARIANT_0";
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        CmsMenuItemVisibilityMode visibility = VISIBILITY.getVisibility(cms, resources);
        if (visibility.isInVisible() || visibility.isInActive()) {
            return visibility;
        }
        try {
            List<CmsRelation> relations = this.readOutgoingRelations(cms, resources.get(0));
            boolean hasRelations = false;
            for (CmsRelation relation : relations) {
                if (relation.getTargetId().isNullUUID()) continue;
                hasRelations = true;
                break;
            }
            return hasRelations ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    List<CmsRelation> readOutgoingRelations(CmsObject cms, CmsResource resource) throws CmsException {
        List<CmsRelation> results = cms.readRelations(CmsRelationFilter.relationsFromStructureId(resource.getStructureId()).filterType(CmsRelationType.LOCALE_VARIANT));
        return results;
    }
}

