/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.loader.CmsTemplateContextManager;
import org.opencms.loader.I_CmsTemplateContextProvider;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;

public class CmsTemplateContextsAction
extends A_CmsWorkplaceAction
implements I_CmsADEAction {
    private static final Log LOG = CmsLog.getLog(CmsTemplateContextsAction.class);
    private int m_menuPosition;

    public CmsTemplateContextsAction(int menuPosition) {
        if (menuPosition != 0 && menuPosition != 1) {
            throw new IllegalArgumentException("Menu position must be 0 or 1");
        }
        this.m_menuPosition = menuPosition;
    }

    @Override
    public void executeAction(I_CmsDialogContext context) {
    }

    @Override
    public String getCommandClassName() {
        return "templatecontexts";
    }

    @Override
    public String getId() {
        return "templatecontexts_" + this.m_menuPosition;
    }

    @Override
    public String getJspPath() {
        return null;
    }

    @Override
    public Map<String, String> getParams() {
        return null;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        if (!CmsCoreData.AdeContext.pageeditor.name().equals(context.getAppId())) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        List<CmsResource> resources = context.getResources();
        if (resources.size() != 1) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        CmsObject cms = context.getCms();
        CmsResource resource = resources.get(0);
        try {
            I_CmsTemplateContextProvider provider;
            String propertyValue;
            List<CmsProperty> properties = cms.readPropertyObjects(resource, true);
            CmsProperty templateProp = CmsProperty.get("template", properties);
            if (templateProp != null && !templateProp.isNullProperty() && CmsTemplateContextManager.hasPropertyPrefix(propertyValue = templateProp.getValue()) && (provider = OpenCms.getTemplateContextManager().getTemplateContextProvider(CmsTemplateContextManager.removePropertyPrefix(propertyValue))) != null) {
                if (provider.getMenuPosition() != this.m_menuPosition) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
                if (!provider.shouldShowContextMenuOption(cms)) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
    }

    @Override
    public boolean isAdeSupported() {
        return true;
    }

    @Override
    protected String getTitleKey() {
        return "TEMPLATECONTEXTS";
    }
}

