/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsDialogContextWithAdeContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.ui.dialogs.CmsCopyMoveDialog;

public class CmsMoveDialogAction
extends A_CmsWorkplaceAction
implements I_CmsADEAction {
    public static final String ACTION_ID = "move";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = CmsStandardVisibilityCheck.DEFAULT;
    private static final Log LOG = CmsLog.getLog(CmsMoveDialogAction.class);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        if (!this.hasBlockingLocks(context)) {
            CmsCopyMoveDialog dialog = new CmsCopyMoveDialog(context, CmsCopyMoveDialog.DialogMode.move);
            if (!context.getResources().isEmpty()) {
                CmsResource res = context.getResources().get(0);
                try {
                    CmsResource parent = context.getCms().readParentFolder(res.getStructureId());
                    dialog.setTargetForlder(parent);
                }
                catch (CmsException e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.openDialog(dialog, context);
        }
    }

    @Override
    public String getCommandClassName() {
        return "org.opencms.gwt.client.ui.contextmenu.CmsEmbeddedAction";
    }

    @Override
    public String getDialogTitleKey() {
        return "GUI_DIALOGTITLE_MOVE_0";
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getJspPath() {
        return null;
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dialogId", this.getClass().getName());
        return params;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        if (context instanceof I_CmsDialogContextWithAdeContext) {
            CmsCoreData.AdeContext adeContext = ((I_CmsDialogContextWithAdeContext)context).getAdeContext();
            if (adeContext == CmsCoreData.AdeContext.resourceinfo && OpenCms.getRoleManager().hasRole(context.getCms(), CmsRole.DEVELOPER)) {
                return VISIBILITY.getVisibility(context.getCms(), context.getResources());
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        return VISIBILITY.getVisibility(context.getCms(), context.getResources());
    }

    @Override
    public boolean isAdeSupported() {
        return true;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_DIALOGTITLE_MOVE_0";
    }
}

