/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.vaadin.navigator.View;
import com.vaadin.ui.UI;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.main.OpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsDefaultAction;
import org.opencms.ui.apps.CmsAppView;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsEditor;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsStringUtil;

public class CmsEditDialogAction
extends A_CmsWorkplaceAction
implements I_CmsDefaultAction {
    public static final String ACTION_ID = "edit";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.EDIT);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        View view = CmsAppWorkplaceUi.get().getCurrentView();
        if (view instanceof CmsAppView) {
            ((CmsAppView)view).setCacheStatus(CmsAppView.CacheStatus.cacheOnce);
        }
        CmsResource resource = context.getResources().get(0);
        String editState = CmsEditor.getEditState(resource.getStructureId(), false, UI.getCurrent().getPage().getLocation().toString());
        CmsAppWorkplaceUi.get().showApp(OpenCms.getWorkplaceAppManager().getAppConfiguration("editor"), editState);
    }

    @Override
    public int getDefaultActionRank(I_CmsDialogContext context) {
        CmsResource res = context.getResources().get(0);
        boolean editAsDefault = (CmsResourceTypeXmlContent.isXmlContent(res) || CmsResourceTypePlain.getStaticTypeId() == res.getTypeId() || CmsResourceTypeXmlPage.isXmlPage(res)) && !OpenCms.getResourceManager().getResourceType(res).getTypeName().equals("listconfig") && (!res.getName().endsWith(".html") && !res.getName().endsWith(".htm") || CmsStringUtil.isEmptyOrWhitespaceOnly(context.getCms().getRequestContext().getSiteRoot()));
        editAsDefault = editAsDefault || CmsResourceTypeJsp.isJsp(res) && !res.getName().endsWith(".html") && !res.getName().endsWith(".htm");
        boolean isPropertyBundle = OpenCms.getResourceManager().getResourceType(res).getTypeName().equals("propertyvfsbundle");
        boolean bl = editAsDefault = editAsDefault || isPropertyBundle;
        if (editAsDefault) {
            return 20;
        }
        return 0;
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        if (resources.size() == 1 && !CmsResourceTypeXmlContainerPage.isContainerPage(resources.get(0))) {
            return VISIBILITY.getVisibility(cms, resources);
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_EXPLORER_CONTEXT_EDIT_0";
    }
}

