/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.actions.I_CmsWorkplaceAction;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;

public class CmsContextMenuActionItem
implements I_CmsContextMenuItem,
I_CmsADEAction {
    private I_CmsWorkplaceAction m_action;
    private float m_order;
    private String m_parentId;
    private int m_priority;

    public CmsContextMenuActionItem(I_CmsWorkplaceAction action, String parentId, float order, int priority) {
        this.m_parentId = parentId;
        this.m_order = order;
        this.m_priority = priority;
        this.m_action = action;
    }

    @Override
    public void executeAction(I_CmsDialogContext context) {
        CmsAppWorkplaceUi.get().disableGlobalShortcuts();
        this.m_action.executeAction(context);
    }

    @Override
    public String getCommandClassName() {
        if (this.isAdeSupported()) {
            return ((I_CmsADEAction)((Object)this.m_action)).getCommandClassName();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.m_action.getId();
    }

    @Override
    public String getJspPath() {
        if (this.isAdeSupported()) {
            return ((I_CmsADEAction)((Object)this.m_action)).getJspPath();
        }
        return null;
    }

    @Override
    public float getOrder() {
        return this.m_order;
    }

    @Override
    public Map<String, String> getParams() {
        if (this.isAdeSupported()) {
            return ((I_CmsADEAction)((Object)this.m_action)).getParams();
        }
        return null;
    }

    @Override
    public String getParentId() {
        return this.m_parentId;
    }

    @Override
    public int getPriority() {
        return this.m_priority;
    }

    @Override
    public String getTitle(Locale locale) {
        return this.m_action.getTitle(locale);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return this.m_action.getVisibility(cms, resources);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        return this.m_action.getVisibility(context);
    }

    public I_CmsWorkplaceAction getWorkplaceAction() {
        return this.m_action;
    }

    @Override
    public boolean isAdeSupported() {
        return this.m_action instanceof I_CmsADEAction && ((I_CmsADEAction)((Object)this.m_action)).isAdeSupported();
    }

    @Override
    public boolean isLeafItem() {
        return true;
    }
}

