/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;

public class CmsCategoriesDialogAction
extends A_CmsWorkplaceAction
implements I_CmsADEAction {
    public static final String ACTION_ID = "categories";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.DEFAULT);
    private static final String PARAM_COLLAPSED = "displayCollapsed";

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        if (!this.hasBlockingLocks(context)) {
            CmsGwtDialogExtension extension = new CmsGwtDialogExtension(A_CmsUI.get(), new I_CmsUpdateListener<String>(){

                @Override
                public void onUpdate(List<String> updatedItems) {
                    ArrayList ids = Lists.newArrayList();
                    for (String item : updatedItems) {
                        ids.add(new CmsUUID(item));
                    }
                    context.finish(ids);
                }
            });
            extension.openCategories(context.getResources().get(0));
        }
    }

    @Override
    public String getCommandClassName() {
        return "org.opencms.gwt.client.ui.contextmenu.CmsCategories";
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getJspPath() {
        return null;
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(PARAM_COLLAPSED, Boolean.TRUE.toString());
        return params;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }

    @Override
    public boolean isAdeSupported() {
        return true;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_EXPLORER_CONTEXT_CATEGORIES_0";
    }
}

