/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;

public abstract class A_CmsGalleryDialogAction
extends A_CmsWorkplaceAction {
    static final Log LOG = CmsLog.getLog(A_CmsGalleryDialogAction.class);

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        if (resources.size() == 1) {
            CmsResource resource = resources.get(0);
            if (resource.isFolder()) {
                String type = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
                if (Arrays.asList(this.getSupportedGalleryTypes()).contains(type)) {
                    return CmsStandardVisibilityCheck.VISIBLE.getVisibility(cms, resources);
                }
            } else {
                CmsResource parentGallery = this.getParentGallery(cms, resource);
                if (parentGallery != null) {
                    ArrayList<CmsResource> parentList = new ArrayList<CmsResource>();
                    parentList.add(parentGallery);
                    return this.getVisibility(cms, parentList);
                }
            }
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    protected CmsResource getGallery(I_CmsDialogContext context) {
        CmsResource resource = context.getResources().get(0);
        return resource.isFolder() ? resource : this.getParentGallery(context.getCms(), resource);
    }

    protected abstract String[] getSupportedGalleryTypes();

    private CmsResource getParentGallery(CmsObject cms, CmsResource resource) {
        String parentFolder = CmsResource.getParentFolder(resource.getRootPath());
        parentFolder = cms.getRequestContext().removeSiteRoot(parentFolder);
        CmsResource parentGallery = null;
        try {
            parentGallery = cms.readResource(parentFolder);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return parentGallery;
    }
}

