/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui;

import com.alkacon.simapi.IdentIcon;
import com.alkacon.simapi.Simapi;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsNameBasedDiskCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;

public class CmsUserIconHelper {
    public static final Color ADMIN_COLOR = new Color(0, 48, 130);
    public static final String BIG_ICON_SUFFIX = "_big_icon.png";
    public static final String ICON_FOLDER = "user_icons";
    public static final String SMALL_ICON_SUFFIX = "_small_icon.png";
    public static final String TEMP_FOLDER = "temp/";
    public static final String TINY_ICON_SUFFIX = "_tiny_icon.png";
    public static final String USER_IMAGE_FOLDER = "/system/userimages/";
    public static final String USER_IMAGE_INFO = "USER_IMAGE";
    private static final Log LOG = CmsLog.getLog(CmsUserIconHelper.class);
    private CmsObject m_adminCms;
    private CmsVfsNameBasedDiskCache m_cache;
    private IdentIcon m_renderer;

    public CmsUserIconHelper(CmsObject adminCms) {
        this.m_adminCms = adminCms;
        this.m_renderer = new IdentIcon();
        this.m_renderer.setReservedColor(ADMIN_COLOR);
        this.m_cache = new CmsVfsNameBasedDiskCache(OpenCms.getSystemInfo().getWebApplicationRfsPath() + "//resources/", ICON_FOLDER);
    }

    public static boolean hasUserImage(CmsUser user) {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)user.getAdditionalInfo(USER_IMAGE_INFO));
    }

    public void deleteUserImage(CmsObject cms) {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        String userIconPath = (String)user.getAdditionalInfo(USER_IMAGE_INFO);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userIconPath)) {
            try {
                CmsObject adminCms = OpenCms.initCmsObject(this.m_adminCms);
                if (adminCms.existsResource(userIconPath)) {
                    CmsProject tempProject = adminCms.createTempfileProject();
                    adminCms.getRequestContext().setCurrentProject(tempProject);
                    adminCms.lockResource(userIconPath);
                    adminCms.deleteResource(userIconPath, CmsResource.DELETE_REMOVE_SIBLINGS);
                }
                user.deleteAdditionalInfo(USER_IMAGE_INFO);
                adminCms.writeUser(user);
                try {
                    OpenCms.getPublishManager().publishProject(adminCms);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error publishing user image resources.", (Throwable)e);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Error deleting previous user image.", (Throwable)e);
            }
        }
    }

    public String getBigIconPath(CmsObject cms, CmsUser user) {
        return this.getIconPath(cms, user, IconSize.Big);
    }

    public String getSmallIconPath(CmsObject cms, CmsUser user) {
        return this.getIconPath(cms, user, IconSize.Small);
    }

    public String getTinyIconPath(CmsObject cms, CmsUser user) {
        return this.getIconPath(cms, user, IconSize.Tiny);
    }

    public boolean handleImageUpload(CmsObject cms, CmsUser user, String uploadedFile) {
        boolean result = false;
        try {
            this.setUserImage(cms, user, uploadedFile);
            result = true;
        }
        catch (CmsException e) {
            LOG.error((Object)"Error setting user image.", (Throwable)e);
        }
        try {
            cms.lockResource(uploadedFile);
            cms.deleteResource(uploadedFile, CmsResource.DELETE_REMOVE_SIBLINGS);
        }
        catch (CmsException e) {
            LOG.error((Object)"Error deleting user image temp file.", (Throwable)e);
        }
        return result;
    }

    public boolean handleImageUpload(CmsObject cms, List<String> uploadedFiles) {
        boolean result = false;
        if (uploadedFiles.size() == 1) {
            String tempFile = CmsStringUtil.joinPaths(USER_IMAGE_FOLDER, TEMP_FOLDER, uploadedFiles.get(0));
            result = this.handleImageUpload(cms, cms.getRequestContext().getCurrentUser(), tempFile);
        }
        return result;
    }

    public void setUserImage(CmsObject cms, CmsUser user, String rootPath) throws CmsException {
        CmsFile tempFile = cms.readFile(cms.getRequestContext().removeSiteRoot(rootPath));
        CmsImageScaler scaler = new CmsImageScaler(tempFile.getContents(), tempFile.getRootPath());
        if (scaler.isValid()) {
            scaler.setType(2);
            scaler.setHeight(192);
            scaler.setWidth(192);
            byte[] content = scaler.scaleImage(tempFile);
            String previousImage = (String)user.getAdditionalInfo(USER_IMAGE_INFO);
            String newFileName = USER_IMAGE_FOLDER + user.getId().toString() + "_" + System.currentTimeMillis() + this.getSuffix(tempFile.getName());
            CmsObject adminCms = OpenCms.initCmsObject(this.m_adminCms);
            CmsProject tempProject = adminCms.createTempfileProject();
            adminCms.getRequestContext().setCurrentProject(tempProject);
            if (adminCms.existsResource(newFileName)) {
                CmsFile imageFile = adminCms.readFile(newFileName);
                adminCms.lockResource(imageFile);
                imageFile.setContents(content);
                adminCms.writeFile(imageFile);
                adminCms.writePropertyObject(newFileName, new CmsProperty("image.size", null, "w:192,h:192"));
            } else {
                adminCms.createResource(newFileName, OpenCms.getResourceManager().getResourceType(CmsResourceTypeImage.getStaticTypeName()), content, Collections.singletonList(new CmsProperty("image.size", null, "w:192,h:192")));
            }
            if (newFileName.equals(previousImage)) {
                previousImage = null;
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(previousImage) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(previousImage = (String)user.getAdditionalInfo(USER_IMAGE_INFO)) && cms.existsResource(newFileName, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                try {
                    adminCms.lockResource(previousImage);
                    adminCms.deleteResource(previousImage, CmsResource.DELETE_REMOVE_SIBLINGS);
                }
                catch (CmsException e) {
                    LOG.error((Object)"Error deleting previous user image.", (Throwable)e);
                }
            }
            user.setAdditionalInfo(USER_IMAGE_INFO, newFileName);
            adminCms.writeUser(user);
            try {
                OpenCms.getPublishManager().publishProject(adminCms);
            }
            catch (Exception e) {
                LOG.error((Object)"Error publishing user image resources.", (Throwable)e);
            }
        }
    }

    private String getIconPath(CmsObject cms, CmsUser user, IconSize size) {
        Object userIconPath = (String)user.getAdditionalInfo(USER_IMAGE_INFO);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)userIconPath)) {
            userIconPath = (String)userIconPath + (String)(size.equals((Object)IconSize.Big) ? "" : "?__scale=h:" + size.getSize() + ",w:" + size.getSize() + ",t:2");
            return OpenCms.getLinkManager().substituteLinkForRootPath(cms, (String)userIconPath);
        }
        boolean isAdmin = OpenCms.getRoleManager().hasRole(cms, user.getName(), CmsRole.ADMINISTRATOR);
        String name = user.getName() + Boolean.toString(isAdmin);
        String rfsName = this.toRfsName(name, size);
        String path = this.toPath(name, size);
        if (!this.m_cache.hasCacheContent(rfsName)) {
            BufferedImage icon = this.m_renderer.render(name, isAdmin, size.getSize());
            try {
                this.m_cache.saveCacheFile(rfsName, this.getImageBytes(icon));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return path;
    }

    private byte[] getImageBytes(BufferedImage image) throws IOException {
        return Simapi.getImageBytes((BufferedImage)image, (String)"PNG");
    }

    private String getSuffix(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            return fileName.substring(index);
        }
        return fileName;
    }

    private String toPath(String name, IconSize size) {
        return CmsStringUtil.joinPaths(CmsWorkplace.getSkinUri(), ICON_FOLDER, "" + name.hashCode()) + size.getSuffix();
    }

    private String toRfsName(String name, IconSize size) {
        return CmsStringUtil.joinPaths(this.m_cache.getRepositoryPath(), "" + name.hashCode()) + size.getSuffix();
    }

    private static enum IconSize {
        Big(192, "_big_icon.png"),
        Small(64, "_small_icon.png"),
        Tiny(46, "_tiny_icon.png");

        private int m_size;
        private String m_suffix;

        private IconSize(int size, String suffix) {
            this.m_size = size;
            this.m_suffix = suffix;
        }

        public int getSize() {
            return this.m_size;
        }

        public String getSuffix() {
            return this.m_suffix;
        }
    }
}

