/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui;

import com.vaadin.server.FontIcon;
import org.opencms.util.CmsStringUtil;

public class CmsCssIcon
implements FontIcon {
    private static final long serialVersionUID = -1013502165062622197L;
    private String m_additionalButtonStyle;
    private int m_codePoint = 160;
    private String m_styleName;
    private String m_styleNameOverlay;

    public CmsCssIcon(FontIcon icon) {
        this.m_styleName = icon.getFontFamily();
        this.m_codePoint = icon.getCodepoint();
        if (icon instanceof CmsCssIcon) {
            this.m_styleNameOverlay = ((CmsCssIcon)icon).m_styleNameOverlay;
            this.m_additionalButtonStyle = ((CmsCssIcon)icon).m_additionalButtonStyle;
        }
    }

    public CmsCssIcon(String styleName) {
        this.m_styleName = styleName;
    }

    public CmsCssIcon(String styleName, String additionalStyle) {
        this.m_styleName = styleName;
        this.m_additionalButtonStyle = additionalStyle;
    }

    public String getAdditionalButtonStyle() {
        return this.m_additionalButtonStyle;
    }

    public int getCodepoint() {
        return this.m_codePoint;
    }

    public String getFontFamily() {
        return this.m_styleName;
    }

    public String getHtml() {
        return "<span class=\"v-icon " + this.m_styleName + " " + this.m_additionalButtonStyle + "\">&#x" + Integer.toHexString(this.getCodepoint()) + ";</span>";
    }

    public String getHtml(String title) {
        return "<span class=\"v-icon " + this.m_styleName + " " + this.m_additionalButtonStyle + "\" title=\"" + title + "\">&#x" + Integer.toHexString(this.getCodepoint()) + ";</span>";
    }

    public String getHtmlWithOverlay() {
        if (this.m_styleNameOverlay == null) {
            return this.getHtml();
        }
        return "<div class=\"o-resource-icon v-widget v-has-width\" style=\"width: 100%; padding-left: 0px !important;\">" + this.getHtml() + "<span class=\"" + this.m_styleNameOverlay + "\" title=\"\"></span></div>";
    }

    public String getMIMEType() {
        throw new UnsupportedOperationException(FontIcon.class.getSimpleName() + " should not be used where a MIME type is needed.");
    }

    public String getStyleName() {
        return this.m_styleName;
    }

    public boolean hasAdditionalButtonStyle() {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_additionalButtonStyle);
    }

    public void setAdditionalButtonStyle(String additionalStyle) {
        this.m_additionalButtonStyle = additionalStyle;
    }

    public void setOverlay(String overlayStyle) {
        this.m_styleNameOverlay = overlayStyle;
    }
}

