/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui;

import com.google.common.collect.Multimap;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.WrappedHttpSession;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TooltipConfiguration;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.main.CmsUIServlet;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsHasButtons;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.extensions.CmsWindowExtension;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.ui.util.CmsDisplayType;
import org.opencms.util.CmsRequestUtil;
import org.opencms.workplace.CmsWorkplaceSettings;

public abstract class A_CmsUI
extends UI {
    public static final String LAST_OFFLINE_PROJECT = "lastOfflineProject";
    private static final long serialVersionUID = 989182479322461838L;
    private Map<String, Serializable> m_attributes;
    private CmsDisplayType m_displayType;
    private CmsWindowExtension m_windowExtension = new CmsWindowExtension(this);

    public A_CmsUI() {
        this.m_attributes = new ConcurrentHashMap<String, Serializable>();
        this.getLoadingIndicatorConfiguration().setFirstDelay(600);
        TooltipConfiguration tooltipConfig = this.getTooltipConfiguration();
        tooltipConfig.setOpenDelay(750);
        tooltipConfig.setQuickOpenDelay(750);
    }

    public static A_CmsUI get() {
        return (A_CmsUI)UI.getCurrent();
    }

    public static CmsObject getCmsObject() {
        return ((CmsUIServlet)VaadinServlet.getCurrent()).getCmsObject();
    }

    public void changeProject(CmsProject project) {
        CmsObject cms = A_CmsUI.getCmsObject();
        if (!cms.getRequestContext().getCurrentProject().equals(project)) {
            cms.getRequestContext().setCurrentProject(project);
            this.getWorkplaceSettings().setProject(project.getUuid());
            OpenCms.getSessionManager().updateSessionInfo(cms, this.getHttpSession());
            if (!project.isOnlineProject()) {
                this.setAttribute(LAST_OFFLINE_PROJECT, project);
            }
        }
    }

    public void changeSite(String siteRoot) {
        if (!A_CmsUI.getCmsObject().getRequestContext().getSiteRoot().equals(siteRoot)) {
            A_CmsUI.getCmsObject().getRequestContext().setSiteRoot(siteRoot);
            this.getWorkplaceSettings().setSite(siteRoot);
            OpenCms.getSessionManager().updateSessionInfo(A_CmsUI.getCmsObject(), this.getHttpSession());
        }
    }

    public void closeWindows() {
        for (Window window : this.getWindows()) {
            window.close();
        }
    }

    public Serializable getAttribute(String key) {
        return this.m_attributes.get(key);
    }

    public CmsDisplayType getDisplayType() {
        return this.m_displayType;
    }

    public HttpSession getHttpSession() {
        return ((WrappedHttpSession)this.getSession().getSession()).getHttpSession();
    }

    public CmsProject getLastOfflineProject() {
        return (CmsProject)this.getAttribute(LAST_OFFLINE_PROJECT);
    }

    public Multimap<String, String> getParameters() {
        return CmsRequestUtil.getParameters(this.getPage().getLocation());
    }

    public CmsWorkplaceSettings getWorkplaceSettings() {
        CmsWorkplaceSettings settings = (CmsWorkplaceSettings)this.getSession().getSession().getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS");
        if (settings == null) {
            settings = CmsLoginHelper.initSiteAndProject(A_CmsUI.getCmsObject());
            VaadinService.getCurrentRequest().getWrappedSession().setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)settings);
        }
        return settings;
    }

    public void openPageOrWarn(String link, String target) {
        this.openPageOrWarn(link, target, CmsVaadinUtils.getMessageText("GUI_POPUP_BLOCKED_0", new Object[0]));
    }

    public void openPageOrWarn(String link, String target, final String warning) {
        this.m_windowExtension.open(link, target, new Runnable(){

            @Override
            public void run() {
                Notification.show((String)warning, (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
        });
    }

    public void reload() {
        this.getPage().reload();
    }

    public void setAttribute(String key, Serializable value) {
        this.m_attributes.put(key, value);
    }

    public void setContentToDialog(String caption, CmsBasicDialog dialog) {
        this.setContent((Component)new Label());
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.narrow);
        window.setContent((Component)dialog);
        window.setCaption(caption);
        window.setClosable(false);
        this.addWindow(window);
        window.center();
    }

    public void setContentToDialog(String caption, Component component) {
        this.setContent((Component)new Label());
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.narrow);
        CmsBasicDialog dialog = new CmsBasicDialog();
        VerticalLayout result = new VerticalLayout();
        dialog.setContent((Component)result);
        window.setContent((Component)dialog);
        window.setCaption(caption);
        window.setClosable(false);
        this.addWindow(window);
        window.center();
        if (component instanceof I_CmsHasButtons) {
            I_CmsHasButtons hasButtons = (I_CmsHasButtons)component;
            for (Button button : hasButtons.getButtons()) {
                dialog.addButton((Component)button);
            }
        }
        result.addComponent(component);
    }

    public void setError(String error) {
        this.setContentToDialog("Error", (Component)new Label(error));
    }

    protected void init(VaadinRequest request) {
        this.m_displayType = CmsDisplayType.getDisplayType(this.getPage().getBrowserWindowWidth());
    }
}

