/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;

public class CmsUgcValueTransformerConfiguration {
    private static final String JSON_KEY_TRANSFORMER = "transformer";
    private static final String JSON_KEY_CONFIG = "config";
    public static final CmsUgcValueTransformerConfiguration DEFAULT = new CmsUgcValueTransformerConfiguration();
    private Map<String, CmsUgcSingleValueTransformer> m_transformerMap;

    public CmsUgcValueTransformerConfiguration(String config) throws JSONException, IllegalArgumentException {
        if (config != null) {
            JSONObject security = new JSONObject(config);
            Set<String> paths = security.keySet();
            HashMap<String, CmsUgcSingleValueTransformer> mappingSecurity = new HashMap<String, CmsUgcSingleValueTransformer>(paths.size());
            for (String path : paths) {
                JSONObject pathConfig = security.getJSONObject(path);
                String adjustment = pathConfig.getString(JSON_KEY_TRANSFORMER);
                JSONObject mappingConfig = pathConfig.optJSONObject(JSON_KEY_CONFIG);
                mappingSecurity.put(path, new CmsUgcSingleValueTransformer(CmsUgcSingleValueTransformer.TransformType.valueOf(adjustment), mappingConfig));
            }
            this.m_transformerMap = mappingSecurity;
        } else {
            this.m_transformerMap = Collections.emptyMap();
        }
    }

    private CmsUgcValueTransformerConfiguration() {
        this.m_transformerMap = Collections.emptyMap();
    }

    public CmsUgcSingleValueTransformer getTransformer(String path) {
        return this.m_transformerMap.getOrDefault(path, CmsUgcSingleValueTransformer.DEFAULT);
    }

    public static class CmsUgcSingleValueTransformer {
        public static CmsUgcSingleValueTransformer DEFAULT = new CmsUgcSingleValueTransformer(TransformType.escape);
        private TransformType m_type;
        private JSONObject m_config;

        public CmsUgcSingleValueTransformer(TransformType type) {
            this.m_type = type == null ? TransformType.escape : type;
        }

        public CmsUgcSingleValueTransformer(TransformType type, JSONObject config) {
            this.m_type = type;
            this.m_config = TransformType.antisamy.equals((Object)this.m_type) ? config : null;
        }

        public JSONObject getConfig() {
            return this.m_config;
        }

        public TransformType getType() {
            return this.m_type;
        }

        public static enum TransformType {
            escape,
            antisamy,
            none;

        }
    }
}

