/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ugc.CmsUgcValueTransformerConfiguration;
import org.opencms.util.CmsParameterEscaper;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class CmsUgcValueTranformHandler {
    private static final Log LOG = CmsLog.getLog(CmsUgcValueTranformHandler.class);
    public static final CmsUgcValueTranformHandler DEFAULT = new CmsUgcValueTranformHandler();
    private static String PARAM_UGC_VALUES_TRANSFORMER = "ugc.values.transformer";
    private static String JSON_KEY_POLICY = "policy";
    private CmsObject m_cms;
    private CmsUgcValueTransformerConfiguration m_config;
    private CmsParameterEscaper m_escaper;

    public CmsUgcValueTranformHandler(CmsObject cms, CmsResource resource) throws CmsXmlException, CmsException, IllegalArgumentException, JSONException {
        this.m_cms = cms;
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, this.m_cms.readFile(resource));
        String valuesTransformerConfig = content.getHandler().getParameter(PARAM_UGC_VALUES_TRANSFORMER);
        this.m_config = new CmsUgcValueTransformerConfiguration(valuesTransformerConfig);
    }

    private CmsUgcValueTranformHandler() {
        this.m_config = CmsUgcValueTransformerConfiguration.DEFAULT;
    }

    public String transformValue(String path, String value) {
        CmsUgcValueTransformerConfiguration.CmsUgcSingleValueTransformer secVal = this.m_config.getTransformer(CmsXmlUtils.removeAllXpathIndices(path));
        switch (secVal.getType()) {
            case none: {
                return value;
            }
            case antisamy: {
                AntiSamy antiSamy = this.getParameterEscaper().createAntiSamy(this.m_cms, null == secVal.getConfig() ? null : secVal.getConfig().optString(JSON_KEY_POLICY, null));
                try {
                    CleanResults cres = antiSamy.scan(value);
                    return cres.getCleanHTML();
                }
                catch (PolicyException | ScanException e) {
                    LOG.error((Object)("Failed to clean HTML value \"" + value + "\" in path \"" + path + "\" via AntiSamy. Defaulting to 'escape'."), e);
                    break;
                }
            }
            case escape: {
                break;
            }
            default: {
                LOG.error((Object)("Unsupported Security mapping type " + String.valueOf((Object)secVal.getType()) + ". Defaulting to 'escape'."));
            }
        }
        return CmsEncoder.escapeXml(value);
    }

    private CmsParameterEscaper getParameterEscaper() {
        if (this.m_escaper == null) {
            this.m_escaper = new CmsParameterEscaper();
        }
        return this.m_escaper;
    }
}

