/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ugc.CmsUgcConfiguration;
import org.opencms.ugc.CmsUgcConfigurationReader;
import org.opencms.ugc.CmsUgcSession;
import org.opencms.ugc.CmsUgcSessionQueue;
import org.opencms.ugc.Messages;
import org.opencms.ugc.shared.CmsUgcConstants;
import org.opencms.ugc.shared.CmsUgcException;
import org.opencms.util.CmsUUID;

public class CmsUgcSessionFactory {
    private static final Log LOG = CmsLog.getLog(CmsUgcSessionFactory.class);
    private static CmsUgcSessionFactory INSTANCE;
    private static CmsObject m_adminCms;
    private ConcurrentHashMap<CmsUUID, CmsUgcSessionQueue> m_queues = new ConcurrentHashMap();

    private CmsUgcSessionFactory() {
    }

    public static synchronized CmsUgcSessionFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmsUgcSessionFactory();
        }
        return INSTANCE;
    }

    public static void setAdminCms(CmsObject adminCms) {
        m_adminCms = adminCms;
    }

    public CmsUgcSession createSession(CmsObject cms, HttpServletRequest request, CmsUgcConfiguration config) throws CmsUgcException {
        CmsUgcSession session = this.createSession(cms, config);
        HttpSession httpSession = request.getSession(true);
        httpSession.setAttribute(String.valueOf(session.getId()), (Object)session);
        return session;
    }

    public CmsUgcSession createSession(CmsObject cms, HttpServletRequest request, String sitePath) throws CmsUgcException {
        CmsUgcConfigurationReader reader = new CmsUgcConfigurationReader(cms);
        CmsUgcConfiguration config = null;
        try {
            CmsFile configFile = cms.readFile(sitePath);
            config = reader.readConfiguration(configFile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new CmsUgcException(e, CmsUgcConstants.ErrorCode.errConfiguration, e.getLocalizedMessage());
        }
        return this.createSession(cms, request, config);
    }

    public CmsUgcSession createSessionForFile(CmsObject cms, HttpServletRequest request, String configPath, String fileName) throws CmsUgcException {
        CmsUgcSession session = this.createSession(cms, request, configPath);
        session.loadXmlContent(fileName);
        session.disableCleanup();
        return session;
    }

    public CmsUgcSession getSession(HttpServletRequest request, CmsUUID sessionId) {
        return (CmsUgcSession)request.getSession(true).getAttribute(String.valueOf(sessionId));
    }

    private CmsUgcSession createSession(CmsObject cms, CmsUgcConfiguration config) throws CmsUgcException {
        if (this.getQueue(config).waitForSlot()) {
            try {
                return new CmsUgcSession(m_adminCms, cms, config);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                throw new CmsUgcException(e);
            }
        }
        String message = Messages.get().container("ERR_WAIT_QUEUE_EXCEEDED_0").key(cms.getRequestContext().getLocale());
        throw new CmsUgcException(CmsUgcConstants.ErrorCode.errMaxQueueLengthExceeded, message);
    }

    private CmsUgcSessionQueue getQueue(CmsUgcConfiguration config) {
        CmsUgcSessionQueue queue = this.m_queues.get(config.getId());
        if (queue == null) {
            queue = CmsUgcSessionQueue.createQueue(config);
            this.m_queues.put(config.getId(), queue);
        } else {
            queue.updateFromConfiguration(config);
        }
        return queue;
    }
}

