/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.ObjectTag;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.util.CmsHtmlParser;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsLinkProcessor
extends CmsHtmlParser {
    public static final String ATTR_IS_PROCESSING_LINKS = "isInLinkProcessor";
    public static final String ATTRIBUTE_HREF = "href";
    public static final String ATTRIBUTE_SRC = "src";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String HTML_END = "</body></html>";
    public static final String HTML_START = "<html><body>";
    public static final String TAG_AREA = "AREA";
    public static final String TAG_EMBED = "EMBED";
    public static final String TAG_IFRAME = "IFRAME";
    public static final String TAG_PARAM = "PARAM";
    private static final String[] EMBED_TAG_LINKED_ATTRIBS = new String[]{"src", "pluginurl", "pluginspage"};
    private static final String[] OBJECT_TAG_LINKED_ATTRIBS = new String[]{"codebase", "data", "datasrc"};
    private static final int PROCESS_LINKS = 1;
    private static final int REPLACE_LINKS = 0;
    private static final Log LOG = CmsLog.getLog(CmsLinkProcessor.class);
    private static Cache<String, ExternalLinkWhitelistInfo> externalLinkWhitelistCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).concurrencyLevel(4).build();
    private CmsObject m_cms;
    private String m_encoding;
    private CmsLinkTable m_linkTable;
    private int m_mode;
    private String m_relativePath;
    private CmsObject m_rootCms;

    public CmsLinkProcessor(CmsObject cms, CmsLinkTable linkTable, String encoding, String relativePath) {
        super(true);
        this.m_cms = cms;
        if (this.m_cms != null) {
            try {
                this.m_rootCms = OpenCms.initCmsObject(cms);
                this.m_rootCms.getRequestContext().setSiteRoot("/");
            }
            catch (CmsException e) {
                this.m_rootCms = null;
            }
        }
        this.m_linkTable = linkTable;
        this.m_encoding = encoding;
        this.m_relativePath = relativePath;
    }

    public static String escapeLink(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source.length() * 2);
        block3: for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '&': {
                    int terminatorIndex = source.indexOf(59, i);
                    if (terminatorIndex > 0) {
                        String substr = source.substring(i + 1, terminatorIndex);
                        if ("amp".equals(substr)) {
                            result.append(ch);
                            continue block3;
                        }
                        result.append("&amp;");
                        continue block3;
                    }
                    result.append("&amp;");
                    continue block3;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return new String(result);
    }

    public static ExternalLinkWhitelistInfo getExternalLinkWhitelistInfo(CmsObject cms) {
        CmsADEConfigData sitemapConfig = OpenCms.getADEManager().lookupConfigurationWithCache(cms, cms.getRequestContext().getRootUri());
        String whitelist = sitemapConfig.getAttribute("template.editor.links.externalWhitelist", "");
        String cacheKey = cms.getRequestContext().getCurrentProject().isOnlineProject() + ":" + whitelist;
        try {
            return (ExternalLinkWhitelistInfo)externalLinkWhitelistCache.get((Object)cacheKey, () -> {
                Set whitelistEntries = Arrays.asList(whitelist.split(",")).stream().map(entry -> entry.trim()).filter(entry -> !CmsStringUtil.isEmptyOrWhitespaceOnly(entry)).collect(Collectors.toSet());
                HashSet<String> siteRoots = new HashSet<String>();
                for (String whitelistEntry : whitelistEntries) {
                    for (Map.Entry<CmsSiteMatcher, CmsSite> siteEntry : OpenCms.getSiteManager().getSites().entrySet()) {
                        CmsSiteMatcher key = siteEntry.getKey();
                        try {
                            URI uri = new URI(key.getUrl());
                            String host = uri.getHost();
                            if (host == null || !host.equals(whitelistEntry) && !host.endsWith("." + whitelistEntry)) continue;
                            siteRoots.add(siteEntry.getValue().getSiteRoot());
                        }
                        catch (Exception e) {
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                return new ExternalLinkWhitelistInfo(Collections.unmodifiableSet(whitelistEntries), Collections.unmodifiableSet(siteRoots));
            });
        }
        catch (ExecutionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new ExternalLinkWhitelistInfo(new HashSet<String>(), new HashSet<String>());
        }
    }

    public static boolean shouldMarkAsExternal(CmsObject cms, CmsADEConfigData sitemapConfig, CmsLink link) {
        boolean markAsExternal = false;
        if (link.isInternal()) {
            String target = link.getTarget();
            if (target != null && target.startsWith("/")) {
                CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(target);
                CmsSite currentSite = OpenCms.getSiteManager().getSiteForRootPath(cms.getRequestContext().getRootUri());
                if (site != null && currentSite != null && !currentSite.getSiteRoot().equals(site.getSiteRoot())) {
                    markAsExternal = true;
                }
            }
        } else {
            markAsExternal = true;
        }
        String siteRoot = link.getSiteRoot();
        if (markAsExternal) {
            ExternalLinkWhitelistInfo whitelistInfo = CmsLinkProcessor.getExternalLinkWhitelistInfo(cms);
            Set<String> whitelistSiteRoots = whitelistInfo.getSiteRoots();
            try {
                URI uri = new URI(link.getUri());
                if (uri.getHost() != null) {
                    if (whitelistInfo.getWhitelistEntries().stream().anyMatch(entry -> entry.equals(uri.getHost()) || StringUtils.endsWith((CharSequence)uri.getHost(), (CharSequence)("." + entry)))) {
                        markAsExternal = false;
                    }
                } else if (siteRoot != null && whitelistSiteRoots.contains(siteRoot)) {
                    markAsExternal = false;
                }
            }
            catch (URISyntaxException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return markAsExternal;
    }

    public static String unescapeLink(String source) {
        if (source == null) {
            return null;
        }
        return CmsStringUtil.substitute(source, "&amp;", "&");
    }

    public CmsLinkTable getLinkTable() {
        return this.m_linkTable;
    }

    public String processLinks(String content) throws ParserException {
        this.m_mode = 1;
        if (this.m_cms != null) {
            this.m_cms.getRequestContext().setAttribute(ATTR_IS_PROCESSING_LINKS, Boolean.TRUE);
        }
        try {
            String string = this.process(content, this.m_encoding);
            return string;
        }
        finally {
            if (this.m_cms != null) {
                this.m_cms.getRequestContext().removeAttribute(ATTR_IS_PROCESSING_LINKS);
            }
        }
    }

    public String replaceLinks(String content) throws ParserException {
        this.m_mode = 0;
        return this.process(content, this.m_encoding);
    }

    @Override
    public void visitTag(Tag tag) {
        String src;
        if (tag instanceof LinkTag) {
            this.processLinkTag((LinkTag)tag);
        } else if (tag instanceof ImageTag) {
            this.processImageTag((ImageTag)tag);
        } else if (tag instanceof ObjectTag) {
            this.processObjectTag((ObjectTag)tag);
        } else if (TAG_EMBED.equals(tag.getTagName())) {
            this.processEmbedTag(tag);
        } else if (TAG_AREA.equals(tag.getTagName())) {
            this.processAreaTag(tag);
        } else if (TAG_IFRAME.equals(tag.getTagName()) && (src = tag.getAttribute(ATTRIBUTE_SRC)) != null && !src.startsWith("//")) {
            this.processLink(tag, ATTRIBUTE_SRC, CmsRelationType.HYPERLINK);
        }
        super.visitTag(tag);
    }

    protected void processAreaTag(Tag tag) {
        this.processLink(tag, ATTRIBUTE_HREF, CmsRelationType.HYPERLINK);
    }

    protected void processEmbedTag(Tag tag) {
        for (int i = 0; i < EMBED_TAG_LINKED_ATTRIBS.length; ++i) {
            String attr = EMBED_TAG_LINKED_ATTRIBS[i];
            this.processLink(tag, attr, CmsRelationType.EMBEDDED_OBJECT);
        }
    }

    protected void processImageTag(ImageTag tag) {
        this.processLink((Tag)tag, ATTRIBUTE_SRC, CmsRelationType.valueOf(tag.getTagName()));
    }

    protected void processLink(Tag tag, String attr, CmsRelationType type) {
        if (tag.getAttribute(attr) == null) {
            return;
        }
        CmsLink link = null;
        switch (this.m_mode) {
            case 1: {
                CmsADEConfigData sitemapConfig;
                String externalMarker;
                link = this.m_linkTable.getLink(CmsMacroResolver.stripMacro(tag.getAttribute(attr)));
                if (link == null) break;
                Object l = link.getLink(this.m_cms);
                if (TAG_PARAM.equals(tag.getTagName()) && !((String)l).endsWith("?") && !((String)l).endsWith("&")) {
                    l = ((String)l).indexOf("?") > 0 ? (String)l + "&" : (String)l + "?";
                }
                tag.setAttribute(attr, CmsEncoder.escapeXml((String)l));
                if (tag.getTagName().equalsIgnoreCase("A") && this.m_cms.getRequestContext().isOnlineOrEditDisabled() && link.isInternal() && !CmsStringUtil.isEmpty(link.getTarget()) && link.getResource() == null) {
                    link.checkConsistency(this.m_cms);
                    if (link.getResource() == null && !CmsUUID.getNullUUID().equals(link.getStructureId()) && !link.hadSecurityErrorDuringLastConsistencyCheck()) {
                        tag.removeAttribute(ATTRIBUTE_HREF);
                        tag.setAttribute("data-oc-broken-link", "true");
                    }
                }
                if (this.m_cms == null || "none".equals(externalMarker = (sitemapConfig = OpenCms.getADEManager().lookupConfigurationWithCache(this.m_cms, this.m_cms.getRequestContext().getRootUri())).getAttribute("template.editor.links.externalMarker", "none").trim()) || !tag.getTagName().equalsIgnoreCase("A")) break;
                boolean markAsExternal = CmsLinkProcessor.shouldMarkAsExternal(this.m_cms, sitemapConfig, link);
                String attrClass = "class";
                String classesValue = tag.getAttribute("class");
                if (markAsExternal) {
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(classesValue)) {
                        tag.setAttribute("class", externalMarker);
                        break;
                    }
                    List<String> classes = Arrays.asList(classesValue.trim().split("\\s+"));
                    if (classes.contains(externalMarker)) break;
                    tag.setAttribute("class", classesValue + " " + externalMarker);
                    break;
                }
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(classesValue)) break;
                String newValue = Arrays.asList(classesValue.split("\\s+")).stream().filter(cls -> !cls.equals(externalMarker)).collect(Collectors.joining(" "));
                tag.setAttribute("class", newValue);
                break;
            }
            case 0: {
                String targetUri = tag.getAttribute(attr);
                if (!CmsStringUtil.isNotEmpty(targetUri)) break;
                String internalUri = null;
                if (!CmsMacroResolver.isMacro(targetUri)) {
                    this.m_cms.getRequestContext().setAttribute("DONT_USE_CURRENT_SITE_FOR_WORKPLACE_REQUESTS", "true");
                    internalUri = OpenCms.getLinkManager().getRootPath(this.m_cms, targetUri, this.m_relativePath);
                }
                if (!TAG_PARAM.equals(tag.getTagName()) || targetUri.endsWith("?") || targetUri.endsWith("&")) {
                    if (internalUri != null) {
                        internalUri = this.rewriteUri(internalUri);
                        link = this.m_linkTable.addLink(type, internalUri, true);
                        link.checkConsistency(this.m_cms);
                        if ("IMG".equals(tag.getTagName()) || TAG_AREA.equals(tag.getTagName())) {
                            this.setAltAttributeFromTitle(tag, internalUri);
                        }
                    } else {
                        link = this.m_linkTable.addLink(type, targetUri, false);
                    }
                }
                if (link == null) break;
                tag.setAttribute(attr, CmsMacroResolver.formatMacro(link.getName()));
                break;
            }
        }
    }

    protected void processLinkTag(LinkTag tag) {
        this.processLink((Tag)tag, ATTRIBUTE_HREF, CmsRelationType.valueOf(tag.getTagName()));
    }

    protected void processObjectTag(ObjectTag tag) {
        CmsRelationType type = CmsRelationType.valueOf(tag.getTagName());
        for (int i = 0; i < OBJECT_TAG_LINKED_ATTRIBS.length; ++i) {
            String attr = OBJECT_TAG_LINKED_ATTRIBS[i];
            this.processLink((Tag)tag, attr, type);
            if (i == 0 && tag.getAttribute(attr) != null) break;
        }
        SimpleNodeIterator itChildren = tag.children();
        while (itChildren.hasMoreNodes()) {
            Tag childTag;
            Node node = itChildren.nextNode();
            if (!(node instanceof Tag) || !TAG_PARAM.equals((childTag = (Tag)node).getTagName())) continue;
            this.processLink(childTag, ATTRIBUTE_VALUE, type);
        }
    }

    protected void setAltAttributeFromTitle(Tag tag, String internalUri) {
        boolean hasAltAttrib;
        boolean bl = hasAltAttrib = tag.getAttribute("alt") != null;
        if (!hasAltAttrib) {
            String value = null;
            if (internalUri != null && this.m_rootCms != null) {
                try {
                    value = this.m_rootCms.readPropertyObject(internalUri, "Title", false).getValue();
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
            Vector attrs = tag.getAttributesEx();
            attrs.add(1, new Attribute(" "));
            attrs.add(2, new Attribute("alt", value == null ? "" : value, '\"'));
        }
    }

    private String rewriteUri(String internalUri) {
        Object obj;
        if (this.m_cms != null && (obj = this.m_cms.getRequestContext().getAttribute("org.opencms.file.wrapper.CmsObjectWrapper")) != null) {
            CmsObjectWrapper wrapper = (CmsObjectWrapper)obj;
            return wrapper.restoreLink(internalUri);
        }
        return internalUri;
    }

    public static class ExternalLinkWhitelistInfo {
        private Set<String> m_siteRoots;
        private Set<String> m_whitelistEntries;

        public ExternalLinkWhitelistInfo(Set<String> whitelistEntries, Set<String> siteRoots) {
            this.m_siteRoots = siteRoots;
            this.m_whitelistEntries = whitelistEntries;
        }

        public Set<String> getSiteRoots() {
            return this.m_siteRoots;
        }

        public Set<String> getWhitelistEntries() {
            return this.m_whitelistEntries;
        }
    }
}

