/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.util.Comparator;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;

public class CmsExportname {
    private String m_exportname;
    private CmsSite m_site;

    public CmsExportname(String exportname, CmsSite site) {
        this.m_exportname = exportname;
        this.m_site = site;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CmsExportname other = (CmsExportname)obj;
        if (this.m_exportname == null ? other.m_exportname != null : !this.m_exportname.equals(other.m_exportname)) {
            return false;
        }
        return !(this.m_site == null ? other.m_site != null : !this.m_site.equals(other.m_site));
    }

    public String getExportname() {
        return this.m_exportname;
    }

    public CmsSite getSite() {
        return this.m_site;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_exportname == null ? 0 : this.m_exportname.hashCode());
        result = 31 * result + (this.m_site == null ? 0 : this.m_site.hashCode());
        return result;
    }

    public void setExportname(String exportname) {
        this.m_exportname = exportname;
    }

    public void setSite(CmsSite site) {
        this.m_site = site;
    }

    public String toString() {
        return "CmsExportName [m_exportname=" + this.m_exportname + ", m_site=" + String.valueOf(this.m_site) + "]";
    }

    public static class CmsExportNameComparator
    implements Comparator<CmsExportname> {
        private CmsStringUtil.CmsSlashComparator m_comp = new CmsStringUtil.CmsSlashComparator();

        @Override
        public int compare(CmsExportname o1, CmsExportname o2) {
            if (o1.getSite() == null && o2.getSite() == null || o1.getSite() == null && o2.getSite() != null || o1.getSite() != null && o2.getSite() == null || o1.getSite().getSiteRoot().equals(o2.getSite().getSiteRoot())) {
                return this.m_comp.compare(o1.getExportname(), o2.getExportname());
            }
            int siteComp = o1.getSite().getSiteRoot().compareTo(o2.getSite().getSiteRoot());
            if (siteComp == 0) {
                return this.m_comp.compare(o1.getExportname(), o2.getExportname());
            }
            return siteComp;
        }
    }
}

