/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsXmlContainerPageLoader;
import org.opencms.loader.CmsXmlContentLoader;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.staticexport.I_CmsStaticExportHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public abstract class A_CmsStaticExportHandler
implements I_CmsStaticExportHandler {
    private static final Log LOG = CmsLog.getLog(A_CmsStaticExportHandler.class);
    protected boolean m_busy;

    @Override
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    public abstract void performEventPublishProject(CmsUUID var1, I_CmsReport var2);

    public List<CmsPublishedResource> scrubExportFolders(CmsUUID publishHistoryId) {
        List<CmsPublishedResource> publishedResources;
        CmsObject cms;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SCRUBBING_EXPORT_FOLDERS_1", publishHistoryId));
        }
        HashSet<String> scrubbedFolders = new HashSet<String>();
        HashSet<String> scrubbedFiles = new HashSet<String>();
        try {
            cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_FAILED_0"), (Throwable)e);
            return Collections.emptyList();
        }
        try {
            publishedResources = cms.readPublishedResources(publishHistoryId);
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READING_CHANGED_RESOURCES_FAILED_1", publishHistoryId), (Throwable)e);
            return Collections.emptyList();
        }
        publishedResources = this.addMovedLinkSources(cms, publishedResources);
        for (CmsPublishedResource res : publishedResources) {
            if (res.getState().isUnchanged()) continue;
            this.scrubResource(cms, res, scrubbedFolders, scrubbedFiles);
        }
        return publishedResources;
    }

    protected List<CmsPublishedResource> addMovedLinkSources(CmsObject cms, List<CmsPublishedResource> publishedResources) {
        long timer = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SCRUB_EXPORT_START_MOVED_SOURCES_0"));
        }
        publishedResources = new ArrayList<CmsPublishedResource>(publishedResources);
        HashSet<String> pubResources = new HashSet<String>(publishedResources.size());
        for (CmsPublishedResource pubRes : publishedResources) {
            pubResources.add(pubRes.getRootPath());
        }
        boolean modified = true;
        while (modified) {
            modified = false;
            for (CmsPublishedResource res : new ArrayList<CmsPublishedResource>(publishedResources)) {
                List<CmsRelation> relations;
                block10: {
                    if (res.getMovedState() != CmsPublishedResource.STATE_MOVED_DESTINATION) continue;
                    relations = null;
                    try {
                        relations = cms.getRelationsForResource(cms.getRequestContext().removeSiteRoot(res.getRootPath()), CmsRelationFilter.SOURCES);
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block10;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (relations == null || relations.isEmpty()) continue;
                for (CmsRelation relation : relations) {
                    CmsPublishedResource source;
                    block11: {
                        source = null;
                        try {
                            source = new CmsPublishedResource(relation.getSource(cms, CmsResourceFilter.ALL));
                        }
                        catch (CmsException e) {
                            if (!LOG.isWarnEnabled()) break block11;
                            LOG.warn((Object)e.getLocalizedMessage());
                        }
                    }
                    if (source == null || pubResources.contains(source.getRootPath())) continue;
                    modified = true;
                    pubResources.add(source.getRootPath());
                    publishedResources.add(source);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SCRUB_EXPORT_FINISH_MOVED_SOURCES_1", "" + (System.currentTimeMillis() - timer)));
        }
        return publishedResources;
    }

    protected abstract List<File> getRelatedFilesToPurge(String var1, String var2);

    protected List<String> getSiblingsList(CmsObject cms, String resPath) {
        ArrayList<String> siblings;
        block6: {
            siblings = new ArrayList<String>();
            try {
                List<CmsResource> li = cms.readSiblings(resPath, CmsResourceFilter.ALL);
                int l = li.size();
                for (int i = 0; i < l; ++i) {
                    String vfsName = li.get(i).getRootPath();
                    siblings.add(vfsName);
                }
            }
            catch (CmsVfsResourceNotFoundException li) {
            }
            catch (CmsSecurityException li) {
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_FETCHING_SIBLINGS_FAILED_1", resPath), (Throwable)e);
            }
        }
        if (!siblings.contains(resPath)) {
            siblings.add(resPath);
        }
        return siblings;
    }

    protected void purgeFile(String rfsFilePath, String vfsName, CmsObject cms) {
        File[] paramVariants;
        File rfsFile = new File(rfsFilePath);
        this.deleteFile(rfsFile, vfsName);
        this.deleteStaticExportPublishedResource(rfsFile, vfsName, cms);
        File parent = rfsFile.getParentFile();
        if (parent != null && (paramVariants = parent.listFiles(new PrefixFileFilter(rfsFile))) != null) {
            for (int v = 0; v < paramVariants.length; ++v) {
                this.deleteFile(paramVariants[v], vfsName);
                this.deleteStaticExportPublishedResource(paramVariants[v], vfsName, cms);
            }
        }
    }

    protected void scrubResource(CmsObject cms, CmsPublishedResource res, Set<String> scrubbedFolders, Set<String> scrubbedFiles) {
        long timer = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SCRUB_EXPORT_START_RESOURCE_1", res.getRootPath()));
        }
        try {
            String resPath = cms.getRequestContext().removeSiteRoot(res.getRootPath());
            List<String> siblings = this.getSiblingsList(cms, resPath);
            for (String vfsName : siblings) {
                String rfsName = OpenCms.getStaticExportManager().getRfsName(cms, vfsName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_CHECKING_STATIC_EXPORT_2", vfsName, rfsName));
                }
                if (!rfsName.startsWith(OpenCms.getStaticExportManager().getRfsPrefix(vfsName)) || scrubbedFiles.contains(rfsName) || scrubbedFolders.contains(CmsResource.getFolderPath(rfsName))) continue;
                if (res.isFolder()) {
                    if (res.getState().isDeleted()) {
                        String exportFolderName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(vfsName) + rfsName.substring(OpenCms.getStaticExportManager().getRfsPrefix(vfsName).length()));
                        try {
                            File exportFolder = new File(exportFolderName);
                            if (exportFolder.exists() && exportFolder.canWrite()) {
                                CmsFileUtil.purgeDirectory(exportFolder);
                                if (LOG.isInfoEnabled()) {
                                    LOG.info((Object)Messages.get().getBundle().key("LOG_FOLDER_DELETED_1", exportFolderName));
                                }
                                scrubbedFolders.add(rfsName);
                                continue;
                            }
                        }
                        catch (Throwable t) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)Messages.get().getBundle().key("LOG_FOLDER_DELETION_FAILED_2", vfsName, exportFolderName));
                            }
                        }
                    }
                } else {
                    try {
                        String defaultfilePath;
                        CmsResource defaultFile = cms.readDefaultFile(CmsResource.getFolderPath(vfsName));
                        if (defaultFile != null && vfsName.equals(defaultfilePath = cms.getRequestContext().removeSiteRoot(defaultFile.getRootPath()))) {
                            String rfsNameDefault = CmsResource.getFolderPath(rfsName) + "index_export.html";
                            String rfsExportFileName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(vfsName) + rfsNameDefault.substring(OpenCms.getStaticExportManager().getRfsPrefix(vfsName).length()));
                            this.purgeFile(rfsExportFileName, vfsName, cms);
                        }
                    }
                    catch (CmsException defaultFile) {
                        // empty catch block
                    }
                }
                rfsName = OpenCms.getStaticExportManager().addDefaultFileNameToFolder(rfsName, res.isFolder());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_RFSNAME_1", rfsName));
                }
                String rfsExportFileName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(vfsName) + rfsName.substring(OpenCms.getStaticExportManager().getRfsPrefix(vfsName).length()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_EXPORT_RFSNAME_1", rfsName));
                }
                List<File> relFilesToPurge = this.getRelatedFilesToPurge(rfsExportFileName, vfsName);
                this.purgeFiles(relFilesToPurge, vfsName, scrubbedFiles, cms);
                if (!res.isFolder()) {
                    I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(res.getType());
                    I_CmsResourceLoader resLoader = OpenCms.getResourceManager().getLoader(resType.getLoaderId());
                    if (resLoader instanceof CmsXmlContentLoader && !(resLoader instanceof CmsXmlContainerPageLoader)) {
                        List<File> detailPageFiles = this.getDetailPageFiles(cms, res, vfsName);
                        this.purgeFiles(detailPageFiles, vfsName, scrubbedFiles, cms);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_PURGED_DETAILPAGES_0"));
                        }
                        List<File> referencingContainerPages = this.getContainerPagesToPurge(cms, res.getStructureId());
                        this.purgeFiles(referencingContainerPages, vfsName, scrubbedFiles, cms);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_PURGED_CONTAINERPAGES_0"));
                        }
                    }
                }
                this.purgeFile(rfsExportFileName, vfsName, cms);
                scrubbedFiles.add(rfsName);
            }
        }
        catch (Throwable e) {
            LOG.error((Object)e.getLocalizedMessage(), e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SCRUB_EXPORT_FINISH_RESOURCE_2", res.getRootPath(), "" + (System.currentTimeMillis() - timer)));
        }
    }

    private void deleteFile(File file, String vfsName) {
        block6: {
            try {
                if (file.exists() && file.canWrite()) {
                    File parent;
                    file.delete();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_FILE_DELETED_1", this.getRfsName(file, vfsName)));
                    }
                    if ((parent = new File(file.getParent())).listFiles().length == 0 && parent.canWrite()) {
                        parent.delete();
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)Messages.get().getBundle().key("LOG_FILE_DELETED_1", this.getRfsName(file, vfsName)));
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_FILE_DELETION_FAILED_1", this.getRfsName(file, vfsName)), t);
            }
        }
    }

    private void deleteStaticExportPublishedResource(File file, String vfsName, CmsObject cms) {
        block2: {
            CmsStaticExportManager manager = OpenCms.getStaticExportManager();
            String rfsName = this.getRfsName(file, vfsName);
            String rfsExportFileName = rfsName.substring(manager.getRfsPrefix(vfsName).length());
            try {
                cms.deleteStaticExportPublishedResource(rfsExportFileName, 2, null);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)Messages.get().getBundle().key("LOG_PURGED_RFSFILE_1", rfsExportFileName));
            }
        }
    }

    private List<File> getContainerPagesToPurge(CmsObject cms, CmsUUID targetId) {
        try {
            ArrayList<File> purgePages = new ArrayList<File>();
            List<CmsRelation> relations = cms.readRelations(CmsRelationFilter.relationsToStructureId(targetId));
            for (CmsRelation relation : relations) {
                CmsResource source = null;
                try {
                    source = relation.getSource(cms, CmsResourceFilter.ALL);
                }
                catch (CmsPermissionViolationException e) {
                    continue;
                }
                if (CmsResourceTypeXmlContainerPage.isContainerPage(source)) {
                    String vfsName = source.getRootPath();
                    String rfsName = OpenCms.getStaticExportManager().getRfsName(cms, vfsName);
                    String exportPath = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(vfsName));
                    String rfsExportFileName = exportPath + rfsName.substring(OpenCms.getStaticExportManager().getRfsPrefix(vfsName).length());
                    File file = new File(rfsExportFileName);
                    purgePages.add(file);
                    continue;
                }
                if (targetId.equals(source.getStructureId()) && OpenCms.getResourceManager().getResourceType(source.getTypeId()).getTypeName().equals("groupcontainer")) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_WARN_ELEMENT_GROUP_REFERENCES_SELF_1", source.getRootPath()));
                    continue;
                }
                if (!OpenCms.getResourceManager().getResourceType(source.getTypeId()).getTypeName().equals("groupcontainer")) continue;
                purgePages.addAll(this.getContainerPagesToPurge(cms, source.getStructureId()));
            }
            return purgePages;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<File> getDetailPageFiles(CmsObject cms, CmsPublishedResource res, String vfsName) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            if (OpenCms.getRunLevel() < 4) {
                return files;
            }
            List<String> urlNames = cms.getAllUrlNames(res.getStructureId());
            Collection<String> detailpages = OpenCms.getADEManager().getDetailPageHandler().getAllDetailPages(cms, res.getType());
            for (String urlName : urlNames) {
                for (String detailPage : detailpages) {
                    String rfsName = CmsStringUtil.joinPaths(OpenCms.getStaticExportManager().getRfsName(cms, detailPage), urlName, "index.html");
                    String rfsExportFileName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(vfsName) + rfsName.substring(OpenCms.getStaticExportManager().getRfsPrefix(vfsName).length()));
                    File file = new File(rfsExportFileName);
                    if (!file.exists() || files.contains(file)) continue;
                    files.add(file);
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return files;
    }

    private String getRfsName(File file, String vfsName) {
        CmsStaticExportManager manager = OpenCms.getStaticExportManager();
        String filePath = file.getAbsolutePath();
        String result = CmsFileUtil.normalizePath(manager.getRfsPrefix(vfsName) + filePath.substring(OpenCms.getStaticExportManager().getExportPath(vfsName).length()));
        return CmsStringUtil.substitute(result, new String(new char[]{File.separatorChar}), "/");
    }

    private void purgeFiles(List<File> files, String vfsName, Set<String> scrubbedFiles, CmsObject cms) {
        for (File file : files) {
            this.purgeFile(file.getAbsolutePath(), vfsName, cms);
            String rfsName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getRfsPrefix(vfsName) + "/" + file.getAbsolutePath().substring(OpenCms.getStaticExportManager().getExportPath(vfsName).length()));
            rfsName = CmsStringUtil.substitute(rfsName, new String(new char[]{File.separatorChar}), "/");
            scrubbedFiles.add(rfsName);
        }
    }

    private static class PrefixFileFilter
    implements FileFilter {
        private String m_baseExtension;
        private String m_baseName;

        public PrefixFileFilter(File baseFile) {
            String fileName = baseFile.getName();
            this.m_baseExtension = CmsFileUtil.getExtension(fileName);
            this.m_baseName = fileName + "_";
        }

        @Override
        public boolean accept(File f) {
            return f.getName().startsWith(this.m_baseName) && f.getName().endsWith(this.m_baseExtension);
        }
    }
}

