/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site.xmlsitemap;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;

public class CmsXmlSitemapUrlBean {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private String m_changeFrequency;
    private CmsResource m_detailPageResource;
    private Date m_lastModified;
    private Locale m_locale;
    private CmsResource m_origResource;
    private double m_priority;
    private String m_subsite;
    private String m_url;

    public CmsXmlSitemapUrlBean(String url, long lastModified, String changeFrequency, double priority) {
        this.m_url = url;
        if (lastModified >= 0L) {
            this.m_lastModified = new Date(lastModified);
        }
        this.m_changeFrequency = changeFrequency;
        this.m_priority = priority;
    }

    private static String formatDate(Date date) {
        String dateStr = dateFormat.format(date);
        return dateStr.substring(0, 22) + ":" + dateStr.substring(22);
    }

    public String getChangeFrequency() {
        return this.m_changeFrequency;
    }

    public Date getDateLastModified() {
        return this.m_lastModified;
    }

    public CmsResource getDetailPageResource() {
        return this.m_detailPageResource;
    }

    public String getFormattedDate() {
        return CmsXmlSitemapUrlBean.formatDate(this.m_lastModified);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public CmsResource getOriginalResource() {
        return this.m_origResource;
    }

    public double getPriority() {
        return this.m_priority;
    }

    public String getSubsite() {
        return this.m_subsite;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setDetailPageResource(CmsResource detailPageResource) {
        this.m_detailPageResource = detailPageResource;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setOriginalResource(CmsResource resource) {
        this.m_origResource = resource;
    }

    public void setSubsite(String subsite) {
        this.m_subsite = subsite;
    }

    public String toString() {
        return this.m_url + "   [" + ReflectionToStringBuilder.toString((Object)this) + "]";
    }

    public void writeChangefreq(StringBuffer buffer) {
        if (this.m_changeFrequency != null) {
            this.writeElement(buffer, "changefreq", this.getChangeFrequency());
        }
    }

    public void writeElement(StringBuffer buffer, String tag, String content) {
        buffer.append("<" + tag + ">");
        buffer.append(CmsEncoder.escapeXml(content));
        buffer.append("</" + tag + ">");
    }

    public void writeLastmod(StringBuffer buffer) {
        if (this.m_lastModified != null) {
            this.writeElement(buffer, "lastmod", this.getFormattedDate());
        }
    }

    public void writePriority(StringBuffer buffer) {
        if (this.m_priority >= 0.0 && this.m_priority <= 1.0) {
            this.writeElement(buffer, "priority", "" + this.getPriority());
        }
    }
}

